/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestRestartCluster {
    private static final Log LOG = LogFactory.getLog(TestRestartCluster.class);
    private HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] TABLENAME = Bytes.toBytes((String)"master_transitions");
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"a")};
    private static final byte[][] TABLES = new byte[][]{Bytes.toBytes((String)"restartTableOne"), Bytes.toBytes((String)"restartTableTwo"), Bytes.toBytes((String)"restartTableThree")};
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @After
    public void tearDown() throws Exception {
        this.UTIL.shutdownMiniCluster();
    }

    @Test(timeout=300000L)
    public void testRestartClusterAfterKill() throws Exception {
        this.UTIL.startMiniZKCluster();
        ZooKeeperWatcher zooKeeper = new ZooKeeperWatcher(this.UTIL.getConfiguration(), "cluster1", null, true);
        String unassignedZNode = zooKeeper.assignmentZNode;
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)zooKeeper, (String)unassignedZNode);
        ServerName sn = new ServerName("master", -1, System.currentTimeMillis());
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zooKeeper, (HRegionInfo)HRegionInfo.ROOT_REGIONINFO, (ServerName)sn);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zooKeeper, (HRegionInfo)HRegionInfo.FIRST_META_REGIONINFO, (ServerName)sn);
        LOG.debug((Object)("Created UNASSIGNED zNode for ROOT and META regions in state " + EventHandler.EventType.M_ZK_REGION_OFFLINE));
        LOG.info((Object)"Starting HBase cluster...");
        this.UTIL.startMiniCluster(2);
        this.UTIL.createTable(TABLENAME, FAMILIES);
        LOG.info((Object)"Created a table, waiting for table to be available...");
        this.UTIL.waitTableAvailable(TABLENAME, 60000L);
        LOG.info((Object)"Master deleted unassigned region and started up successfully.");
    }

    @Test(timeout=300000L)
    public void testClusterRestart() throws Exception {
        this.UTIL.startMiniCluster(3);
        while (!this.UTIL.getMiniHBaseCluster().getMaster().isInitialized()) {
            Threads.sleep((long)1L);
        }
        LOG.info((Object)"\n\nCreating tables");
        for (byte[] TABLE : TABLES) {
            this.UTIL.createTable(TABLE, FAMILY);
        }
        for (byte[] TABLE : TABLES) {
            this.UTIL.waitTableAvailable(TABLE, 30000L);
        }
        List allRegions = MetaScanner.listAllRegions((Configuration)this.UTIL.getConfiguration());
        Assert.assertEquals((long)3L, (long)allRegions.size());
        LOG.info((Object)"\n\nShutting down cluster");
        this.UTIL.shutdownMiniHBaseCluster();
        LOG.info((Object)"\n\nSleeping a bit");
        Thread.sleep(2000L);
        LOG.info((Object)"\n\nStarting cluster the second time");
        this.UTIL.restartHBaseCluster(3);
        allRegions = MetaScanner.listAllRegions((Configuration)new Configuration(this.UTIL.getConfiguration()));
        Assert.assertEquals((long)3L, (long)allRegions.size());
        LOG.info((Object)"\n\nWaiting for tables to be available");
        for (byte[] TABLE : TABLES) {
            try {
                this.UTIL.createTable(TABLE, FAMILY);
                Assert.assertTrue((String)"Able to create table that should already exist", (boolean)false);
            }
            catch (TableExistsException tee) {
                LOG.info((Object)"Table already exists as expected");
            }
            this.UTIL.waitTableAvailable(TABLE, 30000L);
        }
    }
}

