/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.handler.TotesHRegionInfo;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionAlreadyInTransitionException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.Writables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

@Category(value={MediumTests.class})
public class TestZKBasedOpenCloseRegion {
    private static final Log LOG = LogFactory.getLog(TestZKBasedOpenCloseRegion.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String TABLENAME = "TestZKBasedOpenCloseRegion";
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
    private static int countOfRegions;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        Configuration c = TEST_UTIL.getConfiguration();
        c.setClass("hbase.regionserver.impl", TestZKBasedOpenCloseRegionRegionServer.class, HRegionServer.class);
        c.setBoolean("dfs.support.append", true);
        c.setInt("hbase.regionserver.info.port", 0);
        TEST_UTIL.startMiniCluster(2);
        TEST_UTIL.createTable(Bytes.toBytes((String)TABLENAME), FAMILIES);
        HTable t = new HTable(TEST_UTIL.getConfiguration(), TABLENAME);
        countOfRegions = TEST_UTIL.createMultiRegions(t, TestZKBasedOpenCloseRegion.getTestFamily());
        TestZKBasedOpenCloseRegion.waitUntilAllRegionsAssigned();
        TestZKBasedOpenCloseRegion.addToEachStartKey(countOfRegions);
        t.close();
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException {
        if (TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads().size() < 2) {
            LOG.info((Object)("Started new server=" + TEST_UTIL.getHBaseCluster().startRegionServer()));
        }
        TestZKBasedOpenCloseRegion.waitUntilAllRegionsAssigned();
    }

    @Test(timeout=300000L)
    public void testReOpenRegion() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        LOG.info((Object)("Number of region servers = " + cluster.getLiveRegionServerThreads().size()));
        int rsIdx = 0;
        HRegionServer regionServer = TEST_UTIL.getHBaseCluster().getRegionServer(rsIdx);
        HRegionInfo hri = this.getNonMetaRegion(regionServer.getOnlineRegions());
        LOG.debug((Object)("Asking RS to close region " + hri.getRegionNameAsString()));
        AtomicBoolean closeEventProcessed = new AtomicBoolean(false);
        AtomicBoolean reopenEventProcessed = new AtomicBoolean(false);
        ReopenEventListener closeListener = new ReopenEventListener(hri.getRegionNameAsString(), closeEventProcessed, EventHandler.EventType.RS_ZK_REGION_CLOSED);
        cluster.getMaster().executorService.registerListener(EventHandler.EventType.RS_ZK_REGION_CLOSED, (EventHandler.EventHandlerListener)closeListener);
        ReopenEventListener openListener = new ReopenEventListener(hri.getRegionNameAsString(), reopenEventProcessed, EventHandler.EventType.RS_ZK_REGION_OPENED);
        cluster.getMaster().executorService.registerListener(EventHandler.EventType.RS_ZK_REGION_OPENED, (EventHandler.EventHandlerListener)openListener);
        LOG.info((Object)("Unassign " + hri.getRegionNameAsString()));
        cluster.getMaster().assignmentManager.unassign(hri);
        while (!closeEventProcessed.get()) {
            Threads.sleep((long)100L);
        }
        while (!reopenEventProcessed.get()) {
            Threads.sleep((long)100L);
        }
        LOG.info((Object)"Done with testReOpenRegion");
    }

    private HRegionInfo getNonMetaRegion(Collection<HRegionInfo> regions) {
        HRegionInfo hri = null;
        for (HRegionInfo i : regions) {
            LOG.info((Object)i.getRegionNameAsString());
            if (i.isMetaRegion()) continue;
            hri = i;
            break;
        }
        return hri;
    }

    @Test
    public void testRSAlreadyProcessingRegion() throws Exception {
        LOG.info((Object)"starting testRSAlreadyProcessingRegion");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HRegionServer hr0 = cluster.getLiveRegionServerThreads().get(0).getRegionServer();
        HRegionServer hr1 = cluster.getLiveRegionServerThreads().get(1).getRegionServer();
        HRegionInfo hri = this.getNonMetaRegion(hr0.getOnlineRegions());
        ((TestZKBasedOpenCloseRegionRegionServer)hr1).addRegionsInTransition(hri, "OPEN");
        AtomicBoolean reopenEventProcessed = new AtomicBoolean(false);
        ReopenEventListener openListener = new ReopenEventListener(hri.getRegionNameAsString(), reopenEventProcessed, EventHandler.EventType.RS_ZK_REGION_OPENED);
        cluster.getMaster().executorService.registerListener(EventHandler.EventType.RS_ZK_REGION_OPENED, (EventHandler.EventHandlerListener)openListener);
        TEST_UTIL.getHBaseAdmin().move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)hr1.getServerName().toString()));
        Assert.assertEquals((Object)hr1.getOnlineRegion(hri.getEncodedNameAsBytes()), null);
        hr1.removeFromRegionsInTransition(hri);
        reopenEventProcessed.set(false);
        hri = this.getNonMetaRegion(hr1.getOnlineRegions());
        openListener = new ReopenEventListener(hri.getRegionNameAsString(), reopenEventProcessed, EventHandler.EventType.RS_ZK_REGION_OPENED);
        cluster.getMaster().executorService.registerListener(EventHandler.EventType.RS_ZK_REGION_OPENED, (EventHandler.EventHandlerListener)openListener);
        TEST_UTIL.getHBaseAdmin().move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)hr0.getServerName().toString()));
        while (!reopenEventProcessed.get()) {
            Threads.sleep((long)100L);
        }
        Assert.assertTrue((hr1.getOnlineRegion(hri.getEncodedNameAsBytes()) == null ? 1 : 0) != 0);
    }

    @Test(timeout=300000L)
    public void testCloseRegion() throws Exception {
        LOG.info((Object)"Running testCloseRegion");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        LOG.info((Object)("Number of region servers = " + cluster.getLiveRegionServerThreads().size()));
        int rsIdx = 0;
        HRegionServer regionServer = TEST_UTIL.getHBaseCluster().getRegionServer(rsIdx);
        HRegionInfo hri = this.getNonMetaRegion(regionServer.getOnlineRegions());
        LOG.debug((Object)("Asking RS to close region " + hri.getRegionNameAsString()));
        AtomicBoolean closeEventProcessed = new AtomicBoolean(false);
        CloseRegionEventListener listener = new CloseRegionEventListener(hri.getRegionNameAsString(), closeEventProcessed);
        cluster.getMaster().executorService.registerListener(EventHandler.EventType.RS_ZK_REGION_CLOSED, (EventHandler.EventHandlerListener)listener);
        cluster.getMaster().assignmentManager.unassign(hri);
        while (!closeEventProcessed.get()) {
            Threads.sleep((long)100L);
        }
        LOG.info((Object)"Done with testCloseRegion");
    }

    @Test
    public void testRegionOpenFailsDueToIOException() throws Exception {
        HRegionInfo REGIONINFO = new HRegionInfo(Bytes.toBytes((String)"t"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_START_ROW);
        HRegionServer regionServer = TEST_UTIL.getHBaseCluster().getRegionServer(0);
        TableDescriptors htd = (TableDescriptors)Mockito.mock(TableDescriptors.class);
        Object orizinalState = Whitebox.getInternalState((Object)regionServer, (String)"tableDescriptors");
        Whitebox.setInternalState((Object)regionServer, (String)"tableDescriptors", (Object)htd);
        ((TableDescriptors)Mockito.doThrow((Throwable)new IOException()).when((Object)htd)).get((byte[])Mockito.any());
        try {
            regionServer.openRegion(REGIONINFO);
            Assert.fail((String)"It should throw IOException ");
        }
        catch (IOException e) {
            // empty catch block
        }
        Whitebox.setInternalState((Object)regionServer, (String)"tableDescriptors", (Object)orizinalState);
        Assert.assertFalse((String)"Region should not be in RIT", (boolean)regionServer.containsKeyInRegionsInTransition(REGIONINFO));
    }

    private static void waitUntilAllRegionsAssigned() throws IOException {
        HTable meta = new HTable(TEST_UTIL.getConfiguration(), HConstants.META_TABLE_NAME);
        while (true) {
            byte[] b;
            int rows = 0;
            Scan scan = new Scan();
            scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
            ResultScanner s = meta.getScanner(scan);
            Result r = null;
            while ((r = s.next()) != null && (b = r.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER)) != null && b.length > 0) {
                ++rows;
            }
            s.close();
            if (rows >= countOfRegions) break;
            LOG.info((Object)("Found=" + rows));
            Threads.sleep((long)1000L);
        }
        meta.close();
    }

    private static int addToEachStartKey(int expected) throws IOException {
        byte[] b;
        HTable t = new HTable(TEST_UTIL.getConfiguration(), TABLENAME);
        HTable meta = new HTable(TEST_UTIL.getConfiguration(), HConstants.META_TABLE_NAME);
        int rows = 0;
        Scan scan = new Scan();
        scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        ResultScanner s = meta.getScanner(scan);
        Result r = null;
        while ((r = s.next()) != null && (b = r.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER)) != null && b.length > 0) {
            HRegionInfo hri = Writables.getHRegionInfo((byte[])b);
            byte[] row = TestZKBasedOpenCloseRegion.getStartKey(hri);
            Put p = new Put(row);
            p.setWriteToWAL(false);
            p.add(TestZKBasedOpenCloseRegion.getTestFamily(), TestZKBasedOpenCloseRegion.getTestQualifier(), row);
            t.put(p);
            ++rows;
        }
        s.close();
        Assert.assertEquals((long)expected, (long)rows);
        t.close();
        meta.close();
        return rows;
    }

    private static byte[] getStartKey(HRegionInfo hri) {
        return Bytes.equals((byte[])HConstants.EMPTY_START_ROW, (byte[])hri.getStartKey()) ? Bytes.toBytes((String)"aaa") : hri.getStartKey();
    }

    private static byte[] getTestFamily() {
        return FAMILIES[0];
    }

    private static byte[] getTestQualifier() {
        return TestZKBasedOpenCloseRegion.getTestFamily();
    }

    public static void main(String[] args) throws Exception {
        TestZKBasedOpenCloseRegion.beforeAllTests();
        TestZKBasedOpenCloseRegion test = new TestZKBasedOpenCloseRegion();
        test.setup();
        test.testCloseRegion();
        TestZKBasedOpenCloseRegion.afterAllTests();
    }

    public static class CloseRegionEventListener
    implements EventHandler.EventHandlerListener {
        private static final Log LOG = LogFactory.getLog(CloseRegionEventListener.class);
        String regionToClose;
        AtomicBoolean closeEventProcessed;

        public CloseRegionEventListener(String regionToClose, AtomicBoolean closeEventProcessed) {
            this.regionToClose = regionToClose;
            this.closeEventProcessed = closeEventProcessed;
        }

        public void afterProcess(EventHandler event) {
            LOG.info((Object)("afterProcess(" + event + ")"));
            if (event.getEventType() == EventHandler.EventType.RS_ZK_REGION_CLOSED) {
                LOG.info((Object)"Finished processing CLOSE REGION");
                TotesHRegionInfo hriCarrier = (TotesHRegionInfo)event;
                if (this.regionToClose.equals(hriCarrier.getHRegionInfo().getRegionNameAsString())) {
                    LOG.info((Object)"Setting closeEventProcessed flag");
                    this.closeEventProcessed.set(true);
                } else {
                    LOG.info((Object)"Region to close didn't match");
                }
            }
        }

        public void beforeProcess(EventHandler event) {
            if (event.getEventType() == EventHandler.EventType.M_RS_CLOSE_REGION) {
                LOG.info((Object)"Received CLOSE RPC and beginning to process it");
            }
        }
    }

    public static class ReopenEventListener
    implements EventHandler.EventHandlerListener {
        private static final Log LOG = LogFactory.getLog(ReopenEventListener.class);
        String regionName;
        AtomicBoolean eventProcessed;
        EventHandler.EventType eventType;

        public ReopenEventListener(String regionName, AtomicBoolean eventProcessed, EventHandler.EventType eventType) {
            this.regionName = regionName;
            this.eventProcessed = eventProcessed;
            this.eventType = eventType;
        }

        public void beforeProcess(EventHandler event) {
            if (event.getEventType() == this.eventType) {
                LOG.info((Object)("Received " + this.eventType + " and beginning to process it"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterProcess(EventHandler event) {
            LOG.info((Object)("afterProcess(" + event + ")"));
            if (event.getEventType() == this.eventType) {
                TotesHRegionInfo hriCarrier;
                LOG.info((Object)("Finished processing " + this.eventType));
                String regionName = "";
                if (this.eventType == EventHandler.EventType.RS_ZK_REGION_OPENED) {
                    hriCarrier = (TotesHRegionInfo)event;
                    regionName = hriCarrier.getHRegionInfo().getRegionNameAsString();
                } else if (this.eventType == EventHandler.EventType.RS_ZK_REGION_CLOSED) {
                    hriCarrier = (TotesHRegionInfo)event;
                    regionName = hriCarrier.getHRegionInfo().getRegionNameAsString();
                }
                if (this.regionName.equals(regionName)) {
                    this.eventProcessed.set(true);
                }
                AtomicBoolean atomicBoolean = this.eventProcessed;
                synchronized (atomicBoolean) {
                    this.eventProcessed.notifyAll();
                }
            }
        }
    }

    public static class TestZKBasedOpenCloseRegionRegionServer
    extends HRegionServer {
        public TestZKBasedOpenCloseRegionRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        public void addRegionsInTransition(HRegionInfo region, String currentAction) throws RegionAlreadyInTransitionException {
            super.addRegionsInTransition(region, currentAction);
        }
    }
}

