/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import com.yammer.metrics.stats.ExponentiallyDecayingSample;
import com.yammer.metrics.stats.Snapshot;
import junit.framework.Assert;
import org.apache.hadoop.hbase.SmallTests;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestExponentiallyDecayingSample {
    @Test
    public void testBasic() {
        ExponentiallyDecayingSample sample = new ExponentiallyDecayingSample(100, 0.99);
        for (int i = 0; i < 1000; ++i) {
            sample.update((long)i);
        }
        Assert.assertEquals((int)100, (int)sample.size());
        Snapshot snapshot = sample.getSnapshot();
        Assert.assertEquals((int)100, (int)snapshot.size());
        for (double i : snapshot.getValues()) {
            Assert.assertTrue((i >= 0.0 && i < 1000.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTooBig() throws Exception {
        ExponentiallyDecayingSample sample = new ExponentiallyDecayingSample(100, 0.99);
        for (int i = 0; i < 10; ++i) {
            sample.update((long)i);
        }
        Assert.assertEquals((int)10, (int)sample.size());
        Snapshot snapshot = sample.getSnapshot();
        Assert.assertEquals((int)10, (int)sample.size());
        for (double i : snapshot.getValues()) {
            Assert.assertTrue((i >= 0.0 && i < 1000.0 ? 1 : 0) != 0);
        }
    }
}

