/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import com.yammer.metrics.stats.Snapshot;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.metrics.histogram.MetricsHistogram;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMetricsHistogram {
    @Test
    public void testBasicUniform() {
        MetricsHistogram h = new MetricsHistogram("testHistogram", null);
        for (int i = 0; i < 100; ++i) {
            h.update(i);
        }
        Assert.assertEquals((long)100L, (long)h.getCount());
        Assert.assertEquals((long)0L, (long)h.getMin());
        Assert.assertEquals((long)99L, (long)h.getMax());
    }

    private static int safeIndex(int i, int len) {
        if (i < len && i >= 0) {
            return i;
        }
        if (i >= len) {
            return len - 1;
        }
        return 0;
    }

    @Test
    public void testRandom() {
        Random r = new Random();
        MetricsHistogram h = new MetricsHistogram("testHistogram", null);
        long[] data = new long[1000];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (long)(r.nextGaussian() * 10000.0);
            h.update(data[i]);
        }
        Snapshot s = h.getSnapshot();
        Arrays.sort(data);
        int slop = 20;
        int medianIndex = data.length / 2;
        long minAcceptableMedian = data[TestMetricsHistogram.safeIndex(medianIndex - 20, data.length)];
        long maxAcceptableMedian = data[TestMetricsHistogram.safeIndex(medianIndex + 20, data.length)];
        Assert.assertTrue((s.getMedian() >= (double)minAcceptableMedian && s.getMedian() <= (double)maxAcceptableMedian ? 1 : 0) != 0);
        int seventyFifthIndex = (int)((double)data.length * 0.75);
        long minAcceptableseventyFifth = data[TestMetricsHistogram.safeIndex(seventyFifthIndex - 20, data.length)];
        long maxAcceptableseventyFifth = data[TestMetricsHistogram.safeIndex(seventyFifthIndex + 20, data.length)];
        Assert.assertTrue((s.get75thPercentile() >= (double)minAcceptableseventyFifth && s.get75thPercentile() <= (double)maxAcceptableseventyFifth ? 1 : 0) != 0);
        int ninetyFifthIndex = (int)((double)data.length * 0.95);
        long minAcceptableninetyFifth = data[TestMetricsHistogram.safeIndex(ninetyFifthIndex - 20, data.length)];
        long maxAcceptableninetyFifth = data[TestMetricsHistogram.safeIndex(ninetyFifthIndex + 20, data.length)];
        Assert.assertTrue((s.get95thPercentile() >= (double)minAcceptableninetyFifth && s.get95thPercentile() <= (double)maxAcceptableninetyFifth ? 1 : 0) != 0);
    }
}

