/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.monitoring;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestTaskMonitor {
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testTaskMonitorBasics() {
        TaskMonitor tm = new TaskMonitor();
        Assert.assertTrue((String)"Task monitor should start empty", (boolean)tm.getTasks().isEmpty());
        MonitoredTask task = tm.createStatus("Test task");
        MonitoredTask taskFromTm = (MonitoredTask)tm.getTasks().get(0);
        Assert.assertEquals((Object)task.getDescription(), (Object)taskFromTm.getDescription());
        Assert.assertEquals((long)-1L, (long)taskFromTm.getCompletionTimestamp());
        Assert.assertEquals((Object)MonitoredTask.State.RUNNING, (Object)taskFromTm.getState());
        task.markComplete("Finished!");
        Assert.assertEquals((Object)MonitoredTask.State.COMPLETE, (Object)task.getState());
        Assert.assertEquals((long)1L, (long)tm.getTasks().size());
        task.expireNow();
        Assert.assertEquals((long)0L, (long)tm.getTasks().size());
    }

    @Test
    public void testTasksGetAbortedOnLeak() throws InterruptedException {
        final TaskMonitor tm = new TaskMonitor();
        Assert.assertTrue((String)"Task monitor should start empty", (boolean)tm.getTasks().isEmpty());
        final AtomicBoolean threadSuccess = new AtomicBoolean(false);
        Thread t = new Thread(){

            @Override
            public void run() {
                MonitoredTask task = tm.createStatus("Test task");
                Assert.assertEquals((Object)MonitoredTask.State.RUNNING, (Object)task.getState());
                threadSuccess.set(true);
            }
        };
        t.start();
        t.join();
        Assert.assertTrue((boolean)threadSuccess.get());
        System.gc();
        System.gc();
        System.gc();
        MonitoredTask taskFromTm = (MonitoredTask)tm.getTasks().get(0);
        Assert.assertEquals((Object)MonitoredTask.State.ABORTED, (Object)taskFromTm.getState());
    }

    @Test
    public void testTaskLimit() throws Exception {
        TaskMonitor tm = new TaskMonitor();
        for (int i = 0; i < 1010; ++i) {
            tm.createStatus("task " + i);
        }
        Assert.assertEquals((long)1000L, (long)tm.getTasks().size());
        Assert.assertEquals((Object)"task 10", (Object)((MonitoredTask)tm.getTasks().get(0)).getDescription());
    }
}

