/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestColumnSeeking {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    static final Log LOG = LogFactory.getLog(TestColumnSeeking.class);
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateVersions() throws IOException {
        String family = "Family";
        byte[] familyBytes = Bytes.toBytes((String)"Family");
        String table = "TestDuplicateVersions";
        HColumnDescriptor hcd = new HColumnDescriptor(familyBytes).setMaxVersions(1000);
        HTableDescriptor htd = new HTableDescriptor(table);
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(Bytes.toBytes((String)table), null, null, false);
        HRegion region = HRegion.createHRegion((HRegionInfo)info, (Path)TEST_UTIL.getDataTestDir(), (Configuration)TEST_UTIL.getConfiguration(), (HTableDescriptor)htd);
        try {
            List<String> rows = this.generateRandomWords(10, "row");
            List<String> allColumns = this.generateRandomWords(10, "column");
            List<String> values = this.generateRandomWords(100, "value");
            long maxTimestamp = 2L;
            double selectPercent = 0.5;
            int numberOfTests = 5;
            double flushPercentage = 0.2;
            double minorPercentage = 0.2;
            double majorPercentage = 0.2;
            double putPercentage = 0.2;
            HashMap<String, KeyValue> allKVMap = new HashMap<String, KeyValue>();
            HashMap[] kvMaps = new HashMap[numberOfTests];
            ArrayList[] columnLists = new ArrayList[numberOfTests];
            for (int i = 0; i < numberOfTests; ++i) {
                kvMaps[i] = new HashMap();
                columnLists[i] = new ArrayList();
                for (String column : allColumns) {
                    if (!(Math.random() < selectPercent)) continue;
                    columnLists[i].add(column);
                }
            }
            for (String value : values) {
                for (String row : rows) {
                    Put p = new Put(Bytes.toBytes((String)row));
                    p.setWriteToWAL(false);
                    for (String column : allColumns) {
                        for (long timestamp = 1L; timestamp <= maxTimestamp; ++timestamp) {
                            KeyValue kv = KeyValueTestUtil.create(row, family, column, timestamp, value);
                            if (!(Math.random() < putPercentage)) continue;
                            p.add(kv);
                            allKVMap.put(kv.getKeyString(), kv);
                            for (int i = 0; i < numberOfTests; ++i) {
                                if (!columnLists[i].contains(column)) continue;
                                kvMaps[i].put(kv.getKeyString(), kv);
                            }
                        }
                    }
                    region.put(p);
                    if (Math.random() < flushPercentage) {
                        LOG.info((Object)"Flushing... ");
                        region.flushcache();
                    }
                    if (Math.random() < minorPercentage) {
                        LOG.info((Object)"Minor compacting... ");
                        region.compactStores(false);
                    }
                    if (!(Math.random() < majorPercentage)) continue;
                    LOG.info((Object)"Major compacting... ");
                    region.compactStores(true);
                }
            }
            for (int i = 0; i < numberOfTests + 1; ++i) {
                Collection kvSet;
                Scan scan = new Scan();
                scan.setMaxVersions();
                if (i < numberOfTests) {
                    if (columnLists[i].size() == 0) continue;
                    kvSet = kvMaps[i].values();
                    for (String column : columnLists[i]) {
                        scan.addColumn(familyBytes, Bytes.toBytes((String)column));
                    }
                    LOG.info((Object)"ExplicitColumns scanner");
                    LOG.info((Object)("Columns: " + columnLists[i].size() + "  Keys: " + kvSet.size()));
                } else {
                    kvSet = allKVMap.values();
                    LOG.info((Object)"Wildcard scanner");
                    LOG.info((Object)("Columns: " + allColumns.size() + "  Keys: " + kvSet.size()));
                }
                RegionScanner scanner = region.getScanner(scan);
                ArrayList results = new ArrayList();
                while (scanner.next(results)) {
                }
                Assert.assertEquals((long)kvSet.size(), (long)results.size());
                Assert.assertTrue((boolean)results.containsAll(kvSet));
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)region);
        }
        region.close();
        region.getLog().closeAndDelete();
    }

    @Test
    public void testReseeking() throws IOException {
        String family = "Family";
        byte[] familyBytes = Bytes.toBytes((String)"Family");
        String table = "TestSingleVersions";
        HTableDescriptor htd = new HTableDescriptor(table);
        htd.addFamily(new HColumnDescriptor(family));
        HRegionInfo info = new HRegionInfo(Bytes.toBytes((String)table), null, null, false);
        HRegion region = HRegion.createHRegion((HRegionInfo)info, (Path)TEST_UTIL.getDataTestDir(), (Configuration)TEST_UTIL.getConfiguration(), (HTableDescriptor)htd);
        List<String> rows = this.generateRandomWords(10, "row");
        List<String> allColumns = this.generateRandomWords(100, "column");
        long maxTimestamp = 2L;
        double selectPercent = 0.5;
        int numberOfTests = 5;
        double flushPercentage = 0.2;
        double minorPercentage = 0.2;
        double majorPercentage = 0.2;
        double putPercentage = 0.2;
        HashMap<String, KeyValue> allKVMap = new HashMap<String, KeyValue>();
        HashMap[] kvMaps = new HashMap[numberOfTests];
        ArrayList[] columnLists = new ArrayList[numberOfTests];
        String valueString = "Value";
        for (int i = 0; i < numberOfTests; ++i) {
            kvMaps[i] = new HashMap();
            columnLists[i] = new ArrayList();
            for (String column : allColumns) {
                if (!(Math.random() < selectPercent)) continue;
                columnLists[i].add(column);
            }
        }
        for (String row : rows) {
            Put p = new Put(Bytes.toBytes((String)row));
            p.setWriteToWAL(false);
            for (String column : allColumns) {
                for (long timestamp = 1L; timestamp <= maxTimestamp; ++timestamp) {
                    KeyValue kv = KeyValueTestUtil.create(row, family, column, timestamp, valueString);
                    if (!(Math.random() < putPercentage)) continue;
                    p.add(kv);
                    allKVMap.put(kv.getKeyString(), kv);
                    for (int i = 0; i < numberOfTests; ++i) {
                        if (!columnLists[i].contains(column)) continue;
                        kvMaps[i].put(kv.getKeyString(), kv);
                    }
                }
            }
            region.put(p);
            if (Math.random() < flushPercentage) {
                LOG.info((Object)"Flushing... ");
                region.flushcache();
            }
            if (Math.random() < minorPercentage) {
                LOG.info((Object)"Minor compacting... ");
                region.compactStores(false);
            }
            if (!(Math.random() < majorPercentage)) continue;
            LOG.info((Object)"Major compacting... ");
            region.compactStores(true);
        }
        for (int i = 0; i < numberOfTests + 1; ++i) {
            Collection kvSet;
            Scan scan = new Scan();
            scan.setMaxVersions();
            if (i < numberOfTests) {
                if (columnLists[i].size() == 0) continue;
                kvSet = kvMaps[i].values();
                for (String column : columnLists[i]) {
                    scan.addColumn(familyBytes, Bytes.toBytes((String)column));
                }
                LOG.info((Object)"ExplicitColumns scanner");
                LOG.info((Object)("Columns: " + columnLists[i].size() + "  Keys: " + kvSet.size()));
            } else {
                kvSet = allKVMap.values();
                LOG.info((Object)"Wildcard scanner");
                LOG.info((Object)("Columns: " + allColumns.size() + "  Keys: " + kvSet.size()));
            }
            RegionScanner scanner = region.getScanner(scan);
            ArrayList results = new ArrayList();
            while (scanner.next(results)) {
            }
            Assert.assertEquals((long)kvSet.size(), (long)results.size());
            Assert.assertTrue((boolean)results.containsAll(kvSet));
        }
        region.close();
        region.getLog().closeAndDelete();
    }

    List<String> generateRandomWords(int numberOfWords, String suffix) {
        HashSet<String> wordSet = new HashSet<String>();
        for (int i = 0; i < numberOfWords; ++i) {
            int lengthOfWords = (int)(Math.random() * 5.0) + 1;
            char[] wordChar = new char[lengthOfWords];
            for (int j = 0; j < wordChar.length; ++j) {
                wordChar[j] = (char)(Math.random() * 26.0 + 97.0);
            }
            String word = suffix == null ? new String(wordChar) : new String(wordChar) + suffix;
            wordSet.add(word);
        }
        ArrayList<String> wordList = new ArrayList<String>(wordSet);
        return wordList;
    }
}

