/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCompactSelection
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestCompactSelection.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Configuration conf;
    private Store store;
    private static final String DIR = TEST_UTIL.getDataTestDir("TestCompactSelection").toString();
    private static Path TEST_FILE;
    private static final int minFiles = 3;
    private static final int maxFiles = 5;
    private static final long minSize = 10L;
    private static final long maxSize = 1000L;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    public void setUp() throws Exception {
        this.conf = TEST_UTIL.getConfiguration();
        this.conf.setLong("hbase.hregion.majorcompaction", 0L);
        this.conf.setInt("hbase.hstore.compaction.min", 3);
        this.conf.setInt("hbase.hstore.compaction.max", 5);
        this.conf.setLong("hbase.hregion.memstore.flush.size", 10L);
        this.conf.setLong("hbase.hstore.compaction.max.size", 1000L);
        this.conf.setFloat("hbase.hstore.compaction.ratio", 1.0f);
        Path basedir = new Path(DIR);
        Path logdir = new Path(DIR + "/logs");
        Path oldLogDir = new Path(basedir, ".oldlogs");
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toBytes((String)"family"));
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        fs.delete(logdir, true);
        HTableDescriptor htd = new HTableDescriptor(Bytes.toBytes((String)"table"));
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(htd.getName(), null, null, false);
        HLog hlog = new HLog(fs, logdir, oldLogDir, this.conf);
        HRegion region = HRegion.createHRegion((HRegionInfo)info, (Path)basedir, (Configuration)this.conf, (HTableDescriptor)htd);
        HRegion.closeHRegion((HRegion)region);
        Path tableDir = new Path(basedir, Bytes.toString((byte[])htd.getName()));
        region = new HRegion(tableDir, hlog, fs, this.conf, info, htd, null);
        this.store = new Store(basedir, region, hcd, fs, this.conf);
        TEST_FILE = StoreFile.getRandomFilename((FileSystem)fs, (Path)this.store.getHomedir());
        fs.create(TEST_FILE);
    }

    List<StoreFile> sfCreate(long ... sizes) throws IOException {
        return this.sfCreate(false, sizes);
    }

    List<StoreFile> sfCreate(boolean isReference, long ... sizes) throws IOException {
        ArrayList ret = Lists.newArrayList();
        for (long i : sizes) {
            ret.add(new MockStoreFile(i, isReference));
        }
        return ret;
    }

    long[] getSizes(List<StoreFile> sfList) {
        long[] aNums = new long[sfList.size()];
        for (int i = 0; i < sfList.size(); ++i) {
            aNums[i] = sfList.get(i).getReader().length();
        }
        return aNums;
    }

    void compactEquals(List<StoreFile> candidates, long ... expected) throws IOException {
        this.compactEquals(candidates, false, expected);
    }

    void compactEquals(List<StoreFile> candidates, boolean forcemajor, long ... expected) throws IOException {
        this.store.forceMajor = forcemajor;
        List actual = this.store.compactSelection(candidates).getFilesToCompact();
        this.store.forceMajor = false;
        TestCompactSelection.assertEquals((String)Arrays.toString(expected), (String)Arrays.toString(this.getSizes(actual)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompactionRatio() throws IOException {
        long tooBig = 1001L;
        this.compactEquals(this.sfCreate(100L, 50L, 23L, 12L, 12L), 23L, 12L, 12L);
        this.compactEquals(this.sfCreate(100L, 50L, 25L, 12L, 12L), new long[0]);
        this.compactEquals(this.sfCreate(tooBig, tooBig, 700L, 700L, 700L), 700L, 700L, 700L);
        this.compactEquals(this.sfCreate(tooBig, tooBig, 700L, 700L), new long[0]);
        this.compactEquals(this.sfCreate(8L, 3L, 1L), 8L, 3L, 1L);
        TestCompactSelection.assertEquals((int)5, (int)this.store.compactSelection(this.sfCreate(7L, 6L, 5L, 4L, 3L, 2L, 1L)).getFilesToCompact().size());
        this.compactEquals(this.sfCreate(7L, 6L, 5L, 4L, 3L, 2L, 1L), 7L, 6L, 5L, 4L, 3L);
        this.compactEquals(this.sfCreate(50L, 25L, 12L, 12L), true, 50L, 25L, 12L, 12L);
        this.compactEquals(this.sfCreate(12L, 12L), true, 12L, 12L);
        this.compactEquals(this.sfCreate(tooBig, 12L, 12L), true, tooBig, 12L, 12L);
        this.store.forceMajor = true;
        this.compactEquals(this.sfCreate(7L, 6L, 5L, 4L, 3L, 2L, 1L), 7L, 6L, 5L, 4L, 3L);
        this.store.forceMajor = false;
        this.compactEquals(this.sfCreate(100L, 50L, 23L, 12L, 12L), true, 23L, 12L, 12L);
        this.conf.setLong("hbase.hregion.majorcompaction", 1L);
        this.conf.setFloat("hbase.hregion.majorcompaction.jitter", 0.0f);
        try {
            this.compactEquals(this.sfCreate(50L, 25L, 12L, 12L), 50L, 25L, 12L, 12L);
            this.compactEquals(this.sfCreate(100L, 50L, 23L, 12L, 12L), 23L, 12L, 12L);
        }
        finally {
            this.conf.setLong("hbase.hregion.majorcompaction", 86400000L);
            this.conf.setFloat("hbase.hregion.majorcompaction.jitter", 0.2f);
        }
        this.compactEquals(this.sfCreate(true, 100L, 50L, 25L, 12L, 12L), 100L, 50L, 25L, 12L, 12L);
        this.compactEquals(this.sfCreate(true, tooBig, 12L, 12L), tooBig, 12L, 12L);
        TestCompactSelection.assertEquals((int)5, (int)this.store.compactSelection(this.sfCreate(true, 7L, 6L, 5L, 4L, 3L, 2L, 1L)).getFilesToCompact().size());
        this.compactEquals(this.sfCreate(true, 7L, 6L, 5L, 4L, 3L, 2L, 1L), 5L, 4L, 3L, 2L, 1L);
        this.compactEquals(new ArrayList<StoreFile>(), new long[0]);
        this.compactEquals(this.sfCreate(tooBig, tooBig), new long[0]);
    }

    public void testOffPeakCompactionRatio() throws IOException {
        long tooBig = 1001L;
        GregorianCalendar calendar = new GregorianCalendar();
        int hourOfDay = calendar.get(11);
        LOG.debug((Object)("Hour of day = " + hourOfDay));
        int hourPlusOne = (hourOfDay + 1 + 24) % 24;
        int hourMinusOne = (hourOfDay - 1 + 24) % 24;
        int hourMinusTwo = (hourOfDay - 2 + 24) % 24;
        LOG.debug((Object)"Testing compact selection without off-peak settings...");
        this.compactEquals(this.sfCreate(999L, 50L, 12L, 12L, 1L), 12L, 12L, 1L);
        this.conf.setFloat("hbase.hstore.compaction.ratio.offpeak", 5.0f);
        this.conf.setLong("hbase.offpeak.start.hour", (long)hourMinusOne);
        this.conf.setLong("hbase.offpeak.end.hour", (long)hourPlusOne);
        LOG.debug((Object)("Testing compact selection with off-peak settings (" + hourMinusOne + ", " + hourPlusOne + ")"));
        this.compactEquals(this.sfCreate(999L, 50L, 12L, 12L, 1L), 50L, 12L, 12L, 1L);
        this.conf.setLong("hbase.offpeak.start.hour", (long)hourMinusTwo);
        this.conf.setLong("hbase.offpeak.end.hour", (long)hourMinusOne);
        LOG.debug((Object)("Testing compact selection with off-peak settings (" + hourMinusTwo + ", " + hourMinusOne + ")"));
        this.compactEquals(this.sfCreate(999L, 50L, 12L, 12L, 1L), 12L, 12L, 1L);
    }

    static class MockStoreFile
    extends StoreFile {
        long length = 0L;
        boolean isRef = false;

        MockStoreFile(long length, boolean isRef) throws IOException {
            super(TEST_UTIL.getTestFileSystem(), TEST_FILE, TEST_UTIL.getConfiguration(), new CacheConfig(TEST_UTIL.getConfiguration()), StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE);
            this.length = length;
            this.isRef = isRef;
        }

        void setLength(long newLen) {
            this.length = newLen;
        }

        boolean isMajorCompaction() {
            return false;
        }

        boolean isReference() {
            return this.isRef;
        }

        public StoreFile.Reader getReader() {
            final long len = this.length;
            return new StoreFile.Reader(){

                public long length() {
                    return len;
                }
            };
        }
    }
}

