/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.CompactSplitThread;
import org.apache.hadoop.hbase.regionserver.Compactor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.metrics.RegionServerMetrics;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestCompaction
extends HBaseTestCase {
    static final Log LOG = LogFactory.getLog((String)TestCompaction.class.getName());
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private HRegion r = null;
    private HTableDescriptor htd = null;
    private Path compactionDir = null;
    private Path regionCompactionDir = null;
    private static final byte[] COLUMN_FAMILY = fam1;
    private final byte[] STARTROW = Bytes.toBytes((String)this.START_KEY);
    private static final byte[] COLUMN_FAMILY_TEXT = COLUMN_FAMILY;
    private int compactionThreshold;
    private byte[] firstRowBytes;
    private byte[] secondRowBytes;
    private byte[] thirdRowBytes;
    private final byte[] col1;
    private final byte[] col2;
    private static final long MAX_FILES_TO_COMPACT = 10L;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    public TestCompaction() throws Exception {
        this.conf.setInt("hbase.hregion.memstore.flush.size", 0x100000);
        this.conf.setInt("hbase.hregion.memstore.block.multiplier", 100);
        this.compactionThreshold = this.conf.getInt("hbase.hstore.compactionThreshold", 3);
        this.firstRowBytes = this.START_KEY.getBytes("UTF-8");
        this.secondRowBytes = this.START_KEY.getBytes("UTF-8");
        int n = START_KEY_BYTES.length - 1;
        this.secondRowBytes[n] = (byte)(this.secondRowBytes[n] + 1);
        this.thirdRowBytes = this.START_KEY.getBytes("UTF-8");
        int n2 = START_KEY_BYTES.length - 1;
        this.thirdRowBytes[n2] = (byte)(this.thirdRowBytes[n2] + 1);
        int n3 = START_KEY_BYTES.length - 1;
        this.thirdRowBytes[n3] = (byte)(this.thirdRowBytes[n3] + 1);
        this.col1 = "column1".getBytes("UTF-8");
        this.col2 = "column2".getBytes("UTF-8");
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.htd = this.createTableDescriptor(this.getName());
        this.r = this.createNewHRegion(this.htd, null, null);
    }

    @Override
    public void tearDown() throws Exception {
        HLog hlog = this.r.getLog();
        this.r.close();
        hlog.closeAndDelete();
        super.tearDown();
    }

    public void testMajorCompactingToNoOutput() throws IOException {
        ArrayList results;
        boolean result;
        boolean result2;
        this.createStoreFile(this.r);
        for (int i = 0; i < this.compactionThreshold; ++i) {
            this.createStoreFile(this.r);
        }
        RegionScanner s = this.r.getScanner(new Scan());
        do {
            ArrayList results2 = new ArrayList();
            result2 = s.next(results2);
            this.r.delete(new Delete(((KeyValue)results2.get(0)).getRow()), null, false);
        } while (result2);
        s.close();
        this.r.flushcache();
        this.r.compactStores(true);
        s = this.r.getScanner(new Scan());
        int counter = 0;
        while (result = s.next(results = new ArrayList())) {
            ++counter;
        }
        TestCompaction.assertEquals((int)0, (int)counter);
    }

    public void testMajorCompaction() throws Exception {
        this.majorCompaction();
    }

    public void testDataBlockEncodingInCacheOnly() throws Exception {
        this.majorCompactionWithDataBlockEncoding(true);
    }

    public void testDataBlockEncodingEverywhere() throws Exception {
        this.majorCompactionWithDataBlockEncoding(false);
    }

    public void majorCompactionWithDataBlockEncoding(boolean inCacheOnly) throws Exception {
        HashMap replaceBlockCache = new HashMap();
        for (Map.Entry pair : this.r.getStores().entrySet()) {
            Store store = (Store)pair.getValue();
            HFileDataBlockEncoder blockEncoder = store.getDataBlockEncoder();
            replaceBlockCache.put(pair.getValue(), blockEncoder);
            DataBlockEncoding inCache = DataBlockEncoding.PREFIX;
            DataBlockEncoding onDisk = inCacheOnly ? DataBlockEncoding.NONE : inCache;
            store.setDataBlockEncoderInTest((HFileDataBlockEncoder)new HFileDataBlockEncoderImpl(onDisk, inCache));
        }
        this.majorCompaction();
        for (Map.Entry entry : replaceBlockCache.entrySet()) {
            ((Store)entry.getKey()).setDataBlockEncoderInTest((HFileDataBlockEncoder)entry.getValue());
        }
    }

    private void majorCompaction() throws Exception {
        this.createStoreFile(this.r);
        for (int i = 0; i < this.compactionThreshold; ++i) {
            this.createStoreFile(this.r);
        }
        TestCompaction.addContent(new HBaseTestCase.HRegionIncommon(this.r), Bytes.toString((byte[])COLUMN_FAMILY));
        Result result = this.r.get(new Get(this.STARTROW).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)this.compactionThreshold, (int)result.size());
        for (Store store : this.r.stores.values()) {
            TestCompaction.assertNull((Object)store.getCompactionProgress());
        }
        this.r.flushcache();
        this.r.compactStores(true);
        int storeCount = 0;
        for (Store store : this.r.stores.values()) {
            CompactionProgress progress = store.getCompactionProgress();
            if (progress != null) {
                ++storeCount;
                TestCompaction.assertTrue((progress.currentCompactedKVs > 0L ? 1 : 0) != 0);
                TestCompaction.assertTrue((progress.totalCompactingKVs > 0L ? 1 : 0) != 0);
            }
            TestCompaction.assertTrue((storeCount > 0 ? 1 : 0) != 0);
        }
        byte[] secondRowBytes = this.START_KEY.getBytes("UTF-8");
        int n = START_KEY_BYTES.length - 1;
        secondRowBytes[n] = (byte)(secondRowBytes[n] + 1);
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100), null);
        LOG.debug((Object)("Row " + Bytes.toStringBinary((byte[])secondRowBytes) + " after " + "initial compaction: " + result));
        TestCompaction.assertEquals((String)("Invalid number of versions of row " + Bytes.toStringBinary((byte[])secondRowBytes) + "."), (int)this.compactionThreshold, (int)result.size());
        LOG.debug((Object)"Adding deletes to memstore and flushing");
        Delete delete = new Delete(secondRowBytes, System.currentTimeMillis(), null);
        byte[][] famAndQf = new byte[][]{COLUMN_FAMILY, null};
        delete.deleteFamily(famAndQf[0]);
        this.r.delete(delete, null, true);
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100), null);
        TestCompaction.assertTrue((String)"Second row should have been deleted", (boolean)result.isEmpty());
        this.r.flushcache();
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100), null);
        TestCompaction.assertTrue((String)"Second row should have been deleted", (boolean)result.isEmpty());
        this.createSmallerStoreFile(this.r);
        this.r.flushcache();
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100), null);
        TestCompaction.assertTrue((String)"Second row should still be deleted", (boolean)result.isEmpty());
        this.r.compactStores(true);
        TestCompaction.assertEquals((int)this.r.getStore(COLUMN_FAMILY_TEXT).getStorefiles().size(), (int)1);
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100), null);
        TestCompaction.assertTrue((String)"Second row should still be deleted", (boolean)result.isEmpty());
        this.verifyCounts(3, 0);
        int ttl = 1000;
        for (Store store : this.r.stores.values()) {
            Store.ScanInfo si;
            Store.ScanInfo old = store.scanInfo;
            store.scanInfo = si = new Store.ScanInfo(old.getFamily(), old.getMinVersions(), old.getMaxVersions(), 1000L, old.getKeepDeletedCells(), 0L, old.getComparator());
        }
        Thread.sleep(1000L);
        this.r.compactStores(true);
        int count = this.count();
        TestCompaction.assertEquals((String)"Should not see anything after TTL has expired", (int)0, (int)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimeBasedMajorCompaction() throws Exception {
        int delay = 10000;
        float jitterPct = 0.2f;
        this.conf.setLong("hbase.hregion.majorcompaction", (long)delay);
        this.conf.setFloat("hbase.hregion.majorcompaction.jitter", jitterPct);
        Store s = this.r.getStore(COLUMN_FAMILY);
        try {
            this.createStoreFile(this.r);
            this.createStoreFile(this.r);
            this.r.compactStores(true);
            this.createStoreFile(this.r);
            this.r.compactStores(false);
            TestCompaction.assertEquals((int)2, (int)s.getStorefilesCount());
            long mcTime = s.getNextMajorCompactTime();
            for (int i = 0; i < 10; ++i) {
                TestCompaction.assertEquals((long)mcTime, (long)s.getNextMajorCompactTime());
            }
            long jitter = Math.round((float)delay * jitterPct);
            TestCompaction.assertTrue(((long)delay - jitter <= mcTime && mcTime <= (long)delay + jitter ? 1 : 0) != 0);
            Thread.sleep(mcTime);
            this.r.compactStores(false);
            TestCompaction.assertEquals((int)1, (int)s.getStorefilesCount());
        }
        finally {
            this.conf.setLong("hbase.hregion.majorcompaction", 86400000L);
            this.conf.setFloat("hbase.hregion.majorcompaction.jitter", 0.2f);
            this.createStoreFile(this.r);
            this.r.compactStores(true);
            TestCompaction.assertEquals((int)1, (int)s.getStorefilesCount());
        }
    }

    public void testMinorCompactionWithDeleteRow() throws Exception {
        Delete deleteRow = new Delete(this.secondRowBytes);
        this.testMinorCompactionWithDelete(deleteRow);
    }

    public void testMinorCompactionWithDeleteColumn1() throws Exception {
        Delete dc = new Delete(this.secondRowBytes);
        dc.deleteColumns(fam2, this.col2);
        this.testMinorCompactionWithDelete(dc);
    }

    public void testMinorCompactionWithDeleteColumn2() throws Exception {
        Delete dc = new Delete(this.secondRowBytes);
        dc.deleteColumn(fam2, this.col2);
        this.testMinorCompactionWithDelete(dc, 3);
    }

    public void testMinorCompactionWithDeleteColumnFamily() throws Exception {
        Delete deleteCF = new Delete(this.secondRowBytes);
        deleteCF.deleteFamily(fam2);
        this.testMinorCompactionWithDelete(deleteCF);
    }

    public void testMinorCompactionWithDeleteVersion1() throws Exception {
        Delete deleteVersion = new Delete(this.secondRowBytes);
        deleteVersion.deleteColumns(fam2, this.col2, 2L);
        this.testMinorCompactionWithDelete(deleteVersion, 1);
    }

    public void testMinorCompactionWithDeleteVersion2() throws Exception {
        Delete deleteVersion = new Delete(this.secondRowBytes);
        deleteVersion.deleteColumn(fam2, this.col2, 1L);
        this.testMinorCompactionWithDelete(deleteVersion, 3);
    }

    private void testMinorCompactionWithDelete(Delete delete) throws Exception {
        this.testMinorCompactionWithDelete(delete, 0);
    }

    private void testMinorCompactionWithDelete(Delete delete, int expectedResultsAfterDelete) throws Exception {
        HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(this.r);
        for (int i = 0; i < this.compactionThreshold + 1; ++i) {
            TestCompaction.addContent(loader, Bytes.toString((byte[])fam1), Bytes.toString((byte[])this.col1), this.firstRowBytes, this.thirdRowBytes, i);
            TestCompaction.addContent(loader, Bytes.toString((byte[])fam1), Bytes.toString((byte[])this.col2), this.firstRowBytes, this.thirdRowBytes, i);
            TestCompaction.addContent(loader, Bytes.toString((byte[])fam2), Bytes.toString((byte[])this.col1), this.firstRowBytes, this.thirdRowBytes, i);
            TestCompaction.addContent(loader, Bytes.toString((byte[])fam2), Bytes.toString((byte[])this.col2), this.firstRowBytes, this.thirdRowBytes, i);
            this.r.flushcache();
        }
        Result result = this.r.get(new Get(this.firstRowBytes).addColumn(fam1, this.col1).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)this.compactionThreshold, (int)result.size());
        result = this.r.get(new Get(this.secondRowBytes).addColumn(fam2, this.col2).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)this.compactionThreshold, (int)result.size());
        this.r.delete(delete, null, true);
        result = this.r.get(new Get(this.secondRowBytes).addColumn(fam2, this.col2).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)expectedResultsAfterDelete, (int)result.size());
        result = this.r.get(new Get(this.firstRowBytes).addColumn(fam1, this.col1).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)this.compactionThreshold, (int)result.size());
        this.r.flushcache();
        result = this.r.get(new Get(this.secondRowBytes).addColumn(fam2, this.col2).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)expectedResultsAfterDelete, (int)result.size());
        result = this.r.get(new Get(this.firstRowBytes).addColumn(fam1, this.col1).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)this.compactionThreshold, (int)result.size());
        Store store2 = (Store)this.r.stores.get(fam2);
        int numFiles1 = store2.getStorefiles().size();
        TestCompaction.assertTrue((String)"Was expecting to see 4 store files", (numFiles1 > this.compactionThreshold ? 1 : 0) != 0);
        store2.compactRecentForTesting(this.compactionThreshold);
        int numFiles2 = store2.getStorefiles().size();
        TestCompaction.assertTrue((String)"Number of store files should go down", (numFiles1 > numFiles2 ? 1 : 0) != 0);
        TestCompaction.assertTrue((String)"Was not supposed to be a major compaction", (numFiles2 > 1 ? 1 : 0) != 0);
        result = this.r.get(new Get(this.secondRowBytes).addColumn(fam2, this.col2).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)expectedResultsAfterDelete, (int)result.size());
        result = this.r.get(new Get(this.firstRowBytes).addColumn(fam1, this.col1).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)this.compactionThreshold, (int)result.size());
    }

    private void verifyCounts(int countRow1, int countRow2) throws Exception {
        int count1 = 0;
        int count2 = 0;
        for (StoreFile f : ((Store)this.r.stores.get(COLUMN_FAMILY_TEXT)).getStorefiles()) {
            HFileScanner scanner = f.getReader().getScanner(false, false);
            scanner.seekTo();
            do {
                byte[] row;
                if (Bytes.equals((byte[])(row = scanner.getKeyValue().getRow()), (byte[])this.STARTROW)) {
                    ++count1;
                    continue;
                }
                if (!Bytes.equals((byte[])row, (byte[])this.secondRowBytes)) continue;
                ++count2;
            } while (scanner.next());
        }
        TestCompaction.assertEquals((int)countRow1, (int)count1);
        TestCompaction.assertEquals((int)countRow2, (int)count2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInterruptCompaction() throws Exception {
        TestCompaction.assertEquals((int)0, (int)this.count());
        int origWI = Store.closeCheckInterval;
        Store.closeCheckInterval = 10000;
        try {
            int jmax = (int)Math.ceil(15.0 / (double)this.compactionThreshold);
            byte[] pad = new byte[1000];
            for (int i = 0; i < this.compactionThreshold; ++i) {
                HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(this.r);
                Put p = new Put(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)i)));
                p.setWriteToWAL(false);
                for (int j = 0; j < jmax; ++j) {
                    p.add(COLUMN_FAMILY, Bytes.toBytes((int)j), pad);
                }
                TestCompaction.addContent(loader, Bytes.toString((byte[])COLUMN_FAMILY));
                loader.put(p);
                loader.flushcache();
            }
            HRegion spyR = (HRegion)Mockito.spy((Object)this.r);
            ((HRegion)Mockito.doAnswer((Answer)new Answer(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    ((TestCompaction)TestCompaction.this).r.writestate.writesEnabled = false;
                    return invocation.callRealMethod();
                }
            }).when((Object)spyR)).doRegionCompactionPrep();
            spyR.compactStores();
            Store s = (Store)this.r.stores.get(COLUMN_FAMILY);
            TestCompaction.assertEquals((int)this.compactionThreshold, (int)s.getStorefilesCount());
            TestCompaction.assertTrue((s.getStorefilesSize() > 15000L ? 1 : 0) != 0);
            FileStatus[] ls = FileSystem.get((Configuration)this.conf).listStatus(this.r.getTmpDir());
            TestCompaction.assertEquals((int)0, (int)ls.length);
            this.r.writestate.writesEnabled = true;
            Store.closeCheckInterval = origWI;
        }
        catch (Throwable throwable) {
            this.r.writestate.writesEnabled = true;
            Store.closeCheckInterval = origWI;
            for (int i = 0; i < this.compactionThreshold; ++i) {
                Delete delete = new Delete(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)i)));
                byte[][] famAndQf = new byte[][]{COLUMN_FAMILY, null};
                delete.deleteFamily(famAndQf[0]);
                this.r.delete(delete, null, true);
            }
            this.r.flushcache();
            int ttl = 1000;
            for (Store store : this.r.stores.values()) {
                Store.ScanInfo si;
                Store.ScanInfo old = store.scanInfo;
                store.scanInfo = si = new Store.ScanInfo(old.getFamily(), old.getMinVersions(), old.getMaxVersions(), 1000L, old.getKeepDeletedCells(), 0L, old.getComparator());
            }
            Thread.sleep(1000L);
            this.r.compactStores(true);
            TestCompaction.assertEquals((int)0, (int)this.count());
            throw throwable;
        }
        for (int i = 0; i < this.compactionThreshold; ++i) {
            Delete delete = new Delete(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)i)));
            byte[][] famAndQf = new byte[][]{COLUMN_FAMILY, null};
            delete.deleteFamily(famAndQf[0]);
            this.r.delete(delete, null, true);
        }
        this.r.flushcache();
        int ttl = 1000;
        for (Store store : this.r.stores.values()) {
            Store.ScanInfo si;
            Store.ScanInfo old = store.scanInfo;
            store.scanInfo = si = new Store.ScanInfo(old.getFamily(), old.getMinVersions(), old.getMaxVersions(), 1000L, old.getKeepDeletedCells(), 0L, old.getComparator());
        }
        Thread.sleep(1000L);
        this.r.compactStores(true);
        TestCompaction.assertEquals((int)0, (int)this.count());
    }

    private int count() throws IOException {
        int count = 0;
        for (StoreFile f : ((Store)this.r.stores.get(COLUMN_FAMILY_TEXT)).getStorefiles()) {
            HFileScanner scanner = f.getReader().getScanner(false, false);
            if (!scanner.seekTo()) continue;
            do {
                ++count;
            } while (scanner.next());
        }
        return count;
    }

    private void createStoreFile(HRegion region) throws IOException {
        this.createStoreFile(region, Bytes.toString((byte[])COLUMN_FAMILY));
    }

    private void createStoreFile(HRegion region, String family) throws IOException {
        HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(region);
        TestCompaction.addContent(loader, family);
        loader.flushcache();
    }

    private void createSmallerStoreFile(HRegion region) throws IOException {
        HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(region);
        TestCompaction.addContent(loader, Bytes.toString((byte[])COLUMN_FAMILY), "bbb".getBytes(), null);
        loader.flushcache();
    }

    public void testCompactionWithCorruptResult() throws Exception {
        int nfiles = 10;
        for (int i = 0; i < nfiles; ++i) {
            this.createStoreFile(this.r);
        }
        Store store = this.r.getStore(COLUMN_FAMILY);
        List storeFiles = store.getStorefiles();
        long maxId = StoreFile.getMaxSequenceIdInList((Collection)storeFiles);
        Compactor tool = new Compactor(this.conf);
        StoreFile.Writer compactedFile = tool.compactForTesting(store, this.conf, (Collection)storeFiles, false, maxId);
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path origPath = compactedFile.getPath();
        Path homedir = store.getHomedir();
        Path dstPath = new Path(homedir, origPath.getName());
        FSDataOutputStream stream = fs.create(origPath, null, true, 512, (short)3, 1024L, null);
        stream.writeChars("CORRUPT FILE!!!!");
        stream.close();
        try {
            store.completeCompaction((Collection)storeFiles, compactedFile);
        }
        catch (Exception e) {
            assert (fs.exists(origPath));
            assert (!fs.exists(dstPath));
            System.out.println("testCompactionWithCorruptResult Passed");
            return;
        }
        TestCompaction.fail((String)"testCompactionWithCorruptResult failed since no exception wasthrown while completing a corrupt file");
    }

    public void testNonUserMajorCompactionRequest() throws Exception {
        Store store = this.r.getStore(COLUMN_FAMILY);
        this.createStoreFile(this.r);
        int i = 0;
        while ((long)i < 11L) {
            this.createStoreFile(this.r);
            ++i;
        }
        store.triggerMajorCompaction();
        CompactionRequest request = store.requestCompaction(Integer.MIN_VALUE, null);
        TestCompaction.assertNotNull((String)"Expected to receive a compaction request", (Object)request);
        TestCompaction.assertEquals((String)"System-requested major compaction should not occur if there are too many store files", (boolean)false, (boolean)request.isMajor());
    }

    public void testUserMajorCompactionRequest() throws IOException {
        Store store = this.r.getStore(COLUMN_FAMILY);
        this.createStoreFile(this.r);
        int i = 0;
        while ((long)i < 11L) {
            this.createStoreFile(this.r);
            ++i;
        }
        store.triggerMajorCompaction();
        CompactionRequest request = store.requestCompaction(1, null);
        TestCompaction.assertNotNull((String)"Expected to receive a compaction request", (Object)request);
        TestCompaction.assertEquals((String)"User-requested major compaction should always occur, even if there are too many store files", (boolean)true, (boolean)request.isMajor());
    }

    public void testTrackingCompactionRequest() throws Exception {
        HRegionServer mockServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)this.r.getConf());
        CompactSplitThread thread = new CompactSplitThread(mockServer);
        Mockito.when((Object)mockServer.getCompactSplitThread()).thenReturn((Object)thread);
        RegionServerMetrics mockMetrics = (RegionServerMetrics)Mockito.mock(RegionServerMetrics.class);
        Mockito.when((Object)mockServer.getMetrics()).thenReturn((Object)mockMetrics);
        Store store = this.r.getStore(COLUMN_FAMILY);
        this.createStoreFile(this.r);
        int i = 0;
        while ((long)i < 11L) {
            this.createStoreFile(this.r);
            ++i;
        }
        CountDownLatch latch = new CountDownLatch(1);
        TrackableCompactionRequest request = new TrackableCompactionRequest(this.r, store, latch);
        thread.requestCompaction(this.r, store, "test custom comapction", 1, (CompactionRequest)request);
        latch.await();
        thread.interruptIfNecessary();
    }

    public void testMultipleCustomCompactionRequests() throws Exception {
        HRegionServer mockServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)this.r.getConf());
        CompactSplitThread thread = new CompactSplitThread(mockServer);
        Mockito.when((Object)mockServer.getCompactSplitThread()).thenReturn((Object)thread);
        RegionServerMetrics mockMetrics = (RegionServerMetrics)Mockito.mock(RegionServerMetrics.class);
        Mockito.when((Object)mockServer.getMetrics()).thenReturn((Object)mockMetrics);
        int numStores = this.r.getStores().size();
        ArrayList<TrackableCompactionRequest> requests = new ArrayList<TrackableCompactionRequest>(numStores);
        CountDownLatch latch = new CountDownLatch(numStores);
        for (Store store : this.r.getStores().values()) {
            this.createStoreFile(this.r, store.getColumnFamilyName());
            this.createStoreFile(this.r, store.getColumnFamilyName());
            this.createStoreFile(this.r, store.getColumnFamilyName());
            requests.add(new TrackableCompactionRequest(this.r, store, latch));
        }
        thread.requestCompaction(this.r, "test mulitple custom comapctions", 1, Collections.unmodifiableList(requests));
        latch.await();
        thread.interruptIfNecessary();
    }

    public static class TrackableCompactionRequest
    extends CompactionRequest {
        private CountDownLatch done;

        public TrackableCompactionRequest(HRegion region, Store store, CountDownLatch finished) {
            super(region, store, 1);
            this.done = finished;
        }

        public void run() {
            super.run();
            this.done.countDown();
        }
    }
}

