/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MultithreadedTestUtil;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.TestHRegion;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHBase7051 {
    private static CountDownLatch latch = new CountDownLatch(1);
    private static volatile TestStep testStep = TestStep.INIT;
    private final String family = "f1";

    @Test
    public void testPutAndCheckAndPutInParallel() throws Exception {
        String tableName = "testPutAndCheckAndPut";
        Configuration conf = HBaseConfiguration.create();
        conf.setClass("hbase.hregion.impl", MockHRegion.class, HeapSize.class);
        MockHRegion region = (MockHRegion)TestHRegion.initHRegion(Bytes.toBytes((String)"testPutAndCheckAndPut"), "testPutAndCheckAndPut", conf, new byte[][]{Bytes.toBytes((String)"f1")});
        ArrayList putsAndLocks = Lists.newArrayList();
        Put[] puts = new Put[1];
        Put put = new Put(Bytes.toBytes((String)"r1"));
        put.add(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"10"));
        puts[0] = put;
        Pair pair = new Pair((Object)puts[0], null);
        putsAndLocks.add(pair);
        region.batchMutate(putsAndLocks.toArray(new Pair[0]));
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(conf);
        ctx.addThread(new PutThread(ctx, region));
        ctx.addThread(new CheckAndPutThread(ctx, region));
        ctx.startThreads();
        while (testStep != TestStep.CHECKANDPUT_COMPLETED) {
            Thread.sleep(100L);
        }
        ctx.stop();
        Scan s = new Scan();
        RegionScanner scanner = region.getScanner(s);
        ArrayList results = new ArrayList();
        scanner.next(results, 2);
        for (KeyValue keyValue : results) {
            Assert.assertEquals((Object)"50", (Object)Bytes.toString((byte[])keyValue.getValue()));
        }
    }

    public static class MockHRegion
    extends HRegion {
        public MockHRegion(Path tableDir, HLog log, FileSystem fs, Configuration conf, HRegionInfo regionInfo, HTableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, log, fs, conf, regionInfo, htd, rsServices);
        }

        public void releaseRowLock(Integer lockId) {
            if (testStep == TestStep.INIT) {
                super.releaseRowLock(lockId);
                return;
            }
            if (testStep == TestStep.PUT_STARTED) {
                try {
                    testStep = TestStep.PUT_COMPLETED;
                    super.releaseRowLock(lockId);
                    latch.await();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else if (testStep == TestStep.CHECKANDPUT_STARTED) {
                super.releaseRowLock(lockId);
            }
        }

        public Integer getLock(Integer lockid, byte[] row, boolean waitForLock) throws IOException {
            if (testStep == TestStep.CHECKANDPUT_STARTED) {
                latch.countDown();
            }
            return super.getLock(lockid, row, waitForLock);
        }
    }

    private class CheckAndPutThread
    extends MultithreadedTestUtil.TestThread {
        private MockHRegion region;

        CheckAndPutThread(MultithreadedTestUtil.TestContext ctx, MockHRegion region) {
            super(ctx);
            this.region = region;
        }

        @Override
        public void doWork() throws Exception {
            Put[] puts = new Put[1];
            Put put = new Put(Bytes.toBytes((String)"r1"));
            put.add(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"11"));
            puts[0] = put;
            while (testStep != TestStep.PUT_COMPLETED) {
                Thread.sleep(100L);
            }
            testStep = TestStep.CHECKANDPUT_STARTED;
            this.region.checkAndMutate(Bytes.toBytes((String)"r1"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), CompareFilter.CompareOp.EQUAL, (WritableByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"10")), (Writable)put, null, true);
            testStep = TestStep.CHECKANDPUT_COMPLETED;
        }
    }

    private class PutThread
    extends MultithreadedTestUtil.TestThread {
        private MockHRegion region;

        PutThread(MultithreadedTestUtil.TestContext ctx, MockHRegion region) {
            super(ctx);
            this.region = region;
        }

        @Override
        public void doWork() throws Exception {
            ArrayList putsAndLocks = Lists.newArrayList();
            Put[] puts = new Put[1];
            Put put = new Put(Bytes.toBytes((String)"r1"));
            put.add(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"50"));
            puts[0] = put;
            Pair pair = new Pair((Object)puts[0], null);
            putsAndLocks.add(pair);
            testStep = TestStep.PUT_STARTED;
            this.region.batchMutate(putsAndLocks.toArray(new Pair[0]));
        }
    }

    private static enum TestStep {
        INIT,
        PUT_STARTED,
        PUT_COMPLETED,
        CHECKANDPUT_STARTED,
        CHECKANDPUT_COMPLETED;

    }
}

