/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHRegionInfo {
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testCreateHRegionInfoName() throws Exception {
        String tableName = "tablename";
        byte[] tn = Bytes.toBytes((String)tableName);
        String startKey = "startkey";
        byte[] sk = Bytes.toBytes((String)startKey);
        String id = "id";
        byte[] name = HRegionInfo.createRegionName((byte[])tn, (byte[])sk, (String)id, (boolean)false);
        String nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id), (Object)nameStr);
        String md5HashInHex = MD5Hash.getMD5AsHex((byte[])name);
        Assert.assertEquals((long)32L, (long)md5HashInHex.length());
        name = HRegionInfo.createRegionName((byte[])tn, (byte[])sk, (String)id, (boolean)true);
        nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id + "." + md5HashInHex + "."), (Object)nameStr);
    }

    @Test
    public void testGetSetOfHTD() throws IOException {
        HBaseTestingUtility HTU = new HBaseTestingUtility();
        String tablename = "testGetSetOfHTD";
        FSTableDescriptors.deleteTableDescriptorIfExists((String)"testGetSetOfHTD", (Configuration)HTU.getConfiguration());
        HTableDescriptor htd = new HTableDescriptor("testGetSetOfHTD");
        FSTableDescriptors.createTableDescriptor((HTableDescriptor)htd, (Configuration)HTU.getConfiguration());
        HRegionInfo hri = new HRegionInfo(Bytes.toBytes((String)"testGetSetOfHTD"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        HTableDescriptor htd2 = hri.getTableDesc();
        Assert.assertTrue((boolean)htd.equals((Object)htd2));
        String key = "SOME_KEY";
        Assert.assertNull((Object)htd.getValue("SOME_KEY"));
        String value = "VALUE";
        htd.setValue("SOME_KEY", "VALUE");
        hri.setTableDesc(htd);
        HTableDescriptor htd3 = hri.getTableDesc();
        Assert.assertTrue((boolean)htd.equals((Object)htd3));
    }

    @Test
    public void testContainsRange() {
        HTableDescriptor tableDesc = new HTableDescriptor("testtable");
        HRegionInfo hri = new HRegionInfo(tableDesc.getName(), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"g"));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"a")));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"c")));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"c"), Bytes.toBytes((String)"c")));
        Assert.assertFalse((boolean)hri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"g")));
        Assert.assertFalse((boolean)hri.containsRange(Bytes.toBytes((String)"g"), Bytes.toBytes((String)"g")));
        Assert.assertFalse((boolean)hri.containsRange(Bytes.toBytes((String)"z"), Bytes.toBytes((String)"z")));
        try {
            hri.containsRange(Bytes.toBytes((String)"z"), Bytes.toBytes((String)"a"));
            Assert.fail((String)"Invalid range did not throw IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLastRegionCompare() {
        HRegionInfo hric;
        HTableDescriptor tableDesc = new HTableDescriptor("testtable");
        HRegionInfo hrip = new HRegionInfo(tableDesc.getName(), Bytes.toBytes((String)"a"), new byte[0]);
        Assert.assertTrue((hrip.compareTo(hric = new HRegionInfo(tableDesc.getName(), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"))) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMetaTables() {
        Assert.assertTrue((boolean)HRegionInfo.ROOT_REGIONINFO.isMetaTable());
        Assert.assertTrue((boolean)HRegionInfo.FIRST_META_REGIONINFO.isMetaTable());
    }

    @Test
    public void testComparator() {
        HRegionInfo newer;
        byte[] empty;
        byte[] tablename = Bytes.toBytes((String)"comparatorTablename");
        HRegionInfo older = new HRegionInfo(tablename, empty = new byte[0], empty, false, 0L);
        Assert.assertTrue((older.compareTo(newer = new HRegionInfo(tablename, empty, empty, false, 1L)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((newer.compareTo(older) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((older.compareTo(older) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((newer.compareTo(newer) == 0 ? 1 : 0) != 0);
    }
}

