/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestKeepDeletes
extends HBaseTestCase {
    private final byte[] T0 = Bytes.toBytes((String)"0");
    private final byte[] T1 = Bytes.toBytes((String)"1");
    private final byte[] T2 = Bytes.toBytes((String)"2");
    private final byte[] T3 = Bytes.toBytes((String)"3");
    private final byte[] T4 = Bytes.toBytes((String)"4");
    private final byte[] T5 = Bytes.toBytes((String)"5");
    private final byte[] T6 = Bytes.toBytes((String)"6");
    private final byte[] c0 = COLUMNS[0];
    private final byte[] c1 = COLUMNS[1];
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    public void testBasicScenario() throws Exception {
        HTableDescriptor htd = this.createTableDescriptor(this.getName(), 0, 3, Integer.MAX_VALUE, true);
        HRegion region = this.createNewHRegion(htd, null, null);
        long ts = System.currentTimeMillis();
        Put p = new Put(this.T1, ts);
        p.add(this.c0, this.c0, this.T1);
        region.put(p);
        p = new Put(this.T1, ts + 1L);
        p.add(this.c0, this.c0, this.T2);
        region.put(p);
        p = new Put(this.T1, ts + 2L);
        p.add(this.c0, this.c0, this.T3);
        region.put(p);
        p = new Put(this.T1, ts + 4L);
        p.add(this.c0, this.c0, this.T4);
        region.put(p);
        Delete d = new Delete(this.T1, ts + 2L, null);
        region.delete(d, null, true);
        TestKeepDeletes.assertEquals((int)3, (int)this.countDeleteMarkers(region));
        Get g = new Get(this.T1);
        g.setMaxVersions();
        g.setTimeRange(0L, ts + 2L);
        Result r = region.get(g, null);
        this.checkResult(r, this.c0, this.c0, this.T2, this.T1);
        region.flushcache();
        r = region.get(g, null);
        this.checkResult(r, this.c0, this.c0, new byte[][]{this.T2});
        region.compactStores(true);
        region.compactStores(true);
        TestKeepDeletes.assertEquals((int)1, (int)this.countDeleteMarkers(region));
        r = region.get(g, null);
        this.checkResult(r, this.c0, this.c0, new byte[][]{this.T2});
        g.setTimeRange(0L, ts + 4L);
        r = region.get(g, null);
        TestKeepDeletes.assertTrue((boolean)r.isEmpty());
        p = new Put(this.T1, ts + 5L);
        p.add(this.c0, this.c0, this.T5);
        region.put(p);
        p = new Put(this.T1, ts + 6L);
        p.add(this.c0, this.c0, this.T6);
        region.put(p);
        p = new Put(this.T1, ts);
        p.add(this.c0, this.c0, this.T1);
        region.put(p);
        r = region.get(g, null);
        TestKeepDeletes.assertTrue((boolean)r.isEmpty());
        region.flushcache();
        region.compactStores(true);
        region.compactStores(true);
        region.put(p);
        r = region.get(g, null);
        this.checkResult(r, this.c0, this.c0, new byte[][]{this.T1});
        TestKeepDeletes.assertEquals((int)0, (int)this.countDeleteMarkers(region));
        region.close();
        region.getLog().closeAndDelete();
    }

    public void testRawScanWithoutKeepingDeletes() throws Exception {
        HTableDescriptor htd = this.createTableDescriptor(this.getName(), 0, 3, Integer.MAX_VALUE, false);
        HRegion region = this.createNewHRegion(htd, null, null);
        long ts = System.currentTimeMillis();
        Put p = new Put(this.T1, ts);
        p.add(this.c0, this.c0, this.T1);
        region.put(p);
        Delete d = new Delete(this.T1, ts, null);
        d.deleteColumn(this.c0, this.c0, ts);
        region.delete(d, null, true);
        Scan s = new Scan();
        s.setRaw(true);
        s.setMaxVersions();
        RegionScanner scan = region.getScanner(s);
        ArrayList kvs = new ArrayList();
        scan.next(kvs);
        TestKeepDeletes.assertEquals((int)2, (int)kvs.size());
        region.flushcache();
        region.compactStores(true);
        s = new Scan();
        s.setRaw(true);
        s.setMaxVersions();
        scan = region.getScanner(s);
        kvs = new ArrayList();
        scan.next(kvs);
        TestKeepDeletes.assertTrue((boolean)kvs.isEmpty());
        region.close();
        region.getLog().closeAndDelete();
    }

    public void testWithoutKeepingDeletes() throws Exception {
        HTableDescriptor htd = this.createTableDescriptor(this.getName(), 0, 3, Integer.MAX_VALUE, false);
        HRegion region = this.createNewHRegion(htd, null, null);
        long ts = System.currentTimeMillis();
        Put p = new Put(this.T1, ts);
        p.add(this.c0, this.c0, this.T1);
        region.put(p);
        Delete d = new Delete(this.T1, ts + 2L, null);
        d.deleteColumn(this.c0, this.c0, ts);
        region.delete(d, null, true);
        Get g = new Get(this.T1);
        g.setMaxVersions();
        g.setTimeRange(0L, ts + 1L);
        Result r = region.get(g, null);
        TestKeepDeletes.assertTrue((boolean)r.isEmpty());
        Scan s = new Scan();
        s.setMaxVersions();
        s.setTimeRange(0L, ts + 1L);
        RegionScanner scanner = region.getScanner(s);
        ArrayList kvs = new ArrayList();
        while (scanner.next(kvs)) {
        }
        TestKeepDeletes.assertTrue((boolean)kvs.isEmpty());
        region.flushcache();
        region.compactStores();
        TestKeepDeletes.assertEquals((int)1, (int)this.countDeleteMarkers(region));
        region.compactStores(true);
        TestKeepDeletes.assertEquals((int)0, (int)this.countDeleteMarkers(region));
        region.close();
        region.getLog().closeAndDelete();
    }

    public void testRawScanWithColumns() throws Exception {
        HTableDescriptor htd = this.createTableDescriptor(this.getName(), 0, 3, Integer.MAX_VALUE, true);
        HRegion region = this.createNewHRegion(htd, null, null);
        Scan s = new Scan();
        s.setRaw(true);
        s.setMaxVersions();
        s.addColumn(this.c0, this.c0);
        try {
            RegionScanner scan = region.getScanner(s);
            TestKeepDeletes.fail((String)"raw scanner with columns should have failed");
        }
        catch (DoNotRetryIOException dnre) {
            // empty catch block
        }
        region.close();
        region.getLog().closeAndDelete();
    }

    public void testRawScan() throws Exception {
        HTableDescriptor htd = this.createTableDescriptor(this.getName(), 0, 3, Integer.MAX_VALUE, true);
        HRegion region = this.createNewHRegion(htd, null, null);
        long ts = System.currentTimeMillis();
        Put p = new Put(this.T1, ts);
        p.add(this.c0, this.c0, this.T1);
        region.put(p);
        p = new Put(this.T1, ts + 2L);
        p.add(this.c0, this.c0, this.T2);
        region.put(p);
        p = new Put(this.T1, ts + 4L);
        p.add(this.c0, this.c0, this.T3);
        region.put(p);
        Delete d = new Delete(this.T1, ts + 1L, null);
        region.delete(d, null, true);
        d = new Delete(this.T1, ts + 2L, null);
        d.deleteColumn(this.c0, this.c0, ts + 2L);
        region.delete(d, null, true);
        d = new Delete(this.T1, ts + 3L, null);
        d.deleteColumns(this.c0, this.c0, ts + 3L);
        region.delete(d, null, true);
        Scan s = new Scan();
        s.setRaw(true);
        s.setMaxVersions();
        RegionScanner scan = region.getScanner(s);
        ArrayList kvs = new ArrayList();
        scan.next(kvs);
        TestKeepDeletes.assertTrue((boolean)((KeyValue)kvs.get(0)).isDeleteFamily());
        TestKeepDeletes.assertEquals(((KeyValue)kvs.get(1)).getValue(), this.T3);
        TestKeepDeletes.assertTrue((boolean)((KeyValue)kvs.get(2)).isDelete());
        TestKeepDeletes.assertTrue((boolean)((KeyValue)kvs.get(3)).isDeleteType());
        TestKeepDeletes.assertEquals(((KeyValue)kvs.get(4)).getValue(), this.T2);
        TestKeepDeletes.assertEquals(((KeyValue)kvs.get(5)).getValue(), this.T1);
        region.close();
        region.getLog().closeAndDelete();
    }

    public void testDeleteMarkerExpirationEmptyStore() throws Exception {
        HTableDescriptor htd = this.createTableDescriptor(this.getName(), 0, 1, Integer.MAX_VALUE, true);
        HRegion region = this.createNewHRegion(htd, null, null);
        long ts = System.currentTimeMillis();
        Delete d = new Delete(this.T1, ts, null);
        d.deleteColumns(this.c0, this.c0, ts);
        region.delete(d, null, true);
        d = new Delete(this.T1, ts, null);
        d.deleteFamily(this.c0);
        region.delete(d, null, true);
        d = new Delete(this.T1, ts, null);
        d.deleteColumn(this.c0, this.c0, ts + 1L);
        region.delete(d, null, true);
        d = new Delete(this.T1, ts, null);
        d.deleteColumn(this.c0, this.c0, ts + 2L);
        region.delete(d, null, true);
        TestKeepDeletes.assertEquals((int)4, (int)this.countDeleteMarkers(region));
        region.flushcache();
        TestKeepDeletes.assertEquals((int)4, (int)this.countDeleteMarkers(region));
        region.compactStores(false);
        TestKeepDeletes.assertEquals((int)4, (int)this.countDeleteMarkers(region));
        region.compactStores(true);
        TestKeepDeletes.assertEquals((int)0, (int)this.countDeleteMarkers(region));
        region.close();
        region.getLog().closeAndDelete();
    }

    public void testDeleteMarkerExpiration() throws Exception {
        HTableDescriptor htd = this.createTableDescriptor(this.getName(), 0, 1, Integer.MAX_VALUE, true);
        HRegion region = this.createNewHRegion(htd, null, null);
        long ts = System.currentTimeMillis();
        Put p = new Put(this.T1, ts);
        p.add(this.c0, this.c0, this.T1);
        region.put(p);
        p = new Put(this.T1, ts - 10L);
        p.add(this.c1, this.c0, this.T1);
        region.put(p);
        Delete d = new Delete(this.T1, ts, null);
        d.deleteColumns(this.c0, this.c0, ts);
        region.delete(d, null, true);
        d = new Delete(this.T1, ts, null);
        d.deleteFamily(this.c0, ts);
        region.delete(d, null, true);
        d = new Delete(this.T1, ts, null);
        d.deleteColumn(this.c0, this.c0, ts + 1L);
        region.delete(d, null, true);
        d = new Delete(this.T1, ts, null);
        d.deleteColumn(this.c0, this.c0, ts + 2L);
        region.delete(d, null, true);
        TestKeepDeletes.assertEquals((int)4, (int)this.countDeleteMarkers(region));
        region.flushcache();
        TestKeepDeletes.assertEquals((int)4, (int)this.countDeleteMarkers(region));
        region.compactStores(false);
        TestKeepDeletes.assertEquals((int)4, (int)this.countDeleteMarkers(region));
        p = new Put(this.T1, ts + 3L);
        p.add(this.c0, this.c0, this.T1);
        region.put(p);
        region.flushcache();
        region.compactStores(true);
        TestKeepDeletes.assertEquals((int)4, (int)this.countDeleteMarkers(region));
        region.compactStores(true);
        TestKeepDeletes.assertEquals((int)0, (int)this.countDeleteMarkers(region));
        region.close();
        region.getLog().closeAndDelete();
    }

    public void testRanges() throws Exception {
        HTableDescriptor htd = this.createTableDescriptor(this.getName(), 0, 3, Integer.MAX_VALUE, true);
        HRegion region = this.createNewHRegion(htd, null, null);
        long ts = System.currentTimeMillis();
        Put p = new Put(this.T1, ts);
        p.add(this.c0, this.c0, this.T1);
        p.add(this.c0, this.c1, this.T1);
        p.add(this.c1, this.c0, this.T1);
        p.add(this.c1, this.c1, this.T1);
        region.put(p);
        p = new Put(this.T2, ts);
        p.add(this.c0, this.c0, this.T1);
        p.add(this.c0, this.c1, this.T1);
        p.add(this.c1, this.c0, this.T1);
        p.add(this.c1, this.c1, this.T1);
        region.put(p);
        p = new Put(this.T1, ts + 1L);
        p.add(this.c0, this.c0, this.T2);
        p.add(this.c0, this.c1, this.T2);
        p.add(this.c1, this.c0, this.T2);
        p.add(this.c1, this.c1, this.T2);
        region.put(p);
        p = new Put(this.T2, ts + 1L);
        p.add(this.c0, this.c0, this.T2);
        p.add(this.c0, this.c1, this.T2);
        p.add(this.c1, this.c0, this.T2);
        p.add(this.c1, this.c1, this.T2);
        region.put(p);
        Delete d = new Delete(this.T1, ts + 2L, null);
        d.deleteColumns(this.c0, this.c0, ts + 2L);
        region.delete(d, null, true);
        d = new Delete(this.T1, ts + 2L, null);
        d.deleteFamily(this.c1, ts + 2L);
        region.delete(d, null, true);
        d = new Delete(this.T2, ts + 2L, null);
        d.deleteFamily(this.c0, ts + 2L);
        region.delete(d, null, true);
        d = new Delete(this.T1, ts - 10L, null);
        d.deleteFamily(this.c1, ts - 10L);
        region.delete(d, null, true);
        this.checkGet(region, this.T1, this.c0, this.c0, ts + 2L, this.T2, this.T1);
        this.checkGet(region, this.T1, this.c0, this.c1, ts + 2L, this.T2, this.T1);
        this.checkGet(region, this.T1, this.c1, this.c0, ts + 2L, this.T2, this.T1);
        this.checkGet(region, this.T1, this.c1, this.c1, ts + 2L, this.T2, this.T1);
        this.checkGet(region, this.T2, this.c0, this.c0, ts + 2L, this.T2, this.T1);
        this.checkGet(region, this.T2, this.c0, this.c1, ts + 2L, this.T2, this.T1);
        this.checkGet(region, this.T2, this.c1, this.c0, ts + 2L, this.T2, this.T1);
        this.checkGet(region, this.T2, this.c1, this.c1, ts + 2L, this.T2, this.T1);
        this.checkGet(region, this.T1, this.c0, this.c0, ts + 3L, new byte[0][]);
        this.checkGet(region, this.T1, this.c0, this.c1, ts + 3L, this.T2, this.T1);
        this.checkGet(region, this.T1, this.c1, this.c0, ts + 3L, new byte[0][]);
        this.checkGet(region, this.T1, this.c1, this.c1, ts + 3L, new byte[0][]);
        this.checkGet(region, this.T2, this.c0, this.c0, ts + 3L, new byte[0][]);
        this.checkGet(region, this.T2, this.c0, this.c1, ts + 3L, new byte[0][]);
        this.checkGet(region, this.T2, this.c1, this.c0, ts + 3L, this.T2, this.T1);
        this.checkGet(region, this.T2, this.c1, this.c1, ts + 3L, this.T2, this.T1);
        region.close();
        region.getLog().closeAndDelete();
    }

    public void testDeleteMarkerVersioning() throws Exception {
        HTableDescriptor htd = this.createTableDescriptor(this.getName(), 0, 1, Integer.MAX_VALUE, true);
        HRegion region = this.createNewHRegion(htd, null, null);
        long ts = System.currentTimeMillis();
        Put p = new Put(this.T1, ts);
        p.add(this.c0, this.c0, this.T1);
        region.put(p);
        p = new Put(this.T1, ts - 10L);
        p.add(this.c0, this.c1, this.T1);
        region.put(p);
        Delete d = new Delete(this.T1, ts, null);
        d.deleteColumns(this.c0, this.c0, ts);
        region.delete(d, null, true);
        d = new Delete(this.T1, ts + 1L, null);
        d.deleteColumn(this.c0, this.c0, ts + 1L);
        region.delete(d, null, true);
        d = new Delete(this.T1, ts + 3L, null);
        d.deleteColumn(this.c0, this.c0, ts + 3L);
        region.delete(d, null, true);
        region.flushcache();
        region.compactStores(true);
        region.compactStores(true);
        TestKeepDeletes.assertEquals((int)3, (int)this.countDeleteMarkers(region));
        p = new Put(this.T1, ts + 2L);
        p.add(this.c0, this.c0, this.T2);
        region.put(p);
        TestKeepDeletes.assertEquals((int)3, (int)this.countDeleteMarkers(region));
        p = new Put(this.T1, ts + 3L);
        p.add(this.c0, this.c0, this.T3);
        region.put(p);
        TestKeepDeletes.assertEquals((int)1, (int)this.countDeleteMarkers(region));
        region.flushcache();
        TestKeepDeletes.assertEquals((int)3, (int)this.countDeleteMarkers(region));
        region.compactStores(true);
        TestKeepDeletes.assertEquals((int)3, (int)this.countDeleteMarkers(region));
        p = new Put(this.T1, ts + 4L);
        p.add(this.c0, this.c0, this.T4);
        region.put(p);
        region.flushcache();
        TestKeepDeletes.assertEquals((int)1, (int)this.countDeleteMarkers(region));
        region.compactStores(true);
        region.compactStores(true);
        TestKeepDeletes.assertEquals((int)1, (int)this.countDeleteMarkers(region));
        region.close();
        region.getLog().closeAndDelete();
    }

    public void testWithMixedCFs() throws Exception {
        HTableDescriptor htd = this.createTableDescriptor(this.getName(), 0, 1, Integer.MAX_VALUE, true);
        HRegion region = this.createNewHRegion(htd, null, null);
        long ts = System.currentTimeMillis();
        Put p = new Put(this.T1, ts);
        p.add(this.c0, this.c0, this.T1);
        p.add(this.c0, this.c1, this.T1);
        p.add(this.c1, this.c0, this.T1);
        p.add(this.c1, this.c1, this.T1);
        region.put(p);
        p = new Put(this.T2, ts + 1L);
        p.add(this.c0, this.c0, this.T2);
        p.add(this.c0, this.c1, this.T2);
        p.add(this.c1, this.c0, this.T2);
        p.add(this.c1, this.c1, this.T2);
        region.put(p);
        Delete d = new Delete(this.T1, ts + 1L, null);
        region.delete(d, null, true);
        d = new Delete(this.T2, ts + 2L, null);
        region.delete(d, null, true);
        Scan s = new Scan(this.T1);
        s.setTimeRange(0L, ts + 1L);
        RegionScanner scanner = region.getScanner(s);
        ArrayList kvs = new ArrayList();
        scanner.next(kvs);
        TestKeepDeletes.assertEquals((int)4, (int)kvs.size());
        scanner.close();
        s = new Scan(this.T2);
        s.setTimeRange(0L, ts + 2L);
        scanner = region.getScanner(s);
        kvs = new ArrayList();
        scanner.next(kvs);
        TestKeepDeletes.assertEquals((int)4, (int)kvs.size());
        scanner.close();
        region.close();
        region.getLog().closeAndDelete();
    }

    public void testWithMinVersions() throws Exception {
        HTableDescriptor htd = this.createTableDescriptor(this.getName(), 3, 1000, 1, true);
        HRegion region = this.createNewHRegion(htd, null, null);
        long ts = System.currentTimeMillis() - 2000L;
        Put p = new Put(this.T1, ts);
        p.add(this.c0, this.c0, this.T3);
        region.put(p);
        p = new Put(this.T1, ts - 1L);
        p.add(this.c0, this.c0, this.T2);
        region.put(p);
        p = new Put(this.T1, ts - 3L);
        p.add(this.c0, this.c0, this.T1);
        region.put(p);
        p = new Put(this.T1, ts - 4L);
        p.add(this.c0, this.c0, this.T0);
        region.put(p);
        Delete d = new Delete(this.T1, ts - 1L, null);
        region.delete(d, null, true);
        d = new Delete(this.T1, ts - 2L, null);
        d.deleteColumns(this.c0, this.c0, ts - 1L);
        region.delete(d, null, true);
        Get g = new Get(this.T1);
        g.setMaxVersions();
        g.setTimeRange(0L, ts - 2L);
        Result r = region.get(g, null);
        this.checkResult(r, this.c0, this.c0, this.T1, this.T0);
        TestKeepDeletes.assertEquals((int)4, (int)this.countDeleteMarkers(region));
        region.flushcache();
        TestKeepDeletes.assertEquals((int)4, (int)this.countDeleteMarkers(region));
        r = region.get(g, null);
        this.checkResult(r, this.c0, this.c0, new byte[][]{this.T1});
        p = new Put(this.T1, ts + 1L);
        p.add(this.c0, this.c0, this.T4);
        region.put(p);
        region.flushcache();
        TestKeepDeletes.assertEquals((int)4, (int)this.countDeleteMarkers(region));
        r = region.get(g, null);
        this.checkResult(r, this.c0, this.c0, new byte[][]{this.T1});
        p = new Put(this.T1, ts + 2L);
        p.add(this.c0, this.c0, this.T5);
        region.put(p);
        region.flushcache();
        region.compactStores(true);
        TestKeepDeletes.assertEquals((int)2, (int)this.countDeleteMarkers(region));
        region.compactStores(true);
        TestKeepDeletes.assertEquals((int)0, (int)this.countDeleteMarkers(region));
        region.close();
        region.getLog().closeAndDelete();
    }

    private void checkGet(HRegion region, byte[] row, byte[] fam, byte[] col, long time, byte[] ... vals) throws IOException {
        Get g = new Get(row);
        g.addColumn(fam, col);
        g.setMaxVersions();
        g.setTimeRange(0L, time);
        Result r = region.get(g, null);
        this.checkResult(r, fam, col, vals);
    }

    private int countDeleteMarkers(HRegion region) throws IOException {
        boolean hasMore;
        Scan s = new Scan();
        s.setRaw(true);
        s.setMaxVersions();
        RegionScanner scan = region.getScanner(s);
        ArrayList kvs = new ArrayList();
        int res = 0;
        do {
            hasMore = scan.next(kvs);
            for (KeyValue kv : kvs) {
                if (!kv.isDelete()) continue;
                ++res;
            }
            kvs.clear();
        } while (hasMore);
        scan.close();
        return res;
    }

    private void checkResult(Result r, byte[] fam, byte[] col, byte[] ... vals) {
        TestKeepDeletes.assertEquals((int)r.size(), (int)vals.length);
        List kvs = r.getColumn(fam, col);
        TestKeepDeletes.assertEquals((int)kvs.size(), (int)vals.length);
        for (int i = 0; i < vals.length; ++i) {
            TestKeepDeletes.assertEquals(((KeyValue)kvs.get(i)).getValue(), vals[i]);
        }
    }
}

