/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Iterator;
import java.util.SortedSet;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.regionserver.KeyValueSkipListSet;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestKeyValueSkipListSet
extends TestCase {
    private final KeyValueSkipListSet kvsls = new KeyValueSkipListSet(KeyValue.COMPARATOR);
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    protected void setUp() throws Exception {
        super.setUp();
        this.kvsls.clear();
    }

    public void testAdd() throws Exception {
        byte[] bytes = Bytes.toBytes((String)this.getName());
        KeyValue kv = new KeyValue(bytes, bytes, bytes, bytes);
        this.kvsls.add(kv);
        TestKeyValueSkipListSet.assertTrue((boolean)this.kvsls.contains((Object)kv));
        TestKeyValueSkipListSet.assertEquals((int)1, (int)this.kvsls.size());
        KeyValue first = this.kvsls.first();
        TestKeyValueSkipListSet.assertTrue((boolean)kv.equals((Object)first));
        TestKeyValueSkipListSet.assertTrue((boolean)Bytes.equals((byte[])kv.getValue(), (byte[])first.getValue()));
        byte[] overwriteValue = Bytes.toBytes((String)"overwrite");
        KeyValue overwrite = new KeyValue(bytes, bytes, bytes, overwriteValue);
        this.kvsls.add(overwrite);
        TestKeyValueSkipListSet.assertEquals((int)1, (int)this.kvsls.size());
        first = this.kvsls.first();
        TestKeyValueSkipListSet.assertTrue((boolean)Bytes.equals((byte[])overwrite.getValue(), (byte[])first.getValue()));
        TestKeyValueSkipListSet.assertFalse((boolean)Bytes.equals((byte[])overwrite.getValue(), (byte[])kv.getValue()));
    }

    public void testIterator() throws Exception {
        byte[] bytes = Bytes.toBytes((String)this.getName());
        byte[] value1 = Bytes.toBytes((String)"1");
        byte[] value2 = Bytes.toBytes((String)"2");
        int total = 3;
        for (int i = 0; i < 3; ++i) {
            this.kvsls.add(new KeyValue(bytes, bytes, Bytes.toBytes((String)("" + i)), value1));
        }
        int count = 0;
        for (KeyValue kv : this.kvsls) {
            TestKeyValueSkipListSet.assertEquals((String)("" + count), (String)Bytes.toString((byte[])kv.getQualifier()));
            TestKeyValueSkipListSet.assertTrue((boolean)Bytes.equals((byte[])kv.getValue(), (byte[])value1));
            ++count;
        }
        TestKeyValueSkipListSet.assertEquals((int)3, (int)count);
        for (int i = 0; i < 3; ++i) {
            this.kvsls.add(new KeyValue(bytes, bytes, Bytes.toBytes((String)("" + i)), value2));
        }
        count = 0;
        for (KeyValue kv : this.kvsls) {
            TestKeyValueSkipListSet.assertEquals((String)("" + count), (String)Bytes.toString((byte[])kv.getQualifier()));
            TestKeyValueSkipListSet.assertTrue((boolean)Bytes.equals((byte[])kv.getValue(), (byte[])value2));
            ++count;
        }
        TestKeyValueSkipListSet.assertEquals((int)3, (int)count);
    }

    public void testDescendingIterator() throws Exception {
        KeyValue kv;
        byte[] bytes = Bytes.toBytes((String)this.getName());
        byte[] value1 = Bytes.toBytes((String)"1");
        byte[] value2 = Bytes.toBytes((String)"2");
        int total = 3;
        for (int i = 0; i < 3; ++i) {
            this.kvsls.add(new KeyValue(bytes, bytes, Bytes.toBytes((String)("" + i)), value1));
        }
        int count = 0;
        Iterator i = this.kvsls.descendingIterator();
        while (i.hasNext()) {
            kv = (KeyValue)i.next();
            TestKeyValueSkipListSet.assertEquals((String)("" + (3 - (count + 1))), (String)Bytes.toString((byte[])kv.getQualifier()));
            TestKeyValueSkipListSet.assertTrue((boolean)Bytes.equals((byte[])kv.getValue(), (byte[])value1));
            ++count;
        }
        TestKeyValueSkipListSet.assertEquals((int)3, (int)count);
        for (int i2 = 0; i2 < 3; ++i2) {
            this.kvsls.add(new KeyValue(bytes, bytes, Bytes.toBytes((String)("" + i2)), value2));
        }
        count = 0;
        Iterator i3 = this.kvsls.descendingIterator();
        while (i3.hasNext()) {
            kv = (KeyValue)i3.next();
            TestKeyValueSkipListSet.assertEquals((String)("" + (3 - (count + 1))), (String)Bytes.toString((byte[])kv.getQualifier()));
            TestKeyValueSkipListSet.assertTrue((boolean)Bytes.equals((byte[])kv.getValue(), (byte[])value2));
            ++count;
        }
        TestKeyValueSkipListSet.assertEquals((int)3, (int)count);
    }

    public void testHeadTail() throws Exception {
        byte[] bytes = Bytes.toBytes((String)this.getName());
        byte[] value1 = Bytes.toBytes((String)"1");
        byte[] value2 = Bytes.toBytes((String)"2");
        int total = 3;
        KeyValue splitter = null;
        for (int i = 0; i < 3; ++i) {
            KeyValue kv = new KeyValue(bytes, bytes, Bytes.toBytes((String)("" + i)), value1);
            if (i == 1) {
                splitter = kv;
            }
            this.kvsls.add(kv);
        }
        SortedSet tail = this.kvsls.tailSet(splitter);
        TestKeyValueSkipListSet.assertEquals((int)2, (int)tail.size());
        SortedSet head = this.kvsls.headSet(splitter);
        TestKeyValueSkipListSet.assertEquals((int)1, (int)head.size());
        for (int i = 0; i < 3; ++i) {
            this.kvsls.add(new KeyValue(bytes, bytes, Bytes.toBytes((String)("" + i)), value2));
        }
        tail = this.kvsls.tailSet(splitter);
        TestKeyValueSkipListSet.assertTrue((boolean)Bytes.equals((byte[])((KeyValue)tail.first()).getValue(), (byte[])value2));
        head = this.kvsls.headSet(splitter);
        TestKeyValueSkipListSet.assertTrue((boolean)Bytes.equals((byte[])((KeyValue)head.first()).getValue(), (byte[])value2));
    }
}

