/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestQueryMatcher
extends HBaseTestCase {
    private static final boolean PRINT = false;
    private byte[] row1;
    private byte[] row2;
    private byte[] fam1;
    private byte[] fam2;
    private byte[] col1;
    private byte[] col2;
    private byte[] col3;
    private byte[] col4;
    private byte[] col5;
    private byte[] data;
    private Get get;
    long ttl = Long.MAX_VALUE;
    KeyValue.KVComparator rowComparator;
    private Scan scan;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.row1 = Bytes.toBytes((String)"row1");
        this.row2 = Bytes.toBytes((String)"row2");
        this.fam1 = Bytes.toBytes((String)"fam1");
        this.fam2 = Bytes.toBytes((String)"fam2");
        this.col1 = Bytes.toBytes((String)"col1");
        this.col2 = Bytes.toBytes((String)"col2");
        this.col3 = Bytes.toBytes((String)"col3");
        this.col4 = Bytes.toBytes((String)"col4");
        this.col5 = Bytes.toBytes((String)"col5");
        this.data = Bytes.toBytes((String)"data");
        this.get = new Get(this.row1);
        this.get.addFamily(this.fam1);
        this.get.addColumn(this.fam2, this.col2);
        this.get.addColumn(this.fam2, this.col4);
        this.get.addColumn(this.fam2, this.col5);
        this.scan = new Scan(this.get);
        this.rowComparator = KeyValue.COMPARATOR;
    }

    public void testMatch_ExplicitColumns() throws IOException {
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>();
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW);
        expected.add(ScanQueryMatcher.MatchCode.DONE);
        ScanQueryMatcher qm = new ScanQueryMatcher(this.scan, new Store.ScanInfo(this.fam2, 0, 1, this.ttl, false, 0L, this.rowComparator), (NavigableSet)this.get.getFamilyMap().get(this.fam2), EnvironmentEdgeManager.currentTimeMillis() - this.ttl);
        ArrayList<KeyValue> memstore = new ArrayList<KeyValue>();
        memstore.add(new KeyValue(this.row1, this.fam2, this.col1, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col2, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col3, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col4, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col5, 1L, this.data));
        memstore.add(new KeyValue(this.row2, this.fam1, this.col1, this.data));
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>();
        KeyValue k = (KeyValue)memstore.get(0);
        qm.setRow(k.getBuffer(), k.getRowOffset(), k.getRowLength());
        for (KeyValue kv : memstore) {
            actual.add(qm.match(kv));
        }
        TestQueryMatcher.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestQueryMatcher.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testMatch_Wildcard() throws IOException {
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>();
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.DONE);
        ScanQueryMatcher qm = new ScanQueryMatcher(this.scan, new Store.ScanInfo(this.fam2, 0, 1, this.ttl, false, 0L, this.rowComparator), null, EnvironmentEdgeManager.currentTimeMillis() - this.ttl);
        ArrayList<KeyValue> memstore = new ArrayList<KeyValue>();
        memstore.add(new KeyValue(this.row1, this.fam2, this.col1, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col2, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col3, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col4, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col5, 1L, this.data));
        memstore.add(new KeyValue(this.row2, this.fam1, this.col1, 1L, this.data));
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>();
        KeyValue k = (KeyValue)memstore.get(0);
        qm.setRow(k.getBuffer(), k.getRowOffset(), k.getRowLength());
        for (KeyValue kv : memstore) {
            actual.add(qm.match(kv));
        }
        TestQueryMatcher.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestQueryMatcher.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testMatch_ExpiredExplicit() throws IOException {
        long testTTL = 1000L;
        ScanQueryMatcher.MatchCode[] expected = new ScanQueryMatcher.MatchCode[]{ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW, ScanQueryMatcher.MatchCode.DONE};
        long now = EnvironmentEdgeManager.currentTimeMillis();
        ScanQueryMatcher qm = new ScanQueryMatcher(this.scan, new Store.ScanInfo(this.fam2, 0, 1, testTTL, false, 0L, this.rowComparator), (NavigableSet)this.get.getFamilyMap().get(this.fam2), now - testTTL);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(this.row1, this.fam2, this.col1, now - 100L, this.data), new KeyValue(this.row1, this.fam2, this.col2, now - 50L, this.data), new KeyValue(this.row1, this.fam2, this.col3, now - 5000L, this.data), new KeyValue(this.row1, this.fam2, this.col4, now - 500L, this.data), new KeyValue(this.row1, this.fam2, this.col5, now - 10000L, this.data), new KeyValue(this.row2, this.fam1, this.col1, now - 10L, this.data)};
        KeyValue k = kvs[0];
        qm.setRow(k.getBuffer(), k.getRowOffset(), k.getRowLength());
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>(kvs.length);
        for (KeyValue kv : kvs) {
            actual.add(qm.match(kv));
        }
        TestQueryMatcher.assertEquals((int)expected.length, (int)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            TestQueryMatcher.assertEquals((Object)expected[i], actual.get(i));
        }
    }

    public void testMatch_ExpiredWildcard() throws IOException {
        long testTTL = 1000L;
        ScanQueryMatcher.MatchCode[] expected = new ScanQueryMatcher.MatchCode[]{ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.DONE};
        long now = EnvironmentEdgeManager.currentTimeMillis();
        ScanQueryMatcher qm = new ScanQueryMatcher(this.scan, new Store.ScanInfo(this.fam2, 0, 1, testTTL, false, 0L, this.rowComparator), null, now - testTTL);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(this.row1, this.fam2, this.col1, now - 100L, this.data), new KeyValue(this.row1, this.fam2, this.col2, now - 50L, this.data), new KeyValue(this.row1, this.fam2, this.col3, now - 5000L, this.data), new KeyValue(this.row1, this.fam2, this.col4, now - 500L, this.data), new KeyValue(this.row1, this.fam2, this.col5, now - 10000L, this.data), new KeyValue(this.row2, this.fam1, this.col1, now - 10L, this.data)};
        KeyValue k = kvs[0];
        qm.setRow(k.getBuffer(), k.getRowOffset(), k.getRowLength());
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>(kvs.length);
        for (KeyValue kv : kvs) {
            actual.add(qm.match(kv));
        }
        TestQueryMatcher.assertEquals((int)expected.length, (int)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            TestQueryMatcher.assertEquals((Object)expected[i], actual.get(i));
        }
    }
}

