/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.TestMasterFailover;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestRSKilledWhenMasterInitializing {
    private static final Log LOG = LogFactory.getLog(TestMasterFailover.class);
    private static final HBaseTestingUtility TESTUTIL = new HBaseTestingUtility();
    private static final int NUM_MASTERS = 1;
    private static final int NUM_RS = 4;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TESTUTIL.getConfiguration();
        conf.setClass("hbase.master.impl", TestingMaster.class, HMaster.class);
        conf.setInt("hbase.master.wait.on.regionservers.mintostart", 3);
        conf.setInt("hbase.master.wait.on.regionservers.maxtostart", 4);
        TESTUTIL.startMiniCluster(1, 4);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (!TESTUTIL.getHBaseCluster().getMaster().isInitialized()) {
            for (JVMClusterUtil.MasterThread mt : TESTUTIL.getHBaseCluster().getLiveMasterThreads()) {
                mt.interrupt();
            }
        }
        TESTUTIL.shutdownMiniCluster();
    }

    @Test(timeout=120000L)
    public void testCorrectnessWhenMasterFailOver() throws Exception {
        byte[] TABLENAME = Bytes.toBytes((String)"testCorrectnessWhenMasterFailOver");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[][] SPLITKEYS = new byte[][]{Bytes.toBytes((String)"b"), Bytes.toBytes((String)"i")};
        MiniHBaseCluster cluster = TESTUTIL.getHBaseCluster();
        HTableDescriptor desc = new HTableDescriptor(TABLENAME);
        desc.addFamily(new HColumnDescriptor(FAMILY));
        HBaseAdmin hbaseAdmin = TESTUTIL.getHBaseAdmin();
        hbaseAdmin.createTable(desc, (byte[][])SPLITKEYS);
        Assert.assertTrue((boolean)hbaseAdmin.isTableAvailable(TABLENAME));
        HTable table = new HTable(TESTUTIL.getConfiguration(), TABLENAME);
        ArrayList<Put> puts = new ArrayList<Put>();
        Put put1 = new Put(Bytes.toBytes((String)"a"));
        put1.add(FAMILY, Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"value"));
        Put put2 = new Put(Bytes.toBytes((String)"h"));
        put2.add(FAMILY, Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"value"));
        Put put3 = new Put(Bytes.toBytes((String)"o"));
        put3.add(FAMILY, Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"value"));
        puts.add(put1);
        puts.add(put2);
        puts.add(put3);
        table.put(puts);
        ResultScanner resultScanner = table.getScanner(new Scan());
        int count = 0;
        while (resultScanner.next() != null) {
            ++count;
        }
        resultScanner.close();
        table.close();
        Assert.assertEquals((long)3L, (long)count);
        cluster.getConfiguration().setBoolean("TestingMaster.sleep", true);
        cluster.getConfiguration().setInt("TestingMaster.sleep.duration", 10000);
        this.abortMaster(cluster);
        TestingMaster master = this.startMasterAndWaitUntilLogSplit(cluster);
        int metaServerNum = cluster.getServerWithMeta();
        int rootServerNum = cluster.getServerWith(HRegionInfo.ROOT_REGIONINFO.getRegionName());
        HRegionServer metaRS = cluster.getRegionServer(metaServerNum);
        LOG.debug((Object)("Killing metaRS and carryingRoot = " + (metaServerNum == rootServerNum)));
        metaRS.kill();
        metaRS.join();
        Thread.sleep(20000L);
        this.waitUntilMasterIsInitialized(master);
        Assert.assertTrue((boolean)hbaseAdmin.isTableAvailable(TABLENAME));
        if (rootServerNum != metaServerNum) {
            this.abortMaster(cluster);
            master = this.startMasterAndWaitUntilLogSplit(cluster);
            HRegionServer rootRS = cluster.getRegionServer(rootServerNum);
            LOG.debug((Object)"Killing rootRS");
            rootRS.kill();
            rootRS.join();
            Thread.sleep(20000L);
            this.waitUntilMasterIsInitialized(master);
            Assert.assertTrue((boolean)hbaseAdmin.isTableAvailable(TABLENAME));
        }
        ServerManager serverManager = cluster.getMaster().getServerManager();
        while (serverManager.areDeadServersInProgress()) {
            Thread.sleep(100L);
        }
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(TESTUTIL);
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
        table = new HTable(TESTUTIL.getConfiguration(), TABLENAME);
        resultScanner = table.getScanner(new Scan());
        count = 0;
        while (resultScanner.next() != null) {
            ++count;
        }
        resultScanner.close();
        table.close();
        Assert.assertEquals((long)3L, (long)count);
    }

    private void abortMaster(MiniHBaseCluster cluster) throws InterruptedException {
        for (JVMClusterUtil.MasterThread mt : cluster.getLiveMasterThreads()) {
            if (!mt.getMaster().isActiveMaster()) continue;
            mt.getMaster().abort("Aborting for tests", (Throwable)new Exception("Trace info"));
            mt.join();
            break;
        }
        LOG.debug((Object)"Master is aborted");
    }

    private TestingMaster startMasterAndWaitUntilLogSplit(MiniHBaseCluster cluster) throws IOException, InterruptedException {
        TestingMaster master = (TestingMaster)cluster.startMaster().getMaster();
        while (!master.isLogSplitAfterStartup()) {
            Thread.sleep(100L);
        }
        LOG.debug((Object)("splitted:" + master.isLogSplitAfterStartup() + ",initialized:" + master.isInitialized()));
        return master;
    }

    private void waitUntilMasterIsInitialized(HMaster master) throws InterruptedException {
        while (!master.isInitialized()) {
            Thread.sleep(100L);
        }
        LOG.debug((Object)"master isInitialized");
    }

    public static class TestingMaster
    extends HMaster {
        private boolean logSplit = false;

        public TestingMaster(Configuration conf) throws IOException, KeeperException, InterruptedException {
            super(conf);
        }

        protected void splitLogAfterStartup(MasterFileSystem mfs) {
            super.splitLogAfterStartup(mfs);
            this.logSplit = true;
            if (this.getConfiguration().getBoolean("TestingMaster.sleep", false)) {
                int duration = this.getConfiguration().getInt("TestingMaster.sleep.duration", 0);
                Threads.sleep((long)duration);
            }
        }

        public boolean isLogSplitAfterStartup() {
            return this.logSplit;
        }
    }
}

