/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.ScanDeleteTracker;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestScanDeleteTracker
extends HBaseTestCase {
    private ScanDeleteTracker sdt;
    private long timestamp = 10L;
    private byte deleteType = 0;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.sdt = new ScanDeleteTracker();
    }

    public void testDeletedBy_Delete() {
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        this.deleteType = KeyValue.Type.Delete.getCode();
        this.sdt.add(qualifier, 0, qualifier.length, this.timestamp, this.deleteType);
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted(qualifier, 0, qualifier.length, this.timestamp);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_DELETED, (Object)ret);
    }

    public void testDeletedBy_DeleteColumn() {
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        this.deleteType = KeyValue.Type.DeleteColumn.getCode();
        this.sdt.add(qualifier, 0, qualifier.length, this.timestamp, this.deleteType);
        this.timestamp -= 5L;
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted(qualifier, 0, qualifier.length, this.timestamp);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.COLUMN_DELETED, (Object)ret);
    }

    public void testDeletedBy_DeleteFamily() {
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        this.deleteType = KeyValue.Type.DeleteFamily.getCode();
        this.sdt.add(qualifier, 0, qualifier.length, this.timestamp, this.deleteType);
        this.timestamp -= 5L;
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted(qualifier, 0, qualifier.length, this.timestamp);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.FAMILY_DELETED, (Object)ret);
    }

    public void testDelete_DeleteColumn() {
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        this.deleteType = KeyValue.Type.Delete.getCode();
        this.sdt.add(qualifier, 0, qualifier.length, this.timestamp, this.deleteType);
        this.timestamp -= 5L;
        this.deleteType = KeyValue.Type.DeleteColumn.getCode();
        this.sdt.add(qualifier, 0, qualifier.length, this.timestamp, this.deleteType);
        this.timestamp -= 5L;
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted(qualifier, 0, qualifier.length, this.timestamp);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.COLUMN_DELETED, (Object)ret);
    }

    public void testDeleteColumn_Delete() {
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        this.deleteType = KeyValue.Type.DeleteColumn.getCode();
        this.sdt.add(qualifier, 0, qualifier.length, this.timestamp, this.deleteType);
        qualifier = Bytes.toBytes((String)"qualifier1");
        this.deleteType = KeyValue.Type.Delete.getCode();
        this.sdt.add(qualifier, 0, qualifier.length, this.timestamp, this.deleteType);
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted(qualifier, 0, qualifier.length, this.timestamp);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_DELETED, (Object)ret);
    }

    public void testDelete_KeepDelete() {
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        this.deleteType = KeyValue.Type.Delete.getCode();
        this.sdt.add(qualifier, 0, qualifier.length, this.timestamp, this.deleteType);
        this.sdt.isDeleted(qualifier, 0, qualifier.length, this.timestamp);
        TestScanDeleteTracker.assertEquals((boolean)false, (boolean)this.sdt.isEmpty());
    }

    public void testDelete_KeepVersionZero() {
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        this.deleteType = KeyValue.Type.Delete.getCode();
        long deleteTimestamp = 10L;
        long valueTimestamp = 0L;
        this.sdt.reset();
        this.sdt.add(qualifier, 0, qualifier.length, deleteTimestamp, this.deleteType);
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted(qualifier, 0, qualifier.length, valueTimestamp);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)ret);
    }
}

