/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.ipc.ProtocolSignature;
import org.apache.hadoop.hbase.ipc.VersionedProtocol;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestServerCustomProtocol {
    private static final byte[] TEST_TABLE = Bytes.toBytes((String)"test");
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"f1");
    private static final byte[] ROW_A = Bytes.toBytes((String)"aaa");
    private static final byte[] ROW_B = Bytes.toBytes((String)"bbb");
    private static final byte[] ROW_C = Bytes.toBytes((String)"ccc");
    private static final byte[] ROW_AB = Bytes.toBytes((String)"abb");
    private static final byte[] ROW_BC = Bytes.toBytes((String)"bcc");
    private static HBaseTestingUtility util = new HBaseTestingUtility();
    private static MiniHBaseCluster cluster = null;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        util.getConfiguration().set("hbase.coprocessor.region.classes", PingHandler.class.getName());
        util.startMiniCluster(1);
        cluster = util.getMiniHBaseCluster();
        HTable table = util.createTable(TEST_TABLE, TEST_FAMILY);
        util.createMultiRegions(util.getConfiguration(), table, TEST_FAMILY, new byte[][]{HConstants.EMPTY_BYTE_ARRAY, ROW_B, ROW_C});
        Put puta = new Put(ROW_A);
        puta.add(TEST_FAMILY, Bytes.toBytes((String)"col1"), Bytes.toBytes((int)1));
        table.put(puta);
        Put putb = new Put(ROW_B);
        putb.add(TEST_FAMILY, Bytes.toBytes((String)"col1"), Bytes.toBytes((int)1));
        table.put(putb);
        Put putc = new Put(ROW_C);
        putc.add(TEST_FAMILY, Bytes.toBytes((String)"col1"), Bytes.toBytes((int)1));
        table.put(putc);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @Test
    public void testSingleProxy() throws Exception {
        HTable table = new HTable(util.getConfiguration(), TEST_TABLE);
        PingProtocol pinger = (PingProtocol)table.coprocessorProxy(PingProtocol.class, ROW_A);
        String result = pinger.ping();
        Assert.assertEquals((String)"Invalid custom protocol response", (Object)"pong", (Object)result);
        result = pinger.hello("George");
        Assert.assertEquals((String)"Invalid custom protocol response", (Object)"Hello, George", (Object)result);
        result = pinger.hello(null);
        Assert.assertEquals((String)"Should handle NULL parameter", (Object)"Who are you?", (Object)result);
        result = pinger.hello("nobody");
        Assert.assertNull((Object)result);
        int cnt = pinger.getPingCount();
        Assert.assertTrue((String)"Count should be incremented", (cnt > 0 ? 1 : 0) != 0);
        int newcnt = pinger.incrementCount(5);
        Assert.assertEquals((String)"Counter should have incremented by 5", (long)(cnt + 5), (long)newcnt);
    }

    @Test
    public void testSingleMethod() throws Throwable {
        HTable table = new HTable(util.getConfiguration(), TEST_TABLE);
        ArrayList rows = Lists.newArrayList((Object[])new Get[]{new Get(ROW_A), new Get(ROW_B), new Get(ROW_C)});
        Batch.Call call = Batch.forMethod(PingProtocol.class, (String)"ping", (Object[])new Object[0]);
        Map results = table.coprocessorExec(PingProtocol.class, ROW_A, ROW_C, call);
        this.verifyRegionResults(table, results, ROW_A);
        this.verifyRegionResults(table, results, ROW_B);
        this.verifyRegionResults(table, results, ROW_C);
        Batch.Call helloCall = Batch.forMethod(PingProtocol.class, (String)"hello", (Object[])new Object[]{"NAME"});
        results = table.coprocessorExec(PingProtocol.class, ROW_A, ROW_C, helloCall);
        this.verifyRegionResults(table, results, "Hello, NAME", ROW_A);
        this.verifyRegionResults(table, results, "Hello, NAME", ROW_B);
        this.verifyRegionResults(table, results, "Hello, NAME", ROW_C);
    }

    @Test
    public void testRowRange() throws Throwable {
        HTable table = new HTable(util.getConfiguration(), TEST_TABLE);
        Map results = table.coprocessorExec(PingProtocol.class, null, null, (Batch.Call)new Batch.Call<PingProtocol, String>(){

            public String call(PingProtocol instance) {
                return instance.ping();
            }
        });
        this.verifyRegionResults(table, results, ROW_A);
        this.verifyRegionResults(table, results, ROW_B);
        this.verifyRegionResults(table, results, ROW_C);
        results = table.coprocessorExec(PingProtocol.class, ROW_BC, null, (Batch.Call)new Batch.Call<PingProtocol, String>(){

            public String call(PingProtocol instance) {
                return instance.ping();
            }
        });
        HRegionLocation loc = table.getRegionLocation(ROW_A);
        Assert.assertNull((String)"Should be missing region for row aaa (prior to start row)", results.get(loc.getRegionInfo().getRegionName()));
        this.verifyRegionResults(table, results, ROW_B);
        this.verifyRegionResults(table, results, ROW_C);
        results = table.coprocessorExec(PingProtocol.class, null, ROW_BC, (Batch.Call)new Batch.Call<PingProtocol, String>(){

            public String call(PingProtocol instance) {
                return instance.ping();
            }
        });
        this.verifyRegionResults(table, results, ROW_A);
        this.verifyRegionResults(table, results, ROW_B);
        loc = table.getRegionLocation(ROW_C);
        Assert.assertNull((String)"Should be missing region for row ccc (past stop row)", results.get(loc.getRegionInfo().getRegionName()));
        results = table.coprocessorExec(PingProtocol.class, ROW_AB, ROW_BC, (Batch.Call)new Batch.Call<PingProtocol, String>(){

            public String call(PingProtocol instance) {
                return instance.ping();
            }
        });
        this.verifyRegionResults(table, results, ROW_A);
        this.verifyRegionResults(table, results, ROW_B);
        loc = table.getRegionLocation(ROW_C);
        Assert.assertNull((String)"Should be missing region for row ccc (past stop row)", results.get(loc.getRegionInfo().getRegionName()));
        results = table.coprocessorExec(PingProtocol.class, ROW_B, ROW_BC, (Batch.Call)new Batch.Call<PingProtocol, String>(){

            public String call(PingProtocol instance) {
                return instance.ping();
            }
        });
        this.verifyRegionResults(table, results, ROW_B);
        loc = table.getRegionLocation(ROW_A);
        Assert.assertNull((String)"Should be missing region for row aaa (prior to start)", results.get(loc.getRegionInfo().getRegionName()));
        loc = table.getRegionLocation(ROW_C);
        Assert.assertNull((String)"Should be missing region for row ccc (past stop row)", results.get(loc.getRegionInfo().getRegionName()));
    }

    @Test
    public void testCompountCall() throws Throwable {
        HTable table = new HTable(util.getConfiguration(), TEST_TABLE);
        Map results = table.coprocessorExec(PingProtocol.class, ROW_A, ROW_C, (Batch.Call)new Batch.Call<PingProtocol, String>(){

            public String call(PingProtocol instance) {
                return instance.hello(instance.ping());
            }
        });
        this.verifyRegionResults(table, results, "Hello, pong", ROW_A);
        this.verifyRegionResults(table, results, "Hello, pong", ROW_B);
        this.verifyRegionResults(table, results, "Hello, pong", ROW_C);
    }

    @Test
    public void testNullCall() throws Throwable {
        HTable table = new HTable(util.getConfiguration(), TEST_TABLE);
        Map results = table.coprocessorExec(PingProtocol.class, ROW_A, ROW_C, (Batch.Call)new Batch.Call<PingProtocol, String>(){

            public String call(PingProtocol instance) {
                return instance.hello(null);
            }
        });
        this.verifyRegionResults(table, results, "Who are you?", ROW_A);
        this.verifyRegionResults(table, results, "Who are you?", ROW_B);
        this.verifyRegionResults(table, results, "Who are you?", ROW_C);
    }

    @Test
    public void testNullReturn() throws Throwable {
        HTable table = new HTable(util.getConfiguration(), TEST_TABLE);
        Map results = table.coprocessorExec(PingProtocol.class, ROW_A, ROW_C, (Batch.Call)new Batch.Call<PingProtocol, String>(){

            public String call(PingProtocol instance) {
                return instance.hello("nobody");
            }
        });
        this.verifyRegionResults(table, results, null, ROW_A);
        this.verifyRegionResults(table, results, null, ROW_B);
        this.verifyRegionResults(table, results, null, ROW_C);
    }

    @Test
    public void testVoidReturnType() throws Throwable {
        HTable table = new HTable(util.getConfiguration(), TEST_TABLE);
        Map results = table.coprocessorExec(PingProtocol.class, ROW_A, ROW_C, (Batch.Call)new Batch.Call<PingProtocol, Object>(){

            public Object call(PingProtocol instance) {
                instance.noop();
                return null;
            }
        });
        Assert.assertEquals((String)"Should have results from three regions", (long)3L, (long)results.size());
        for (Object v : results.values()) {
            Assert.assertNull(v);
        }
    }

    private void verifyRegionResults(HTable table, Map<byte[], String> results, byte[] row) throws Exception {
        this.verifyRegionResults(table, results, "pong", row);
    }

    private void verifyRegionResults(HTable table, Map<byte[], String> results, String expected, byte[] row) throws Exception {
        HRegionLocation loc = table.getRegionLocation(row);
        byte[] region = loc.getRegionInfo().getRegionName();
        Assert.assertTrue((String)("Results should contain region " + Bytes.toStringBinary((byte[])region) + " for row '" + Bytes.toStringBinary((byte[])row) + "'"), (boolean)results.containsKey(region));
        Assert.assertEquals((String)("Invalid result for row '" + Bytes.toStringBinary((byte[])row) + "'"), (Object)expected, (Object)results.get(region));
    }

    public static class PingHandler
    implements Coprocessor,
    PingProtocol,
    VersionedProtocol {
        static long VERSION = 1L;
        private int counter = 0;

        @Override
        public String ping() {
            ++this.counter;
            return "pong";
        }

        @Override
        public int getPingCount() {
            return this.counter;
        }

        @Override
        public int incrementCount(int diff) {
            this.counter += diff;
            return this.counter;
        }

        @Override
        public String hello(String name) {
            if (name == null) {
                return "Who are you?";
            }
            if ("nobody".equals(name)) {
                return null;
            }
            return "Hello, " + name;
        }

        @Override
        public void noop() {
        }

        public ProtocolSignature getProtocolSignature(String protocol, long version, int clientMethodsHashCode) throws IOException {
            return new ProtocolSignature(VERSION, null);
        }

        public long getProtocolVersion(String s, long l) throws IOException {
            return VERSION;
        }

        public void start(CoprocessorEnvironment env) throws IOException {
        }

        public void stop(CoprocessorEnvironment env) throws IOException {
        }
    }

    public static interface PingProtocol
    extends CoprocessorProtocol {
        public String ping();

        public int getPingCount();

        public int incrementCount(int var1);

        public String hello(String var1);

        public void noop();
    }
}

