/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.regionserver.SplitLogWorker;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSplitLogWorker {
    private static final Log LOG = LogFactory.getLog(TestSplitLogWorker.class);
    private static final HBaseTestingUtility TEST_UTIL;
    private ZooKeeperWatcher zkw;
    private SplitLogWorker slw;
    SplitLogWorker.TaskExecutor neverEndingTask = new SplitLogWorker.TaskExecutor(){

        public SplitLogWorker.TaskExecutor.Status exec(String name, CancelableProgressable p) {
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return SplitLogWorker.TaskExecutor.Status.PREEMPTED;
                }
            } while (p.progress());
            return SplitLogWorker.TaskExecutor.Status.PREEMPTED;
        }
    };
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    private void waitForCounter(AtomicLong ctr, long oldval, long newval, long timems) {
        Assert.assertTrue((String)("ctr=" + ctr.get() + ", oldval=" + oldval + ", newval=" + newval), (boolean)this.waitForCounterBoolean(ctr, oldval, newval, timems));
    }

    private boolean waitForCounterBoolean(AtomicLong ctr, long oldval, long newval, long timems) {
        long curt = System.currentTimeMillis();
        long endt = curt + timems;
        while (curt < endt) {
            if (ctr.get() == oldval) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                curt = System.currentTimeMillis();
                continue;
            }
            Assert.assertEquals((long)newval, (long)ctr.get());
            return true;
        }
        return false;
    }

    @Before
    public void setup() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        this.zkw = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "split-log-worker-tests", null);
        ZKUtil.deleteChildrenRecursively((ZooKeeperWatcher)this.zkw, (String)this.zkw.baseZNode);
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)this.zkw, (String)this.zkw.baseZNode);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)this.zkw.baseZNode) != -1 ? 1 : 0) != 0);
        LOG.debug((Object)(this.zkw.baseZNode + " created"));
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)this.zkw, (String)this.zkw.splitLogZNode);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)this.zkw.splitLogZNode) != -1 ? 1 : 0) != 0);
        LOG.debug((Object)(this.zkw.splitLogZNode + " created"));
        ZKSplitLog.Counters.resetCounters();
    }

    @After
    public void teardown() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAcquireTaskAtStartup() throws Exception {
        LOG.info((Object)"testAcquireTaskAtStartup");
        ZKSplitLog.Counters.resetCounters();
        this.zkw.getRecoverableZooKeeper().create(ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)"tatas"), ZKSplitLog.TaskState.TASK_UNASSIGNED.get("mgr"), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        SplitLogWorker slw = new SplitLogWorker(this.zkw, TEST_UTIL.getConfiguration(), "rs", this.neverEndingTask);
        slw.start();
        try {
            this.waitForCounter(ZKSplitLog.Counters.tot_wkr_task_acquired, 0L, 1L, 1500L);
            Assert.assertTrue((boolean)ZKSplitLog.TaskState.TASK_OWNED.equals(ZKUtil.getData((ZooKeeperWatcher)this.zkw, (String)ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)"tatas")), "rs"));
        }
        finally {
            this.stopSplitLogWorker(slw);
        }
    }

    private void stopSplitLogWorker(SplitLogWorker slw) throws InterruptedException {
        if (slw != null) {
            slw.stop();
            slw.worker.join(3000L);
            if (slw.worker.isAlive()) {
                Assert.assertTrue(("Could not stop the worker thread slw=" + slw == null ? 1 : 0) != 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRaceForTask() throws Exception {
        LOG.info((Object)"testRaceForTask");
        ZKSplitLog.Counters.resetCounters();
        this.zkw.getRecoverableZooKeeper().create(ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)"trft"), ZKSplitLog.TaskState.TASK_UNASSIGNED.get("manager"), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        SplitLogWorker slw1 = new SplitLogWorker(this.zkw, TEST_UTIL.getConfiguration(), "svr1", this.neverEndingTask);
        SplitLogWorker slw2 = new SplitLogWorker(this.zkw, TEST_UTIL.getConfiguration(), "svr2", this.neverEndingTask);
        slw1.start();
        slw2.start();
        try {
            this.waitForCounter(ZKSplitLog.Counters.tot_wkr_task_acquired, 0L, 1L, 1500L);
            Assert.assertTrue((this.waitForCounterBoolean(ZKSplitLog.Counters.tot_wkr_failed_to_grab_task_owned, 0L, 1L, 1500L) || ZKSplitLog.Counters.tot_wkr_failed_to_grab_task_lost_race.get() == 1L ? 1 : 0) != 0);
            Assert.assertTrue((ZKSplitLog.TaskState.TASK_OWNED.equals(ZKUtil.getData((ZooKeeperWatcher)this.zkw, (String)ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)"trft")), "svr1") || ZKSplitLog.TaskState.TASK_OWNED.equals(ZKUtil.getData((ZooKeeperWatcher)this.zkw, (String)ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)"trft")), "svr2") ? 1 : 0) != 0);
        }
        finally {
            this.stopSplitLogWorker(slw1);
            this.stopSplitLogWorker(slw2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreemptTask() throws Exception {
        LOG.info((Object)"testPreemptTask");
        ZKSplitLog.Counters.resetCounters();
        SplitLogWorker slw = new SplitLogWorker(this.zkw, TEST_UTIL.getConfiguration(), "tpt_svr", this.neverEndingTask);
        slw.start();
        try {
            Thread.yield();
            Thread.sleep(100L);
            this.zkw.getRecoverableZooKeeper().create(ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)"tpt_task"), ZKSplitLog.TaskState.TASK_UNASSIGNED.get("manager"), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.waitForCounter(ZKSplitLog.Counters.tot_wkr_task_acquired, 0L, 1L, 1500L);
            Assert.assertEquals((long)1L, (long)slw.taskReadySeq);
            Assert.assertTrue((boolean)ZKSplitLog.TaskState.TASK_OWNED.equals(ZKUtil.getData((ZooKeeperWatcher)this.zkw, (String)ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)"tpt_task")), "tpt_svr"));
            ZKUtil.setData((ZooKeeperWatcher)this.zkw, (String)ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)"tpt_task"), (byte[])ZKSplitLog.TaskState.TASK_UNASSIGNED.get("manager"));
            this.waitForCounter(ZKSplitLog.Counters.tot_wkr_preempt_task, 0L, 1L, 1500L);
        }
        finally {
            this.stopSplitLogWorker(slw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleTasks() throws Exception {
        LOG.info((Object)"testMultipleTasks");
        ZKSplitLog.Counters.resetCounters();
        SplitLogWorker slw = new SplitLogWorker(this.zkw, TEST_UTIL.getConfiguration(), "tmt_svr", this.neverEndingTask);
        slw.start();
        try {
            Thread.yield();
            Thread.sleep(100L);
            this.zkw.getRecoverableZooKeeper().create(ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)"tmt_task"), ZKSplitLog.TaskState.TASK_UNASSIGNED.get("manager"), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.waitForCounter(ZKSplitLog.Counters.tot_wkr_task_acquired, 0L, 1L, 1500L);
            this.zkw.getRecoverableZooKeeper().create(ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)"tmt_task_2"), ZKSplitLog.TaskState.TASK_UNASSIGNED.get("manager"), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            ZKUtil.setData((ZooKeeperWatcher)this.zkw, (String)ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)"tmt_task"), (byte[])ZKSplitLog.TaskState.TASK_OWNED.get("another-worker"));
            this.waitForCounter(ZKSplitLog.Counters.tot_wkr_preempt_task, 0L, 1L, 1500L);
            this.waitForCounter(ZKSplitLog.Counters.tot_wkr_task_acquired, 1L, 2L, 1500L);
            Assert.assertEquals((long)2L, (long)slw.taskReadySeq);
            Assert.assertTrue((boolean)ZKSplitLog.TaskState.TASK_OWNED.equals(ZKUtil.getData((ZooKeeperWatcher)this.zkw, (String)ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)"tmt_task_2")), "tmt_svr"));
        }
        finally {
            this.stopSplitLogWorker(slw);
        }
    }

    @Test
    public void testRescan() throws Exception {
        LOG.info((Object)"testRescan");
        ZKSplitLog.Counters.resetCounters();
        this.slw = new SplitLogWorker(this.zkw, TEST_UTIL.getConfiguration(), "svr", this.neverEndingTask);
        this.slw.start();
        Thread.yield();
        Thread.sleep(200L);
        String task = ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)"task");
        this.zkw.getRecoverableZooKeeper().create(task, ZKSplitLog.TaskState.TASK_UNASSIGNED.get("manager"), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.waitForCounter(ZKSplitLog.Counters.tot_wkr_task_acquired, 0L, 1L, 1500L);
        ZKUtil.setData((ZooKeeperWatcher)this.zkw, (String)task, (byte[])ZKSplitLog.TaskState.TASK_UNASSIGNED.get("manager"));
        this.waitForCounter(ZKSplitLog.Counters.tot_wkr_preempt_task, 0L, 1L, 1500L);
        String rescan = ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)"RESCAN");
        rescan = this.zkw.getRecoverableZooKeeper().create(rescan, ZKSplitLog.TaskState.TASK_UNASSIGNED.get("manager"), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
        this.waitForCounter(ZKSplitLog.Counters.tot_wkr_task_acquired, 1L, 2L, 1500L);
        ZKUtil.setData((ZooKeeperWatcher)this.zkw, (String)task, (byte[])ZKSplitLog.TaskState.TASK_UNASSIGNED.get("manager"));
        this.waitForCounter(ZKSplitLog.Counters.tot_wkr_preempt_task, 1L, 2L, 1500L);
        this.waitForCounter(ZKSplitLog.Counters.tot_wkr_task_acquired_rescan, 0L, 1L, 1500L);
        List nodes = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)this.zkw, (String)this.zkw.splitLogZNode);
        LOG.debug((Object)nodes);
        int num = 0;
        for (String node : nodes) {
            ++num;
            if (!node.startsWith("RESCAN")) continue;
            String name = ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)node);
            String fn = ZKSplitLog.getFileName((String)name);
            byte[] data = ZKUtil.getData((ZooKeeperWatcher)this.zkw, (String)ZKUtil.joinZNode((String)this.zkw.splitLogZNode, (String)fn));
            String datastr = Bytes.toString((byte[])data);
            Assert.assertTrue((String)("data=" + datastr), (boolean)ZKSplitLog.TaskState.TASK_DONE.equals(data, "svr"));
        }
        Assert.assertEquals((long)2L, (long)num);
    }

    static {
        Logger.getLogger((String)"org.apache.hadoop.hbase").setLevel(Level.DEBUG);
        TEST_UTIL = new HBaseTestingUtility();
    }
}

