/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.metrics;

import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaConfigured;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaMetrics;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONStringer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSchemaConfigured {
    private static final Log LOG = LogFactory.getLog(TestSchemaConfigured.class);
    private final String TABLE_NAME = "myTable";
    private final String CF_NAME = "myColumnFamily";
    private static final Path TMP_HFILE_PATH = new Path("/hbase/myTable/myRegion/.tmp/hfilename");
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testToString() throws JSONException {
        SchemaConfigured sc = new SchemaConfigured(null, "myTable", "myColumnFamily");
        JSONStringer json = new JSONStringer();
        json.object();
        json.key("tableName");
        json.value((Object)"myTable");
        json.key("cfName");
        json.value((Object)"myColumnFamily");
        json.endObject();
        Assert.assertEquals((Object)json.toString(), (Object)sc.schemaConfAsJSON());
    }

    @Test
    public void testDelayedInitialization() {
        SchemaConfigured unconfigured = new SchemaConfigured();
        try {
            unconfigured.getSchemaMetrics();
            Assert.fail((String)(IllegalStateException.class.getSimpleName() + " expected"));
        }
        catch (IllegalStateException ex) {
            Assert.assertTrue((String)("Unexpected exception message: " + ex.getMessage()), (boolean)Pattern.matches(".* metrics requested before .* initialization.*", ex.getMessage()));
            LOG.debug((Object)("Expected exception: " + ex.getMessage()));
        }
        SchemaMetrics.setUseTableNameInTest((boolean)false);
        SchemaConfigured other = new SchemaConfigured(null, "myTable", "myColumnFamily");
        other.passSchemaMetricsTo(unconfigured);
        unconfigured.getSchemaMetrics();
    }

    @Test
    public void testInitializingTwice() {
        Configuration conf = HBaseConfiguration.create();
        for (int i = 0; i < 4; ++i) {
            SchemaConfigured sc = new SchemaConfigured(conf, "myTable", "myColumnFamily");
            SchemaConfigured target = new SchemaConfigured(conf, "myTable" + (i % 2 == 1 ? "1" : ""), "myColumnFamily" + ((i & 2) != 0 ? "1" : ""));
            if (i == 0) {
                sc.passSchemaMetricsTo(target);
                continue;
            }
            String testDesc = "Trying to re-configure " + target.schemaConfAsJSON() + " with " + sc.schemaConfAsJSON();
            try {
                sc.passSchemaMetricsTo(target);
                Assert.fail((String)(IllegalArgumentException.class.getSimpleName() + " expected"));
                continue;
            }
            catch (IllegalArgumentException ex) {
                String errorMsg = testDesc + ". Unexpected exception message: " + ex.getMessage();
                String exceptionRegex = "Trying to change table .* CF .*";
                Assert.assertTrue((String)errorMsg, (boolean)Pattern.matches("Trying to change table .* CF .*", ex.getMessage()));
                LOG.debug((Object)("Expected exception: " + ex.getMessage()));
            }
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testConfigureWithUnconfigured1() {
        SchemaConfigured unconfigured = new SchemaConfigured(null, "t1", null);
        SchemaConfigured target = new SchemaConfigured();
        unconfigured.passSchemaMetricsTo(target);
    }

    @Test(expected=IllegalStateException.class)
    public void testConfigureWithUnconfigured2() {
        SchemaConfigured unconfigured = new SchemaConfigured(null, null, "cf1");
        SchemaConfigured target = new SchemaConfigured();
        unconfigured.passSchemaMetricsTo(target);
    }

    public void testConfigureWithNull() {
        SchemaConfigured unconfigured = new SchemaConfigured();
        SchemaConfigured target = new SchemaConfigured(null, "t1", "cf1");
        unconfigured.passSchemaMetricsTo(target);
        Assert.assertTrue((target.getTableName() == null ? 1 : 0) != 0);
        Assert.assertTrue((target.getColumnFamilyName() == null ? 1 : 0) != 0);
    }

    public void testConfigurePartiallyDefined() {
        SchemaConfigured sc = new SchemaConfigured(null, "t1", "cf1");
        SchemaConfigured target1 = new SchemaConfigured(null, "t2", null);
        sc.passSchemaMetricsTo(target1);
        Assert.assertEquals((Object)"t2", (Object)target1.getColumnFamilyName());
        Assert.assertEquals((Object)"cf1", (Object)target1.getColumnFamilyName());
        SchemaConfigured target2 = new SchemaConfigured(null, null, "cf2");
        sc.passSchemaMetricsTo(target2);
        Assert.assertEquals((Object)"t1", (Object)target2.getColumnFamilyName());
        Assert.assertEquals((Object)"cf2", (Object)target2.getColumnFamilyName());
        SchemaConfigured target3 = new SchemaConfigured(null, null, null);
        sc.passSchemaMetricsTo(target3);
        Assert.assertEquals((Object)"t1", (Object)target2.getColumnFamilyName());
        Assert.assertEquals((Object)"cf1", (Object)target2.getColumnFamilyName());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConflictingConf() {
        SchemaConfigured sc = new SchemaConfigured(null, "t1", "cf1");
        SchemaConfigured target = new SchemaConfigured(null, "t2", "cf1");
        sc.passSchemaMetricsTo(target);
    }

    public void testReconfigureUnknownCF() {
        SchemaConfigured sc = new SchemaConfigured(null, "t1", "cf1");
        SchemaConfigured target = new SchemaConfigured(null, "t1", "__unknown");
        sc.passSchemaMetricsTo(target);
    }

    @Test
    public void testTmpPath() {
        SchemaConfigured sc = new SchemaConfigured(null, "myTable", "myCF");
        SchemaConfigured target = new SchemaConfigured(TMP_HFILE_PATH);
        sc.passSchemaMetricsTo(target);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTmpPathButInvalidTable() {
        SchemaConfigured sc = new SchemaConfigured(null, "anotherTable", "myCF");
        SchemaConfigured target = new SchemaConfigured(TMP_HFILE_PATH);
        sc.passSchemaMetricsTo(target);
    }

    @Test
    public void testSchemaConfigurationHook() {
        SchemaConfigured sc = new SchemaConfigured(null, "myTable", "myCF");
        final StringBuilder newCF = new StringBuilder();
        final StringBuilder newTable = new StringBuilder();
        SchemaConfigured target = new SchemaConfigured(){

            protected void schemaConfigurationChanged() {
                newCF.append(this.getColumnFamilyName());
                newTable.append(this.getTableName());
            }
        };
        sc.passSchemaMetricsTo(target);
        Assert.assertEquals((Object)"myTable", (Object)newTable.toString());
        Assert.assertEquals((Object)"myCF", (Object)newCF.toString());
    }

    @Test
    public void testResetSchemaMetricsConf() {
        SchemaConfigured target = new SchemaConfigured(null, "t1", "cf1");
        SchemaConfigured.resetSchemaMetricsConf((SchemaConfigured)target);
        new SchemaConfigured(null, "t2", "cf2").passSchemaMetricsTo(target);
        Assert.assertEquals((Object)"t2", (Object)target.getTableName());
        Assert.assertEquals((Object)"cf2", (Object)target.getColumnFamilyName());
    }

    @Test
    public void testPathTooShort() {
        SchemaConfigured sc1 = new SchemaConfigured(new Path("/a/b/c/d"));
        Assert.assertEquals((Object)"__unknown", (Object)sc1.getTableName());
        Assert.assertEquals((Object)"__unknown", (Object)sc1.getColumnFamilyName());
        SchemaConfigured sc2 = new SchemaConfigured(new Path("a/b/c/d"));
        Assert.assertEquals((Object)"__unknown", (Object)sc2.getTableName());
        Assert.assertEquals((Object)"__unknown", (Object)sc2.getColumnFamilyName());
        SchemaConfigured sc3 = new SchemaConfigured(new Path("/hbase/tableName/regionId/cfName/hfileName"));
        Assert.assertEquals((Object)"tableName", (Object)sc3.getTableName());
        Assert.assertEquals((Object)"cfName", (Object)sc3.getColumnFamilyName());
        SchemaConfigured sc4 = new SchemaConfigured(new Path("hbase/tableName/regionId/cfName/hfileName"));
        Assert.assertEquals((Object)"tableName", (Object)sc4.getTableName());
        Assert.assertEquals((Object)"cfName", (Object)sc4.getColumnFamilyName());
    }
}

