/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.SortedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationSourceDummy;
import org.apache.hadoop.hbase.replication.ReplicationZookeeper;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReplicationSourceManager {
    private static final Log LOG = LogFactory.getLog(TestReplicationSourceManager.class);
    private static Configuration conf;
    private static HBaseTestingUtility utility;
    private static Replication replication;
    private static ReplicationSourceManager manager;
    private static ZooKeeperWatcher zkw;
    private static HTableDescriptor htd;
    private static HRegionInfo hri;
    private static final byte[] r1;
    private static final byte[] r2;
    private static final byte[] f1;
    private static final byte[] test;
    private static final String slaveId = "1";
    private static FileSystem fs;
    private static Path oldLogDir;
    private static Path logDir;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = HBaseConfiguration.create();
        conf.set("replication.replicationsource.implementation", ReplicationSourceDummy.class.getCanonicalName());
        conf.setBoolean("hbase.replication", true);
        utility = new HBaseTestingUtility(conf);
        utility.startMiniZKCluster();
        zkw = new ZooKeeperWatcher(conf, "test", null);
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/hbase/replication");
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/hbase/replication/peers/1");
        ZKUtil.setData((ZooKeeperWatcher)zkw, (String)"/hbase/replication/peers/1", (byte[])Bytes.toBytes((String)(conf.get("hbase.zookeeper.quorum") + ":" + conf.get("hbase.zookeeper.property.clientPort") + ":/1")));
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/hbase/replication/peers/1/peer-state");
        ZKUtil.setData((ZooKeeperWatcher)zkw, (String)"/hbase/replication/peers/1/peer-state", (byte[])Bytes.toBytes((String)ReplicationZookeeper.PeerState.ENABLED.name()));
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/hbase/replication/state");
        ZKUtil.setData((ZooKeeperWatcher)zkw, (String)"/hbase/replication/state", (byte[])Bytes.toBytes((String)"true"));
        replication = new Replication((Server)new DummyServer(), fs, logDir, oldLogDir);
        manager = replication.getReplicationManager();
        fs = FileSystem.get((Configuration)conf);
        oldLogDir = new Path(utility.getDataTestDir(), ".oldlogs");
        logDir = new Path(utility.getDataTestDir(), ".logs");
        manager.addSource(slaveId);
        htd = new HTableDescriptor(test);
        HColumnDescriptor col = new HColumnDescriptor("f1");
        col.setScope(1);
        htd.addFamily(col);
        col = new HColumnDescriptor("f2");
        col.setScope(0);
        htd.addFamily(col);
        hri = new HRegionInfo(htd.getName(), r1, r2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        manager.join();
        utility.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        fs.delete(logDir, true);
        fs.delete(oldLogDir, true);
    }

    @After
    public void tearDown() throws Exception {
        this.setUp();
    }

    @Test
    public void testLogRoll() throws Exception {
        long baseline;
        long seq = 0L;
        long time = baseline = 1000L;
        KeyValue kv = new KeyValue(r1, f1, r1);
        WALEdit edit = new WALEdit();
        edit.add(kv);
        ArrayList<Replication> listeners = new ArrayList<Replication>();
        listeners.add(replication);
        HLog hlog = new HLog(fs, logDir, oldLogDir, conf, listeners, URLEncoder.encode("regionserver:60020", "UTF8"));
        manager.init();
        HTableDescriptor htd = new HTableDescriptor();
        htd.addFamily(new HColumnDescriptor(f1));
        for (long i = 1L; i < 101L; ++i) {
            if (i > 1L && i % 20L == 0L) {
                hlog.rollWriter();
            }
            LOG.info((Object)i);
            HLogKey key = new HLogKey(hri.getRegionName(), test, seq++, System.currentTimeMillis(), HConstants.DEFAULT_CLUSTER_ID);
            hlog.append(hri, key, edit, htd, true);
        }
        LOG.info((Object)(baseline + " and " + time));
        time = baseline += 101L;
        LOG.info((Object)(baseline + " and " + time));
        for (int i = 0; i < 3; ++i) {
            HLogKey key = new HLogKey(hri.getRegionName(), test, seq++, System.currentTimeMillis(), HConstants.DEFAULT_CLUSTER_ID);
            hlog.append(hri, key, edit, htd, true);
        }
        Assert.assertEquals((long)6L, (long)((SortedSet)manager.getHLogs().get(slaveId)).size());
        hlog.rollWriter();
        manager.logPositionAndCleanOldLogs(((ReplicationSourceInterface)manager.getSources().get(0)).getCurrentPath(), slaveId, 0L, false, false);
        HLogKey key = new HLogKey(hri.getRegionName(), test, seq++, System.currentTimeMillis(), HConstants.DEFAULT_CLUSTER_ID);
        hlog.append(hri, key, edit, htd, true);
        Assert.assertEquals((long)1L, (long)manager.getHLogs().size());
    }

    static {
        r1 = Bytes.toBytes((String)"r1");
        r2 = Bytes.toBytes((String)"r2");
        f1 = Bytes.toBytes((String)"f1");
        test = Bytes.toBytes((String)"test");
    }

    static class DummyServer
    implements Server {
        DummyServer() {
        }

        public Configuration getConfiguration() {
            return conf;
        }

        public ZooKeeperWatcher getZooKeeper() {
            return zkw;
        }

        public CatalogTracker getCatalogTracker() {
            return null;
        }

        public ServerName getServerName() {
            return new ServerName("hostname.example.org", 1234, -1L);
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public void stop(String why) {
        }

        public boolean isStopped() {
            return false;
        }
    }
}

