/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.rest.model.ColumnSchemaModel;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestColumnSchemaModel
extends TestCase {
    protected static final String COLUMN_NAME = "testcolumn";
    protected static final boolean BLOCKCACHE = true;
    protected static final int BLOCKSIZE = 16384;
    protected static final String BLOOMFILTER = "NONE";
    protected static final String COMPRESSION = "GZ";
    protected static final boolean IN_MEMORY = false;
    protected static final int TTL = 86400;
    protected static final int VERSIONS = 1;
    protected static final String AS_XML = "<ColumnSchema name=\"testcolumn\" BLOCKSIZE=\"16384\" BLOOMFILTER=\"NONE\" BLOCKCACHE=\"true\" COMPRESSION=\"GZ\" VERSIONS=\"1\" TTL=\"86400\" IN_MEMORY=\"false\"/>";
    private JAXBContext context;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    public TestColumnSchemaModel() throws JAXBException {
        this.context = JAXBContext.newInstance((Class[])new Class[]{ColumnSchemaModel.class});
    }

    protected static ColumnSchemaModel buildTestModel() {
        ColumnSchemaModel model = new ColumnSchemaModel();
        model.setName(COLUMN_NAME);
        model.__setBlockcache(true);
        model.__setBlocksize(16384);
        model.__setBloomfilter(BLOOMFILTER);
        model.__setCompression(COMPRESSION);
        model.__setInMemory(false);
        model.__setTTL(86400);
        model.__setVersions(1);
        return model;
    }

    private String toXML(ColumnSchemaModel model) throws JAXBException {
        StringWriter writer = new StringWriter();
        this.context.createMarshaller().marshal((Object)model, (Writer)writer);
        return writer.toString();
    }

    private ColumnSchemaModel fromXML(String xml) throws JAXBException {
        return (ColumnSchemaModel)this.context.createUnmarshaller().unmarshal((Reader)new StringReader(xml));
    }

    protected static void checkModel(ColumnSchemaModel model) {
        TestColumnSchemaModel.assertEquals((String)model.getName(), (String)COLUMN_NAME);
        TestColumnSchemaModel.assertEquals((boolean)model.__getBlockcache(), (boolean)true);
        TestColumnSchemaModel.assertEquals((int)model.__getBlocksize(), (int)16384);
        TestColumnSchemaModel.assertEquals((String)model.__getBloomfilter(), (String)BLOOMFILTER);
        TestColumnSchemaModel.assertTrue((boolean)model.__getCompression().equalsIgnoreCase(COMPRESSION));
        TestColumnSchemaModel.assertEquals((boolean)model.__getInMemory(), (boolean)false);
        TestColumnSchemaModel.assertEquals((int)model.__getTTL(), (int)86400);
        TestColumnSchemaModel.assertEquals((int)model.__getVersions(), (int)1);
    }

    public void testBuildModel() throws Exception {
        TestColumnSchemaModel.checkModel(TestColumnSchemaModel.buildTestModel());
    }

    public void testFromXML() throws Exception {
        TestColumnSchemaModel.checkModel(this.fromXML(AS_XML));
    }
}

