/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.HSnapshotDescription;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.TakeSnapshotUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.Assert;

public class SnapshotTestingUtils {
    private static final Log LOG = LogFactory.getLog(SnapshotTestingUtils.class);

    public static void assertNoSnapshots(HBaseAdmin admin) throws IOException {
        Assert.assertEquals((String)"Have some previous snapshots", (long)0L, (long)admin.listSnapshots().size());
    }

    public static void assertOneSnapshotThatMatches(HBaseAdmin admin, HSnapshotDescription snapshot) throws IOException {
        SnapshotTestingUtils.assertOneSnapshotThatMatches(admin, snapshot.getName(), snapshot.getTable());
    }

    public static void assertOneSnapshotThatMatches(HBaseAdmin admin, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        SnapshotTestingUtils.assertOneSnapshotThatMatches(admin, snapshot.getName(), snapshot.getTable());
    }

    public static List<HBaseProtos.SnapshotDescription> assertOneSnapshotThatMatches(HBaseAdmin admin, String snapshotName, String tableName) throws IOException {
        List snapshots = admin.listSnapshots();
        Assert.assertEquals((String)"Should only have 1 snapshot", (long)1L, (long)snapshots.size());
        Assert.assertEquals((Object)snapshotName, (Object)((HBaseProtos.SnapshotDescription)snapshots.get(0)).getName());
        Assert.assertEquals((Object)tableName, (Object)((HBaseProtos.SnapshotDescription)snapshots.get(0)).getTable());
        return snapshots;
    }

    public static List<HBaseProtos.SnapshotDescription> assertOneSnapshotThatMatches(HBaseAdmin admin, byte[] snapshot, byte[] tableName) throws IOException {
        return SnapshotTestingUtils.assertOneSnapshotThatMatches(admin, Bytes.toString((byte[])snapshot), Bytes.toString((byte[])tableName));
    }

    public static void confirmSnapshotValid(HBaseProtos.SnapshotDescription snapshotDescriptor, byte[] tableName, byte[] testFamily, Path rootDir, HBaseAdmin admin, FileSystem fs, boolean requireLogs, Path logsDir, Set<String> snapshotServers) throws IOException {
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((HBaseProtos.SnapshotDescription)snapshotDescriptor, (Path)rootDir);
        Assert.assertTrue((boolean)fs.exists(snapshotDir));
        Path snapshotinfo = new Path(snapshotDir, ".snapshotinfo");
        Assert.assertTrue((boolean)fs.exists(snapshotinfo));
        if (requireLogs) {
            TakeSnapshotUtils.verifyAllLogsGotReferenced((FileSystem)fs, (Path)logsDir, snapshotServers, (HBaseProtos.SnapshotDescription)snapshotDescriptor, (Path)new Path(snapshotDir, ".logs"));
        }
        HTableDescriptor desc = FSTableDescriptors.getTableDescriptor((FileSystem)fs, (Path)rootDir, (byte[])tableName);
        HTableDescriptor snapshotDesc = FSTableDescriptors.getTableDescriptor((FileSystem)fs, (Path)snapshotDir);
        Assert.assertEquals((Object)desc, (Object)snapshotDesc);
        List regions = admin.getTableRegions(tableName);
        for (HRegionInfo info : regions) {
            String regionName = info.getEncodedName();
            Path regionDir = new Path(snapshotDir, regionName);
            HRegionInfo snapshotRegionInfo = HRegion.loadDotRegionInfoFileContent((FileSystem)fs, (Path)regionDir);
            Assert.assertEquals((Object)info, (Object)snapshotRegionInfo);
            Path familyDir = new Path(regionDir, Bytes.toString((byte[])testFamily));
            Assert.assertTrue((String)("Expected to find: " + familyDir + ", but it doesn't exist"), (boolean)fs.exists(familyDir));
            Assert.assertTrue((fs.listStatus(familyDir).length > 0 ? 1 : 0) != 0);
        }
    }

    public static void waitForSnapshotToComplete(HMaster master, HSnapshotDescription snapshot, long sleep) throws IOException {
        boolean done = false;
        while (!done) {
            done = master.isSnapshotDone(snapshot);
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }

    public static void cleanupSnapshot(HBaseAdmin admin, byte[] tableName) throws IOException {
        SnapshotTestingUtils.cleanupSnapshot(admin, Bytes.toString((byte[])tableName));
    }

    public static void cleanupSnapshot(HBaseAdmin admin, String snapshotName) throws IOException {
        admin.deleteSnapshot(snapshotName);
        SnapshotTestingUtils.assertNoSnapshots(admin);
    }

    public static void expectSnapshotDoneException(HMaster master, HSnapshotDescription snapshot, Class<? extends HBaseSnapshotException> clazz) {
        try {
            boolean res = master.isSnapshotDone(snapshot);
            Assert.fail((String)("didn't fail to lookup a snapshot: res=" + res));
        }
        catch (HBaseSnapshotException e) {
            Assert.assertEquals((String)"Threw wrong snapshot exception!", clazz, ((Object)((Object)e)).getClass());
        }
        catch (Throwable t) {
            Assert.fail((String)("Threw an unexpected exception:" + t));
        }
    }

    public static FileStatus[] listHFiles(final FileSystem fs, Path tableDir) throws IOException {
        FSUtils.RegionDirFilter regionFilter = new FSUtils.RegionDirFilter(fs);
        FSUtils.FamilyDirFilter familyFilter = new FSUtils.FamilyDirFilter(fs);
        PathFilter fileFilter = new PathFilter(){

            public boolean accept(Path file) {
                try {
                    return fs.isFile(file);
                }
                catch (IOException e) {
                    return false;
                }
            }
        };
        FileStatus[] regionDirs = FSUtils.listStatus((FileSystem)fs, (Path)tableDir, (PathFilter)regionFilter);
        if (regionDirs == null || regionDirs.length == 0) {
            return new FileStatus[0];
        }
        ArrayList<FileStatus> regionFiles = new ArrayList<FileStatus>(regionDirs.length);
        for (FileStatus regionDir : regionDirs) {
            FileStatus[] fams = FSUtils.listStatus((FileSystem)fs, (Path)regionDir.getPath(), (PathFilter)familyFilter);
            if (fams == null || fams.length == 0) continue;
            regionFiles.addAll(SnapshotTestingUtils.getHFilesInRegion(fams, fs, fileFilter));
        }
        FileStatus[] files = new FileStatus[regionFiles.size()];
        regionFiles.toArray(files);
        return files;
    }

    public static Collection<FileStatus> getHFilesInRegion(FileStatus[] families, FileSystem fs, PathFilter fileFilter) throws IOException {
        TreeSet<FileStatus> files = new TreeSet<FileStatus>();
        for (FileStatus family : families) {
            FileStatus[] hfiles = FSUtils.listStatus((FileSystem)fs, (Path)family.getPath(), (PathFilter)fileFilter);
            if (hfiles == null || hfiles.length == 0) continue;
            files.addAll(Arrays.asList(hfiles));
        }
        return files;
    }
}

