/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDoesNotExistException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestRestoreFlushSnapshotFromClient {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private byte[] snapshotName0;
    private byte[] snapshotName1;
    private byte[] snapshotName2;
    private int snapshot0Rows;
    private int snapshot1Rows;
    private byte[] tableName;
    private HBaseAdmin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.getConfiguration().setBoolean("hbase.snapshot.enabled", true);
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setup() throws Exception {
        this.admin = TEST_UTIL.getHBaseAdmin();
        long tid = System.currentTimeMillis();
        this.tableName = Bytes.toBytes((String)("testtb-" + tid));
        this.snapshotName0 = Bytes.toBytes((String)("snaptb0-" + tid));
        this.snapshotName1 = Bytes.toBytes((String)("snaptb1-" + tid));
        this.snapshotName2 = Bytes.toBytes((String)("snaptb2-" + tid));
        this.createTable(this.tableName, new byte[][]{this.FAMILY});
        HTable table = new HTable(TEST_UTIL.getConfiguration(), this.tableName);
        try {
            this.loadData(table, 500, new byte[][]{this.FAMILY});
            this.snapshot0Rows = TEST_UTIL.countRows(table);
            this.LOG.info((Object)"=== before snapshot with 500 rows");
            this.logFSTree();
            this.admin.snapshot(Bytes.toString((byte[])this.snapshotName0), Bytes.toString((byte[])this.tableName), HBaseProtos.SnapshotDescription.Type.FLUSH);
            this.LOG.info((Object)"=== after snapshot with 500 rows");
            this.logFSTree();
            this.loadData(table, 500, new byte[][]{this.FAMILY});
            this.snapshot1Rows = TEST_UTIL.countRows(table);
            this.LOG.info((Object)"=== before snapshot with 1000 rows");
            this.logFSTree();
            this.admin.snapshot(Bytes.toString((byte[])this.snapshotName1), Bytes.toString((byte[])this.tableName), HBaseProtos.SnapshotDescription.Type.FLUSH);
            this.LOG.info((Object)"=== after snapshot with 1000 rows");
            this.logFSTree();
        }
        finally {
            table.close();
        }
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.deleteTable(this.tableName);
        this.admin.deleteSnapshot(this.snapshotName0);
        this.admin.deleteSnapshot(this.snapshotName1);
        MasterFileSystem mfs = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        mfs.getFileSystem().delete(new Path(mfs.getRootDir(), ".archive"), true);
    }

    @Test
    public void testTakeFlushSnapshot() throws IOException {
    }

    @Test
    public void testRestoreSnapshot() throws IOException {
        this.verifyRowCount(this.tableName, this.snapshot1Rows);
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName0);
        this.logFSTree();
        this.admin.enableTable(this.tableName);
        this.LOG.info((Object)"=== after restore with 500 row snapshot");
        this.logFSTree();
        this.verifyRowCount(this.tableName, this.snapshot0Rows);
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName1);
        this.admin.enableTable(this.tableName);
        this.verifyRowCount(this.tableName, this.snapshot1Rows);
    }

    @Test(expected=SnapshotDoesNotExistException.class)
    public void testCloneNonExistentSnapshot() throws IOException, InterruptedException {
        String snapshotName = "random-snapshot-" + System.currentTimeMillis();
        String tableName = "random-table-" + System.currentTimeMillis();
        this.admin.cloneSnapshot(snapshotName, tableName);
    }

    @Test
    public void testCloneSnapshot() throws IOException, InterruptedException {
        byte[] clonedTableName = Bytes.toBytes((String)("clonedtb-" + System.currentTimeMillis()));
        this.testCloneSnapshot(clonedTableName, this.snapshotName0, this.snapshot0Rows);
        this.testCloneSnapshot(clonedTableName, this.snapshotName1, this.snapshot1Rows);
    }

    private void testCloneSnapshot(byte[] tableName, byte[] snapshotName, int snapshotRows) throws IOException, InterruptedException {
        this.admin.cloneSnapshot(snapshotName, tableName);
        this.verifyRowCount(tableName, snapshotRows);
        TEST_UTIL.deleteTable(tableName);
    }

    @Test
    public void testRestoreSnapshotOfCloned() throws IOException, InterruptedException {
        byte[] clonedTableName = Bytes.toBytes((String)("clonedtb-" + System.currentTimeMillis()));
        this.admin.cloneSnapshot(this.snapshotName0, clonedTableName);
        this.verifyRowCount(clonedTableName, this.snapshot0Rows);
        this.admin.snapshot(Bytes.toString((byte[])this.snapshotName2), Bytes.toString((byte[])clonedTableName), HBaseProtos.SnapshotDescription.Type.FLUSH);
        TEST_UTIL.deleteTable(clonedTableName);
        this.admin.cloneSnapshot(this.snapshotName2, clonedTableName);
        this.verifyRowCount(clonedTableName, this.snapshot0Rows);
        TEST_UTIL.deleteTable(clonedTableName);
    }

    private void createTable(byte[] tableName, byte[] ... families) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            htd.addFamily(hcd);
        }
        byte[][] splitKeys = new byte[16][];
        byte[] hex = Bytes.toBytes((String)"0123456789abcdef");
        for (int i = 0; i < 16; ++i) {
            splitKeys[i] = new byte[]{hex[i]};
        }
        this.admin.createTable(htd, (byte[][])splitKeys);
    }

    public void loadData(HTable table, int rows, byte[] ... families) throws IOException {
        byte[] qualifier = Bytes.toBytes((String)"q");
        table.setAutoFlush(false);
        while (rows-- > 0) {
            byte[] value = Bytes.add((byte[])Bytes.toBytes((long)System.currentTimeMillis()), (byte[])Bytes.toBytes((int)rows));
            byte[] key = Bytes.toBytes((String)MD5Hash.getMD5AsHex((byte[])value));
            Put put = new Put(key);
            put.setWriteToWAL(false);
            for (byte[] family : families) {
                put.add(family, qualifier, value);
            }
            table.put(put);
        }
        table.flushCommits();
    }

    private void logFSTree() throws IOException {
        MasterFileSystem mfs = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        FSUtils.logFileSystemState((FileSystem)mfs.getFileSystem(), (Path)mfs.getRootDir(), (Log)this.LOG);
    }

    private void verifyRowCount(byte[] tableName, long expectedRows) throws IOException {
        HTable table = new HTable(TEST_UTIL.getConfiguration(), tableName);
        Assert.assertEquals((long)expectedRows, (long)TEST_UTIL.countRows(table));
        table.close();
    }
}

