/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.test;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.IntegrationTests;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VLongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestBigLinkedList
extends Configured
implements Tool {
    private static final String TABLE_NAME_KEY = "IntegrationTestBigLinkedList.table";
    private static final String DEFAULT_TABLE_NAME = "ci";
    private static byte[] FAMILY_NAME = Bytes.toBytes((String)"meta");
    private static final byte[] COLUMN_PREV = Bytes.toBytes((String)"prev");
    private static final byte[] COLUMN_CLIENT = Bytes.toBytes((String)"client");
    private static final byte[] COLUMN_COUNT = Bytes.toBytes((String)"count");
    private static final String GENERATOR_NUM_ROWS_PER_MAP_KEY = "IntegrationTestBigLinkedList.generator.num_rows";
    private static final String GENERATOR_NUM_MAPPERS_KEY = "IntegrationTestBigLinkedList.generator.map.tasks";
    private IntegrationTestingUtility util;

    private static byte[] getTableName(Configuration conf) {
        return Bytes.toBytes((String)conf.get(TABLE_NAME_KEY, DEFAULT_TABLE_NAME));
    }

    private static CINode getCINode(Result result, CINode node) {
        node.key = Bytes.toLong((byte[])result.getRow());
        if (result.containsColumn(FAMILY_NAME, COLUMN_PREV)) {
            node.prev = Bytes.toLong((byte[])result.getValue(FAMILY_NAME, COLUMN_PREV));
        }
        if (result.containsColumn(FAMILY_NAME, COLUMN_COUNT)) {
            node.count = Bytes.toLong((byte[])result.getValue(FAMILY_NAME, COLUMN_COUNT));
        }
        if (result.containsColumn(FAMILY_NAME, COLUMN_CLIENT)) {
            node.client = Bytes.toString((byte[])result.getValue(FAMILY_NAME, COLUMN_CLIENT));
        }
        return node;
    }

    @Before
    public void setUp() throws Exception {
        this.util = this.getTestingUtil();
        this.util.initializeCluster(3);
        this.setConf(this.util.getConfiguration());
    }

    @After
    public void tearDown() throws Exception {
        this.util.restoreCluster();
    }

    @Test
    public void testContinuousIngest() throws IOException, Exception {
        int ret = ToolRunner.run((Configuration)this.getTestingUtil().getConfiguration(), (Tool)new Loop(), (String[])new String[]{"1", "1", "2000000", this.getTestDir("IntegrationTestBigLinkedList", "testContinuousIngest").toString(), "1"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    public Path getTestDir(String testName, String subdir) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        Path base = new Path(fs.getWorkingDirectory(), "test-data");
        String randomStr = UUID.randomUUID().toString();
        Path testDir = new Path(base, randomStr);
        fs.deleteOnExit(testDir);
        return new Path(new Path(testDir, testName), subdir);
    }

    private IntegrationTestingUtility getTestingUtil() {
        if (this.util == null) {
            this.util = this.getConf() == null ? new IntegrationTestingUtility() : new IntegrationTestingUtility(this.getConf());
        }
        return this.util;
    }

    private int printUsage() {
        System.err.println("Usage: " + ((Object)((Object)this)).getClass().getSimpleName() + " COMMAND [COMMAND options]");
        System.err.println("  where COMMAND is one of:");
        System.err.println("");
        System.err.println("  Generator                  A map only job that generates data.");
        System.err.println("  Verify                     A map reduce job that looks for holes");
        System.err.println("                             Look at the counts after running");
        System.err.println("                             REFERENCED and UNREFERENCED are ok");
        System.err.println("                             any UNDEFINED counts are bad. Do not");
        System.err.println("                             run at the same time as the Generator.");
        System.err.println("  Walker                     A standalong program that starts ");
        System.err.println("                             following a linked list and emits");
        System.err.println("                             timing info.");
        System.err.println("  Print                      A standalone program that prints nodes");
        System.err.println("                             in the linked list.");
        System.err.println("  Delete                     A standalone program that deletes a\u00b7");
        System.err.println("                             single node.");
        System.err.println("  Loop                       A program to Loop through Generator and");
        System.err.println("                             Verify steps");
        System.err.println("\t  ");
        return 1;
    }

    public int run(String[] args) throws Exception {
        if (args.length < 1) {
            return this.printUsage();
        }
        Configured tool = null;
        if (args[0].equals("Generator")) {
            tool = new Generator();
        } else if (args[0].equals("Verify")) {
            tool = new Verify();
        } else if (args[0].equals("Loop")) {
            tool = new Loop();
        } else if (args[0].equals("Walker")) {
            tool = new Walker();
        } else if (args[0].equals("Print")) {
            tool = new Print();
        } else if (args[0].equals("Delete")) {
            tool = new Delete();
        } else {
            return this.printUsage();
        }
        args = Arrays.copyOfRange(args, 1, args.length);
        return ToolRunner.run((Configuration)this.getConf(), (Tool)tool, (String[])args);
    }

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Tool)new IntegrationTestBigLinkedList(), (String[])args);
        System.exit(ret);
    }

    private static class Walker
    extends Configured
    implements Tool {
        private Walker() {
        }

        public int run(String[] args) throws IOException {
            Options options = new Options();
            options.addOption("n", "num", true, "number of queries");
            GnuParser parser = new GnuParser();
            CommandLine cmd = null;
            try {
                cmd = parser.parse(options, args);
                if (cmd.getArgs().length != 0) {
                    throw new ParseException("Command takes no arguments");
                }
            }
            catch (ParseException e) {
                System.err.println("Failed to parse command line " + e.getMessage());
                System.err.println();
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(((Object)((Object)this)).getClass().getSimpleName(), options);
                System.exit(-1);
            }
            long maxQueries = Long.MAX_VALUE;
            if (cmd.hasOption('n')) {
                maxQueries = Long.parseLong(cmd.getOptionValue("n"));
            }
            HTable table = new HTable(this.getConf(), IntegrationTestBigLinkedList.getTableName(this.getConf()));
            Random rand = new Random();
            long numQueries = 0L;
            while (numQueries < maxQueries) {
                CINode node = Walker.findStartNode(rand, table);
                ++numQueries;
                while (node != null && node.prev >= 0L && numQueries < maxQueries) {
                    long prev = node.prev;
                    long t1 = System.currentTimeMillis();
                    node = this.getNode(prev, table, node);
                    long t2 = System.currentTimeMillis();
                    System.out.printf("CQ %d %016x \n", t2 - t1, prev);
                    ++numQueries;
                    t1 = System.currentTimeMillis();
                    node = this.getNode(prev, table, node);
                    t2 = System.currentTimeMillis();
                    System.out.printf("HQ %d %016x \n", t2 - t1, prev);
                    ++numQueries;
                }
            }
            table.close();
            return 0;
        }

        private static CINode findStartNode(Random rand, HTable table) throws IOException {
            Scan scan = new Scan();
            scan.setStartRow(Bytes.toBytes((long)Math.abs(rand.nextLong())));
            scan.setBatch(1);
            scan.addColumn(FAMILY_NAME, COLUMN_PREV);
            long t1 = System.currentTimeMillis();
            ResultScanner scanner = table.getScanner(scan);
            Result result = scanner.next();
            long t2 = System.currentTimeMillis();
            scanner.close();
            if (result != null) {
                CINode node = IntegrationTestBigLinkedList.getCINode(result, new CINode());
                System.out.printf("FSR %d %016x\n", t2 - t1, node.key);
                return node;
            }
            System.out.println("FSR " + (t2 - t1));
            return null;
        }

        private CINode getNode(long row, HTable table, CINode node) throws IOException {
            Get get = new Get(Bytes.toBytes((long)row));
            get.addColumn(FAMILY_NAME, COLUMN_PREV);
            Result result = table.get(get);
            return IntegrationTestBigLinkedList.getCINode(result, node);
        }
    }

    private static class Delete
    extends Configured
    implements Tool {
        private Delete() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 1) {
                System.out.println("Usage : " + Delete.class.getSimpleName() + " <node to delete>");
                return 0;
            }
            long val = new BigInteger(args[0], 16).longValue();
            org.apache.hadoop.hbase.client.Delete delete = new org.apache.hadoop.hbase.client.Delete(Bytes.toBytes((long)val));
            HTable table = new HTable(this.getConf(), IntegrationTestBigLinkedList.getTableName(this.getConf()));
            table.delete(delete);
            table.flushCommits();
            table.close();
            System.out.println("Delete successful");
            return 0;
        }
    }

    private static class Print
    extends Configured
    implements Tool {
        private Print() {
        }

        public int run(String[] args) throws Exception {
            Options options = new Options();
            options.addOption("s", "start", true, "start key");
            options.addOption("e", "end", true, "end key");
            options.addOption("l", "limit", true, "number to print");
            GnuParser parser = new GnuParser();
            CommandLine cmd = null;
            try {
                cmd = parser.parse(options, args);
                if (cmd.getArgs().length != 0) {
                    throw new ParseException("Command takes no arguments");
                }
            }
            catch (ParseException e) {
                System.err.println("Failed to parse command line " + e.getMessage());
                System.err.println();
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(((Object)((Object)this)).getClass().getSimpleName(), options);
                System.exit(-1);
            }
            HTable table = new HTable(this.getConf(), IntegrationTestBigLinkedList.getTableName(this.getConf()));
            Scan scan = new Scan();
            scan.setBatch(10000);
            if (cmd.hasOption("s")) {
                scan.setStartRow(Bytes.toBytes((long)new BigInteger(cmd.getOptionValue("s"), 16).longValue()));
            }
            if (cmd.hasOption("e")) {
                scan.setStopRow(Bytes.toBytes((long)new BigInteger(cmd.getOptionValue("e"), 16).longValue()));
            }
            int limit = 0;
            limit = cmd.hasOption("l") ? Integer.parseInt(cmd.getOptionValue("l")) : 100;
            ResultScanner scanner = table.getScanner(scan);
            CINode node = new CINode();
            Result result = scanner.next();
            int count = 0;
            while (result != null && count++ < limit) {
                node = IntegrationTestBigLinkedList.getCINode(result, node);
                System.out.printf("%016x:%016x:%012d:%s\n", node.key, node.prev, node.count, node.client);
                result = scanner.next();
            }
            scanner.close();
            table.close();
            return 0;
        }
    }

    private static class Loop
    extends Configured
    implements Tool {
        private static final Log LOG = LogFactory.getLog(Loop.class);

        private Loop() {
        }

        protected void runGenerator(int numMappers, long numNodes, String outputDir) throws Exception {
            Path outputPath = new Path(outputDir);
            UUID uuid = UUID.randomUUID();
            Path generatorOutput = new Path(outputPath, uuid.toString());
            Generator generator = new Generator();
            generator.setConf(this.getConf());
            int retCode = generator.run(numMappers, numNodes, generatorOutput);
            if (retCode > 0) {
                throw new RuntimeException("Generator failed with return code: " + retCode);
            }
        }

        protected void runVerify(String outputDir, int numReducers, long expectedNumNodes) throws Exception {
            Path outputPath = new Path(outputDir);
            UUID uuid = UUID.randomUUID();
            Path iterationOutput = new Path(outputPath, uuid.toString());
            Verify verify = new Verify();
            verify.setConf(this.getConf());
            int retCode = verify.run(iterationOutput, numReducers);
            if (retCode > 0) {
                throw new RuntimeException("Verify.run failed with return code: " + retCode);
            }
            boolean verifySuccess = verify.verify(expectedNumNodes);
            if (!verifySuccess) {
                throw new RuntimeException("Verify.verify failed");
            }
            LOG.info((Object)("Verify finished with succees. Total nodes=" + expectedNumNodes));
        }

        public int run(String[] args) throws Exception {
            if (args.length < 5) {
                System.err.println("Usage: Loop <num iterations> <num mappers> <num nodes per mapper> <output dir> <num reducers>");
                return 1;
            }
            LOG.info((Object)("Running Loop with args:" + Arrays.deepToString(args)));
            int numIterations = Integer.parseInt(args[0]);
            int numMappers = Integer.parseInt(args[1]);
            long numNodes = Long.parseLong(args[2]);
            String outputDir = args[3];
            int numReducers = Integer.parseInt(args[4]);
            long expectedNumNodes = 0L;
            if (numIterations < 0) {
                numIterations = Integer.MAX_VALUE;
            }
            for (int i = 0; i < numIterations; ++i) {
                LOG.info((Object)("Starting iteration = " + i));
                this.runGenerator(numMappers, numNodes, outputDir);
                this.runVerify(outputDir, numReducers, expectedNumNodes += (long)numMappers * numNodes);
            }
            return 0;
        }
    }

    static class Verify
    extends Configured
    implements Tool {
        private static final Log LOG = LogFactory.getLog(Verify.class);
        private static final VLongWritable DEF = new VLongWritable(-1L);
        private Job job;

        Verify() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 2) {
                System.out.println("Usage : " + Verify.class.getSimpleName() + " <output dir> <num reducers>");
                return 0;
            }
            String outputDir = args[0];
            int numReducers = Integer.parseInt(args[1]);
            return this.run(outputDir, numReducers);
        }

        public int run(String outputDir, int numReducers) throws Exception {
            return this.run(new Path(outputDir), numReducers);
        }

        public int run(Path outputDir, int numReducers) throws Exception {
            LOG.info((Object)("Running Verify with outputDir=" + outputDir + ", numReducers=" + numReducers));
            this.job = new Job(this.getConf());
            this.job.setJobName("Link Verifier");
            this.job.setNumReduceTasks(numReducers);
            this.job.setJarByClass(((Object)((Object)this)).getClass());
            Scan scan = new Scan();
            scan.addColumn(FAMILY_NAME, COLUMN_PREV);
            scan.setCaching(10000);
            scan.setCacheBlocks(false);
            TableMapReduceUtil.initTableMapperJob((byte[])IntegrationTestBigLinkedList.getTableName(this.getConf()), (Scan)scan, VerifyMapper.class, LongWritable.class, VLongWritable.class, (Job)this.job);
            this.job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", false);
            this.job.setReducerClass(VerifyReducer.class);
            this.job.setOutputFormatClass(TextOutputFormat.class);
            TextOutputFormat.setOutputPath((Job)this.job, (Path)outputDir);
            boolean success = this.job.waitForCompletion(true);
            return success ? 0 : 1;
        }

        public boolean verify(long expectedReferenced) throws Exception {
            if (this.job == null) {
                throw new IllegalStateException("You should call run() first");
            }
            Counters counters = this.job.getCounters();
            Counter referenced = counters.findCounter((Enum)Counts.REFERENCED);
            Counter unreferenced = counters.findCounter((Enum)Counts.UNREFERENCED);
            Counter undefined = counters.findCounter((Enum)Counts.UNDEFINED);
            boolean success = true;
            if (expectedReferenced != referenced.getValue()) {
                LOG.error((Object)("Expected referenced count does not match with actual referenced count. expected referenced=" + expectedReferenced + " ,actual=" + referenced.getValue()));
                success = false;
            }
            if (unreferenced.getValue() > 0L) {
                LOG.error((Object)("Unreferenced nodes were not expected. Unreferenced count=" + unreferenced.getValue()));
                success = false;
            }
            if (undefined.getValue() > 0L) {
                LOG.error((Object)("Found an undefined node. Undefined count=" + undefined.getValue()));
                success = false;
            }
            return success;
        }

        public static class VerifyReducer
        extends Reducer<LongWritable, VLongWritable, Text, Text> {
            private ArrayList<Long> refs = new ArrayList();

            public void reduce(LongWritable key, Iterable<VLongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
                int defCount = 0;
                this.refs.clear();
                for (VLongWritable type : values) {
                    if (type.get() == -1L) {
                        ++defCount;
                        continue;
                    }
                    this.refs.add(type.get());
                }
                if (defCount == 0 && this.refs.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    String comma = "";
                    for (Long ref : this.refs) {
                        sb.append(comma);
                        comma = ",";
                        sb.append(String.format("%016x", ref));
                    }
                    context.write((Object)new Text(String.format("%016x", key.get())), (Object)new Text(sb.toString()));
                    context.getCounter((Enum)Counts.UNDEFINED).increment(1L);
                } else if (defCount > 0 && this.refs.size() == 0) {
                    context.getCounter((Enum)Counts.UNREFERENCED).increment(1L);
                } else {
                    context.getCounter((Enum)Counts.REFERENCED).increment(1L);
                }
            }
        }

        public static enum Counts {
            UNREFERENCED,
            UNDEFINED,
            REFERENCED,
            CORRUPT;

        }

        public static class VerifyMapper
        extends TableMapper<LongWritable, VLongWritable> {
            private LongWritable row = new LongWritable();
            private LongWritable ref = new LongWritable();
            private VLongWritable vrow = new VLongWritable();

            protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
                this.row.set(Bytes.toLong((byte[])key.get()));
                context.write((Object)this.row, (Object)DEF);
                long prev = Bytes.toLong((byte[])value.getValue(FAMILY_NAME, COLUMN_PREV));
                if (prev >= 0L) {
                    this.ref.set(prev);
                    this.vrow.set(Bytes.toLong((byte[])key.get()));
                    context.write((Object)this.ref, (Object)this.vrow);
                }
            }
        }
    }

    static class Generator
    extends Configured
    implements Tool {
        private static final Log LOG = LogFactory.getLog(Generator.class);
        private static final int WIDTH = 1000000;
        private static final int WRAP = 25000000;

        Generator() {
        }

        public int run(String[] args) throws Exception {
            if (args.length < 3) {
                System.out.println("Usage : " + Generator.class.getSimpleName() + " <num mappers> <num nodes per map> <tmp output dir>");
                System.out.println("   where <num nodes per map> should be a multiple of 25M");
                return 0;
            }
            int numMappers = Integer.parseInt(args[0]);
            long numNodes = Long.parseLong(args[1]);
            Path tmpOutput = new Path(args[2]);
            return this.run(numMappers, numNodes, tmpOutput);
        }

        protected void createSchema() throws IOException {
            byte[] tableName;
            HBaseAdmin admin = new HBaseAdmin(this.getConf());
            if (!admin.tableExists(tableName = IntegrationTestBigLinkedList.getTableName(this.getConf()))) {
                HTableDescriptor htd = new HTableDescriptor(IntegrationTestBigLinkedList.getTableName(this.getConf()));
                htd.addFamily(new HColumnDescriptor(FAMILY_NAME));
                admin.createTable(htd);
            }
            admin.close();
        }

        public int runRandomInputGenerator(int numMappers, long numNodes, Path tmpOutput) throws Exception {
            LOG.info((Object)("Running RandomInputGenerator with numMappers=" + numMappers + ", numNodes=" + numNodes));
            Job job = new Job(this.getConf());
            job.setJobName("Random Input Generator");
            job.setNumReduceTasks(0);
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setInputFormatClass(GeneratorInputFormat.class);
            job.setOutputKeyClass(LongWritable.class);
            job.setOutputValueClass(NullWritable.class);
            job.getConfiguration().setInt(IntegrationTestBigLinkedList.GENERATOR_NUM_MAPPERS_KEY, numMappers);
            job.getConfiguration().setLong(IntegrationTestBigLinkedList.GENERATOR_NUM_ROWS_PER_MAP_KEY, numNodes);
            job.setMapperClass(Mapper.class);
            FileOutputFormat.setOutputPath((Job)job, (Path)tmpOutput);
            job.setOutputFormatClass(SequenceFileOutputFormat.class);
            boolean success = job.waitForCompletion(true);
            return success ? 0 : 1;
        }

        public int runGenerator(int numMappers, long numNodes, Path tmpOutput) throws Exception {
            LOG.info((Object)("Running Generator with numMappers=" + numMappers + ", numNodes=" + numNodes));
            this.createSchema();
            Job job = new Job(this.getConf());
            job.setJobName("Link Generator");
            job.setNumReduceTasks(0);
            job.setJarByClass(((Object)((Object)this)).getClass());
            FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{tmpOutput});
            job.setInputFormatClass(OneFilePerMapperSFIF.class);
            job.setOutputKeyClass(NullWritable.class);
            job.setOutputValueClass(NullWritable.class);
            job.getConfiguration().setInt(IntegrationTestBigLinkedList.GENERATOR_NUM_MAPPERS_KEY, numMappers);
            job.getConfiguration().setLong(IntegrationTestBigLinkedList.GENERATOR_NUM_ROWS_PER_MAP_KEY, numNodes);
            job.setMapperClass(GeneratorMapper.class);
            job.setOutputFormatClass(NullOutputFormat.class);
            job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", false);
            boolean success = job.waitForCompletion(true);
            return success ? 0 : 1;
        }

        public int run(int numMappers, long numNodes, Path tmpOutput) throws Exception {
            int ret = this.runRandomInputGenerator(numMappers, numNodes, tmpOutput);
            if (ret > 0) {
                return ret;
            }
            return this.runGenerator(numMappers, numNodes, tmpOutput);
        }

        static class GeneratorMapper
        extends Mapper<LongWritable, NullWritable, NullWritable, NullWritable> {
            Random rand = new Random();
            long[] first = null;
            long[] prev = null;
            long[] current = new long[1000000];
            byte[] id;
            long count = 0L;
            int i;
            HTable table;
            long numNodes;
            long wrap = 25000000L;

            GeneratorMapper() {
            }

            protected void setup(Mapper.Context context) throws IOException, InterruptedException {
                this.id = Bytes.toBytes((String)UUID.randomUUID().toString());
                Configuration conf = context.getConfiguration();
                this.table = new HTable(conf, IntegrationTestBigLinkedList.getTableName(conf));
                this.table.setAutoFlush(false);
                this.table.setWriteBufferSize(0x400000L);
                this.numNodes = context.getConfiguration().getLong(IntegrationTestBigLinkedList.GENERATOR_NUM_MAPPERS_KEY, 25000000L);
                if (this.numNodes < 25000000L) {
                    this.wrap = this.numNodes;
                }
            }

            protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
                this.table.close();
            }

            protected void map(LongWritable key, NullWritable value, Mapper.Context output) throws IOException {
                this.current[this.i++] = Math.abs(key.get());
                if (this.i == this.current.length) {
                    this.persist(output, this.count, this.prev, this.current, this.id);
                    this.i = 0;
                    if (this.first == null) {
                        this.first = this.current;
                    }
                    this.prev = this.current;
                    this.current = new long[1000000];
                    this.count += (long)this.current.length;
                    output.setStatus("Count " + this.count);
                    if (this.count % this.wrap == 0L) {
                        GeneratorMapper.circularLeftShift(this.first);
                        this.persist(output, -1L, this.prev, this.first, null);
                        this.first = null;
                        this.prev = null;
                    }
                }
            }

            private static void circularLeftShift(long[] first) {
                long ez = first[0];
                for (int i = 0; i < first.length - 1; ++i) {
                    first[i] = first[i + 1];
                }
                first[first.length - 1] = ez;
            }

            private void persist(Mapper.Context output, long count, long[] prev, long[] current, byte[] id) throws IOException {
                for (int i = 0; i < current.length; ++i) {
                    Put put = new Put(Bytes.toBytes((long)current[i]));
                    put.add(FAMILY_NAME, COLUMN_PREV, Bytes.toBytes((long)(prev == null ? -1L : prev[i])));
                    if (count > 0L) {
                        put.add(FAMILY_NAME, COLUMN_COUNT, Bytes.toBytes((long)(count + 1L)));
                    }
                    if (id != null) {
                        put.add(FAMILY_NAME, COLUMN_CLIENT, id);
                    }
                    this.table.put(put);
                    if (i % 1000 != 0) continue;
                    output.progress();
                }
                this.table.flushCommits();
            }
        }

        static class OneFilePerMapperSFIF<K, V>
        extends SequenceFileInputFormat<K, V> {
            OneFilePerMapperSFIF() {
            }

            protected boolean isSplitable(JobContext context, Path filename) {
                return false;
            }
        }

        static class GeneratorInputFormat
        extends InputFormat<LongWritable, NullWritable> {
            GeneratorInputFormat() {
            }

            public RecordReader<LongWritable, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                GeneratorRecordReader rr = new GeneratorRecordReader();
                rr.initialize(split, context);
                return rr;
            }

            public List<InputSplit> getSplits(JobContext job) throws IOException, InterruptedException {
                int numMappers = job.getConfiguration().getInt(IntegrationTestBigLinkedList.GENERATOR_NUM_MAPPERS_KEY, 1);
                ArrayList<InputSplit> splits = new ArrayList<InputSplit>(numMappers);
                for (int i = 0; i < numMappers; ++i) {
                    splits.add(new GeneratorInputSplit());
                }
                return splits;
            }

            static class GeneratorRecordReader
            extends RecordReader<LongWritable, NullWritable> {
                private long count;
                private long numNodes;
                private Random rand;

                GeneratorRecordReader() {
                }

                public void close() throws IOException {
                }

                public LongWritable getCurrentKey() throws IOException, InterruptedException {
                    return new LongWritable(Math.abs(this.rand.nextLong()));
                }

                public NullWritable getCurrentValue() throws IOException, InterruptedException {
                    return NullWritable.get();
                }

                public float getProgress() throws IOException, InterruptedException {
                    return (float)((double)this.count / (double)this.numNodes);
                }

                public void initialize(InputSplit arg0, TaskAttemptContext context) throws IOException, InterruptedException {
                    this.numNodes = context.getConfiguration().getLong(IntegrationTestBigLinkedList.GENERATOR_NUM_ROWS_PER_MAP_KEY, 25000000L);
                    this.rand = new Random();
                }

                public boolean nextKeyValue() throws IOException, InterruptedException {
                    return this.count++ < this.numNodes;
                }
            }

            static class GeneratorInputSplit
            extends InputSplit
            implements Writable {
                GeneratorInputSplit() {
                }

                public long getLength() throws IOException, InterruptedException {
                    return 1L;
                }

                public String[] getLocations() throws IOException, InterruptedException {
                    return new String[0];
                }

                public void readFields(DataInput arg0) throws IOException {
                }

                public void write(DataOutput arg0) throws IOException {
                }
            }
        }

        public static enum Counts {
            UNREFERENCED,
            UNDEFINED,
            REFERENCED,
            CORRUPT;

        }
    }

    static class CINode {
        long key;
        long prev;
        String client;
        long count;

        CINode() {
        }
    }
}

