/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.thrift.CallQueue;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.spi.NoEmitMetricsContext;
import org.apache.hadoop.metrics.spi.OutputRecord;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={SmallTests.class})
@RunWith(value=Parameterized.class)
public class TestCallQueue {
    public static final Log LOG = LogFactory.getLog(TestCallQueue.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private int elementsAdded;
    private int elementsRemoved;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (int elementsAdded : new int[]{100, 200, 300}) {
            for (int elementsRemoved : new int[]{0, 20, 100}) {
                parameters.add(new Object[]{new Integer(elementsAdded), new Integer(elementsRemoved)});
            }
        }
        return parameters;
    }

    public TestCallQueue(int elementsAdded, int elementsRemoved) {
        this.elementsAdded = elementsAdded;
        this.elementsRemoved = elementsRemoved;
        LOG.debug((Object)("elementsAdded:" + elementsAdded + " elementsRemoved:" + elementsRemoved));
    }

    @Test(timeout=3000L)
    public void testPutTake() throws Exception {
        int i;
        ThriftMetrics metrics = TestCallQueue.createMetrics();
        CallQueue callQueue = new CallQueue(new LinkedBlockingQueue(), metrics);
        for (i = 0; i < this.elementsAdded; ++i) {
            callQueue.put(TestCallQueue.createDummyRunnable());
        }
        for (i = 0; i < this.elementsRemoved; ++i) {
            callQueue.take();
        }
        TestCallQueue.verifyMetrics(metrics, "timeInQueue_num_ops", this.elementsRemoved);
    }

    @Test(timeout=3000L)
    public void testOfferPoll() throws Exception {
        int i;
        ThriftMetrics metrics = TestCallQueue.createMetrics();
        CallQueue callQueue = new CallQueue(new LinkedBlockingQueue(), metrics);
        for (i = 0; i < this.elementsAdded; ++i) {
            callQueue.offer(TestCallQueue.createDummyRunnable());
        }
        for (i = 0; i < this.elementsRemoved; ++i) {
            callQueue.poll();
        }
        TestCallQueue.verifyMetrics(metrics, "timeInQueue_num_ops", this.elementsRemoved);
    }

    private static ThriftMetrics createMetrics() throws Exception {
        TestCallQueue.setupMetricsContext();
        Configuration conf = UTIL.getConfiguration();
        return new ThriftMetrics(9090, conf, Hbase.Iface.class);
    }

    private static void setupMetricsContext() throws Exception {
        ContextFactory factory = ContextFactory.getFactory();
        factory.setAttribute("thriftserver.class", (Object)NoEmitMetricsContext.class.getName());
        MetricsUtil.getContext((String)"thriftserver").createRecord("thriftserver").remove();
    }

    private static void verifyMetrics(ThriftMetrics metrics, String name, int expectValue) throws Exception {
        MetricsContext context = MetricsUtil.getContext((String)"thriftserver");
        metrics.doUpdates(context);
        OutputRecord record = (OutputRecord)((Collection)context.getAllRecords().get("thriftserver")).iterator().next();
        Assert.assertEquals((long)expectValue, (long)record.getMetric(name).intValue());
    }

    private static Runnable createDummyRunnable() {
        return new Runnable(){

            @Override
            public void run() {
            }
        };
    }
}

