/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.thrift2.ThriftHBaseServiceHandler;
import org.apache.hadoop.hbase.thrift2.generated.TColumn;
import org.apache.hadoop.hbase.thrift2.generated.TColumnIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TColumnValue;
import org.apache.hadoop.hbase.thrift2.generated.TDelete;
import org.apache.hadoop.hbase.thrift2.generated.TDeleteType;
import org.apache.hadoop.hbase.thrift2.generated.TGet;
import org.apache.hadoop.hbase.thrift2.generated.THBaseService;
import org.apache.hadoop.hbase.thrift2.generated.TIOError;
import org.apache.hadoop.hbase.thrift2.generated.TIllegalArgument;
import org.apache.hadoop.hbase.thrift2.generated.TIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TPut;
import org.apache.hadoop.hbase.thrift2.generated.TResult;
import org.apache.hadoop.hbase.thrift2.generated.TScan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.spi.NoEmitMetricsContext;
import org.apache.hadoop.metrics.spi.OutputRecord;
import org.apache.thrift.TException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestThriftHBaseServiceHandler {
    public static final Log LOG = LogFactory.getLog(TestThriftHBaseServiceHandler.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static byte[] tableAname = Bytes.toBytes((String)"tableA");
    private static byte[] familyAname = Bytes.toBytes((String)"familyA");
    private static byte[] familyBname = Bytes.toBytes((String)"familyB");
    private static byte[] qualifierAname = Bytes.toBytes((String)"qualifierA");
    private static byte[] qualifierBname = Bytes.toBytes((String)"qualifierB");
    private static byte[] valueAname = Bytes.toBytes((String)"valueA");
    private static byte[] valueBname = Bytes.toBytes((String)"valueB");
    private static HColumnDescriptor[] families = new HColumnDescriptor[]{new HColumnDescriptor(familyAname), new HColumnDescriptor(familyBname).setMaxVersions(2)};
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    public void assertTColumnValuesEqual(List<TColumnValue> columnValuesA, List<TColumnValue> columnValuesB) {
        Assert.assertEquals((long)columnValuesA.size(), (long)columnValuesB.size());
        Comparator<TColumnValue> comparator = new Comparator<TColumnValue>(){

            @Override
            public int compare(TColumnValue o1, TColumnValue o2) {
                return Bytes.compareTo((byte[])Bytes.add((byte[])o1.getFamily(), (byte[])o1.getQualifier()), (byte[])Bytes.add((byte[])o2.getFamily(), (byte[])o2.getQualifier()));
            }
        };
        Collections.sort(columnValuesA, comparator);
        Collections.sort(columnValuesB, comparator);
        for (int i = 0; i < columnValuesA.size(); ++i) {
            TColumnValue a = columnValuesA.get(i);
            TColumnValue b = columnValuesB.get(i);
            Assert.assertArrayEquals((byte[])a.getFamily(), (byte[])b.getFamily());
            Assert.assertArrayEquals((byte[])a.getQualifier(), (byte[])b.getQualifier());
            Assert.assertArrayEquals((byte[])a.getValue(), (byte[])b.getValue());
        }
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster();
        HBaseAdmin admin = new HBaseAdmin(UTIL.getConfiguration());
        HTableDescriptor tableDescriptor = new HTableDescriptor(tableAname);
        for (HColumnDescriptor family : families) {
            tableDescriptor.addFamily(family);
        }
        admin.createTable(tableDescriptor);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
    }

    private ThriftHBaseServiceHandler createHandler() {
        return new ThriftHBaseServiceHandler(UTIL.getConfiguration());
    }

    @Test
    public void testExists() throws TIOError, TException {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testExists".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        Assert.assertFalse((boolean)handler.exists(table, get));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        Assert.assertTrue((boolean)handler.exists(table, get));
    }

    @Test
    public void testPutGet() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testPutGet".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        List returnedColumnValues = result.getColumnValues();
        this.assertTColumnValuesEqual(columnValues, returnedColumnValues);
    }

    @Test
    public void testPutGetMultiple() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        byte[] rowName1 = "testPutGetMultiple1".getBytes();
        byte[] rowName2 = "testPutGetMultiple2".getBytes();
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        ArrayList<TPut> puts = new ArrayList<TPut>();
        puts.add(new TPut(ByteBuffer.wrap(rowName1), columnValues));
        puts.add(new TPut(ByteBuffer.wrap(rowName2), columnValues));
        handler.putMultiple(table, puts);
        ArrayList<TGet> gets = new ArrayList<TGet>();
        gets.add(new TGet(ByteBuffer.wrap(rowName1)));
        gets.add(new TGet(ByteBuffer.wrap(rowName2)));
        List results = handler.getMultiple(table, gets);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertArrayEquals((byte[])rowName1, (byte[])((TResult)results.get(0)).getRow());
        this.assertTColumnValuesEqual(columnValues, ((TResult)results.get(0)).getColumnValues());
        Assert.assertArrayEquals((byte[])rowName2, (byte[])((TResult)results.get(1)).getRow());
        this.assertTColumnValuesEqual(columnValues, ((TResult)results.get(1)).getColumnValues());
    }

    @Test
    public void testDeleteMultiple() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        byte[] rowName1 = "testDeleteMultiple1".getBytes();
        byte[] rowName2 = "testDeleteMultiple2".getBytes();
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        ArrayList<TPut> puts = new ArrayList<TPut>();
        puts.add(new TPut(ByteBuffer.wrap(rowName1), columnValues));
        puts.add(new TPut(ByteBuffer.wrap(rowName2), columnValues));
        handler.putMultiple(table, puts);
        ArrayList<TDelete> deletes = new ArrayList<TDelete>();
        deletes.add(new TDelete(ByteBuffer.wrap(rowName1)));
        deletes.add(new TDelete(ByteBuffer.wrap(rowName2)));
        List deleteResults = handler.deleteMultiple(table, deletes);
        Assert.assertEquals((long)0L, (long)deleteResults.size());
        Assert.assertFalse((boolean)handler.exists(table, new TGet(ByteBuffer.wrap(rowName1))));
        Assert.assertFalse((boolean)handler.exists(table, new TGet(ByteBuffer.wrap(rowName2))));
    }

    @Test
    public void testDelete() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testDelete".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        TColumnValue columnValueB = new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname));
        columnValues.add(columnValueA);
        columnValues.add(columnValueB);
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        ArrayList<TColumn> deleteColumns = new ArrayList<TColumn>();
        TColumn deleteColumn = new TColumn(ByteBuffer.wrap(familyAname));
        deleteColumn.setQualifier(qualifierAname);
        deleteColumns.add(deleteColumn);
        delete.setColumns(deleteColumns);
        handler.deleteSingle(table, delete);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        List returnedColumnValues = result.getColumnValues();
        ArrayList<TColumnValue> expectedColumnValues = new ArrayList<TColumnValue>();
        expectedColumnValues.add(columnValueB);
        this.assertTColumnValuesEqual(expectedColumnValues, returnedColumnValues);
    }

    @Test
    public void testDeleteAllTimestamps() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testDeleteAllTimestamps".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        columnValueA.setTimestamp(System.currentTimeMillis() - 10L);
        columnValues.add(columnValueA);
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        columnValueA.setTimestamp(System.currentTimeMillis());
        handler.put(table, put);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        get.setMaxVersions(2);
        TResult result = handler.get(table, get);
        Assert.assertEquals((long)2L, (long)result.getColumnValuesSize());
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        ArrayList<TColumn> deleteColumns = new ArrayList<TColumn>();
        TColumn deleteColumn = new TColumn(ByteBuffer.wrap(familyAname));
        deleteColumn.setQualifier(qualifierAname);
        deleteColumns.add(deleteColumn);
        delete.setColumns(deleteColumns);
        delete.setDeleteType(TDeleteType.DELETE_COLUMNS);
        handler.deleteSingle(table, delete);
        get = new TGet(ByteBuffer.wrap(rowName));
        result = handler.get(table, get);
        Assert.assertNull((Object)result.getRow());
        Assert.assertEquals((long)0L, (long)result.getColumnValuesSize());
    }

    @Test
    public void testDeleteSingleTimestamp() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testDeleteSingleTimestamp".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        long timestamp1 = System.currentTimeMillis() - 10L;
        long timestamp2 = System.currentTimeMillis();
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        columnValueA.setTimestamp(timestamp1);
        columnValues.add(columnValueA);
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        columnValueA.setTimestamp(timestamp2);
        handler.put(table, put);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        get.setMaxVersions(2);
        TResult result = handler.get(table, get);
        Assert.assertEquals((long)2L, (long)result.getColumnValuesSize());
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        ArrayList<TColumn> deleteColumns = new ArrayList<TColumn>();
        TColumn deleteColumn = new TColumn(ByteBuffer.wrap(familyAname));
        deleteColumn.setQualifier(qualifierAname);
        deleteColumns.add(deleteColumn);
        delete.setColumns(deleteColumns);
        delete.setDeleteType(TDeleteType.DELETE_COLUMN);
        handler.deleteSingle(table, delete);
        get = new TGet(ByteBuffer.wrap(rowName));
        result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        Assert.assertEquals((long)1L, (long)result.getColumnValuesSize());
        Assert.assertEquals((long)timestamp1, (long)((TColumnValue)result.getColumnValues().get(0)).getTimestamp());
    }

    @Test
    public void testIncrement() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testIncrement".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(Bytes.toBytes((long)1L))));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        ArrayList<TColumnIncrement> incrementColumns = new ArrayList<TColumnIncrement>();
        incrementColumns.add(new TColumnIncrement(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname)));
        TIncrement increment = new TIncrement(ByteBuffer.wrap(rowName), incrementColumns);
        handler.increment(table, increment);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        Assert.assertEquals((long)1L, (long)result.getColumnValuesSize());
        TColumnValue columnValue = (TColumnValue)result.getColumnValues().get(0);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((long)2L), (byte[])columnValue.getValue());
    }

    @Test
    public void testCheckAndPut() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testCheckAndPut".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValuesA = new ArrayList<TColumnValue>();
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        columnValuesA.add(columnValueA);
        TPut putA = new TPut(ByteBuffer.wrap(rowName), columnValuesA);
        putA.setColumnValues(columnValuesA);
        ArrayList<TColumnValue> columnValuesB = new ArrayList<TColumnValue>();
        TColumnValue columnValueB = new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname));
        columnValuesB.add(columnValueB);
        TPut putB = new TPut(ByteBuffer.wrap(rowName), columnValuesB);
        putB.setColumnValues(columnValuesB);
        Assert.assertFalse((boolean)handler.checkAndPut(table, ByteBuffer.wrap(rowName), ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname), putB));
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertEquals((long)0L, (long)result.getColumnValuesSize());
        handler.put(table, putA);
        Assert.assertTrue((boolean)handler.checkAndPut(table, ByteBuffer.wrap(rowName), ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname), putB));
        result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        List returnedColumnValues = result.getColumnValues();
        ArrayList<TColumnValue> expectedColumnValues = new ArrayList<TColumnValue>();
        expectedColumnValues.add(columnValueA);
        expectedColumnValues.add(columnValueB);
        this.assertTColumnValuesEqual(expectedColumnValues, returnedColumnValues);
    }

    @Test
    public void testCheckAndDelete() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testCheckAndDelete".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValuesA = new ArrayList<TColumnValue>();
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        columnValuesA.add(columnValueA);
        TPut putA = new TPut(ByteBuffer.wrap(rowName), columnValuesA);
        putA.setColumnValues(columnValuesA);
        ArrayList<TColumnValue> columnValuesB = new ArrayList<TColumnValue>();
        TColumnValue columnValueB = new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname));
        columnValuesB.add(columnValueB);
        TPut putB = new TPut(ByteBuffer.wrap(rowName), columnValuesB);
        putB.setColumnValues(columnValuesB);
        handler.put(table, putB);
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        Assert.assertFalse((boolean)handler.checkAndDelete(table, ByteBuffer.wrap(rowName), ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname), delete));
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        this.assertTColumnValuesEqual(columnValuesB, result.getColumnValues());
        handler.put(table, putA);
        Assert.assertTrue((boolean)handler.checkAndDelete(table, ByteBuffer.wrap(rowName), ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname), delete));
        result = handler.get(table, get);
        Assert.assertFalse((boolean)result.isSetRow());
        Assert.assertEquals((long)0L, (long)result.getColumnValuesSize());
    }

    @Test
    public void testScan() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TScan scan = new TScan();
        ArrayList<TColumn> columns = new ArrayList<TColumn>();
        TColumn column = new TColumn();
        column.setFamily(familyAname);
        column.setQualifier(qualifierAname);
        columns.add(column);
        scan.setColumns(columns);
        scan.setStartRow("testScan".getBytes());
        TColumnValue columnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(columnValue);
        for (int i = 0; i < 10; ++i) {
            TPut put = new TPut(ByteBuffer.wrap(("testScan" + i).getBytes()), columnValues);
            handler.put(table, put);
        }
        int scanId = handler.openScanner(table, scan);
        List results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)10L, (long)results.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertArrayEquals((byte[])("testScan" + i).getBytes(), (byte[])((TResult)results.get(i)).getRow());
        }
        results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)0L, (long)results.size());
        handler.closeScanner(scanId);
        try {
            handler.getScannerRows(scanId, 10);
            Assert.fail((String)"Scanner id should be invalid");
        }
        catch (TIllegalArgument e) {
            // empty catch block
        }
    }

    @Test
    public void testMetrics() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        ThriftMetrics metrics = TestThriftHBaseServiceHandler.getMetrics(conf);
        THBaseService.Iface handler = ThriftHBaseServiceHandler.newInstance((Configuration)conf, (ThriftMetrics)metrics);
        byte[] rowName = "testMetrics".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        Assert.assertFalse((boolean)handler.exists(table, get));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        Assert.assertTrue((boolean)handler.exists(table, get));
        TestThriftHBaseServiceHandler.logMetrics(metrics);
        TestThriftHBaseServiceHandler.verifyMetrics(metrics, "put_num_ops", 1);
        TestThriftHBaseServiceHandler.verifyMetrics(metrics, "exists_num_ops", 2);
    }

    private static ThriftMetrics getMetrics(Configuration conf) throws Exception {
        TestThriftHBaseServiceHandler.setupMetricsContext();
        return new ThriftMetrics(Integer.parseInt("9090"), conf, THBaseService.Iface.class);
    }

    private static void setupMetricsContext() throws IOException {
        ContextFactory factory = ContextFactory.getFactory();
        factory.setAttribute("thriftserver.class", (Object)NoEmitMetricsContext.class.getName());
        MetricsUtil.getContext((String)"thriftserver").createRecord("thriftserver").remove();
    }

    private static void logMetrics(ThriftMetrics metrics) throws Exception {
        if (LOG.isDebugEnabled()) {
            return;
        }
        MetricsContext context = MetricsUtil.getContext((String)"thriftserver");
        metrics.doUpdates(context);
        for (String key : context.getAllRecords().keySet()) {
            for (OutputRecord record : (Collection)context.getAllRecords().get(key)) {
                for (String name : record.getMetricNames()) {
                    LOG.debug((Object)("metrics:" + name + " value:" + record.getMetric(name).intValue()));
                }
            }
        }
    }

    private static void verifyMetrics(ThriftMetrics metrics, String name, int expectValue) throws Exception {
        MetricsContext context = MetricsUtil.getContext((String)"thriftserver");
        metrics.doUpdates(context);
        OutputRecord record = (OutputRecord)((Collection)context.getAllRecords().get("thriftserver")).iterator().next();
        Assert.assertEquals((long)expectValue, (long)record.getMetric(name).intValue());
    }
}

