/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.StoppableImplementation;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class ChaosMonkey
extends AbstractHBaseTool
implements Stoppable {
    private static final Log LOG = LogFactory.getLog(ChaosMonkey.class);
    private static final long ONE_SEC = 1000L;
    private static final long FIVE_SEC = 5000L;
    private static final long ONE_MIN = 60000L;
    private static final long TIMEOUT = 60000L;
    final IntegrationTestingUtility util;
    private static final List<Pair<Action, Integer>> ALL_ACTIONS = Lists.newArrayList((Object[])new Pair[]{new Pair((Object)new RestartActiveMaster(5000L), (Object)2), new Pair((Object)new RestartRandomRs(5000L), (Object)2), new Pair((Object)new RestartRandomRs(60000L), (Object)2), new Pair((Object)new RestartRsHoldingMeta(5000L), (Object)1), new Pair((Object)new RestartRsHoldingRoot(5000L), (Object)1), new Pair((Object)new BatchRestartRs(5000L, 0.5f), (Object)2), new Pair((Object)new RollingBatchRestartRs(5000L, 1.0f), (Object)2)});
    public static final String EVERY_MINUTE_RANDOM_ACTION_POLICY = "EVERY_MINUTE_RANDOM_ACTION_POLICY";
    private Policy[] policies;
    private Thread[] monkeyThreads;
    private static final Map<String, Policy> NAMED_POLICIES = Maps.newHashMap();

    public ChaosMonkey(IntegrationTestingUtility util, String ... policies) {
        this.util = util;
        this.setPoliciesByName(policies);
    }

    public ChaosMonkey(IntegrationTestingUtility util, Policy ... policies) {
        this.util = util;
        this.policies = policies;
    }

    private void setPoliciesByName(String ... policies) {
        this.policies = new Policy[policies.length];
        for (int i = 0; i < policies.length; ++i) {
            this.policies[i] = NAMED_POLICIES.get(policies[i]);
        }
    }

    static <T> T selectRandomItem(T[] items) {
        Random random = new Random();
        return items[random.nextInt(items.length)];
    }

    static <T> T selectWeightedRandomItem(List<Pair<T, Integer>> items) {
        Random random = new Random();
        int totalWeight = 0;
        for (Pair<T, Integer> pair : items) {
            totalWeight += ((Integer)pair.getSecond()).intValue();
        }
        int cutoff = random.nextInt(totalWeight);
        int cummulative = 0;
        Object item = null;
        for (int i = 0; i < items.size(); ++i) {
            int curWeight = (Integer)items.get(i).getSecond();
            if (cutoff < cummulative + curWeight) {
                item = items.get(i).getFirst();
                break;
            }
            cummulative += curWeight;
        }
        return (T)item;
    }

    static <T> List<T> selectRandomItems(T[] items, float ratio) {
        Random random = new Random();
        int remaining = (int)Math.ceil((float)items.length * ratio);
        ArrayList<T> selectedItems = new ArrayList<T>(remaining);
        for (int i = 0; i < items.length && remaining > 0; ++i) {
            if (!(random.nextFloat() < (float)remaining / (float)(items.length - i))) continue;
            selectedItems.add(items[i]);
            --remaining;
        }
        return selectedItems;
    }

    public void start() throws Exception {
        this.monkeyThreads = new Thread[this.policies.length];
        for (int i = 0; i < this.policies.length; ++i) {
            this.policies[i].init(new PolicyContext(this.util));
            Thread monkeyThread = new Thread(this.policies[i]);
            monkeyThread.start();
            this.monkeyThreads[i] = monkeyThread;
        }
    }

    public void stop(String why) {
        for (Policy policy : this.policies) {
            policy.stop(why);
        }
    }

    public boolean isStopped() {
        return this.policies[0].isStopped();
    }

    public void waitForStop() throws InterruptedException {
        for (Thread monkeyThread : this.monkeyThreads) {
            monkeyThread.join();
        }
    }

    protected void addOptions() {
        this.addOptWithArg("policy", "a named policy defined in ChaosMonkey.java. Possible values: " + NAMED_POLICIES.keySet());
    }

    protected void processOptions(CommandLine cmd) {
        String[] policies = cmd.getOptionValues("policy");
        if (policies != null) {
            this.setPoliciesByName(policies);
        }
    }

    protected int doWork() throws Exception {
        this.start();
        this.waitForStop();
        return 0;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        IntegrationTestingUtility util = new IntegrationTestingUtility(conf);
        util.initializeCluster(1);
        ChaosMonkey monkey = new ChaosMonkey(util, EVERY_MINUTE_RANDOM_ACTION_POLICY);
        int ret = ToolRunner.run((Configuration)conf, (Tool)monkey, (String[])args);
        System.exit(ret);
    }

    static {
        NAMED_POLICIES.put(EVERY_MINUTE_RANDOM_ACTION_POLICY, new PeriodicRandomActionPolicy(60000L, ALL_ACTIONS));
    }

    public static class PeriodicRandomActionPolicy
    extends Policy {
        private long periodMs;
        private List<Pair<Action, Integer>> actions;

        public PeriodicRandomActionPolicy(long periodMs, List<Pair<Action, Integer>> actions) {
            this.periodMs = periodMs;
            this.actions = actions;
        }

        public PeriodicRandomActionPolicy(long periodMs, Pair<Action, Integer> ... actions) {
            this(periodMs, Arrays.asList(actions));
        }

        public PeriodicRandomActionPolicy(long periodMs, Action ... actions) {
            this.periodMs = periodMs;
            this.actions = new ArrayList<Pair<Action, Integer>>(actions.length);
            for (Action action : actions) {
                this.actions.add((Pair<Action, Integer>)new Pair((Object)action, (Object)1));
            }
        }

        @Override
        public void run() {
            int jitter = new Random().nextInt((int)this.periodMs);
            LOG.info((Object)("Sleeping for " + jitter + " to add jitter"));
            Threads.sleep((long)jitter);
            while (!this.isStopped()) {
                long sleepTime;
                long start = System.currentTimeMillis();
                Action action = (Action)ChaosMonkey.selectWeightedRandomItem(this.actions);
                try {
                    action.perform();
                }
                catch (Exception ex) {
                    LOG.warn((Object)("Exception occured during performing action: " + StringUtils.stringifyException((Throwable)ex)));
                }
                if ((sleepTime = this.periodMs - (System.currentTimeMillis() - start)) <= 0L) continue;
                LOG.info((Object)("Sleeping for:" + sleepTime));
                Threads.sleep((long)sleepTime);
            }
        }

        @Override
        public void init(PolicyContext context) throws Exception {
            super.init(context);
            LOG.info((Object)("Using ChaosMonkey Policy: " + this.getClass() + ", period:" + this.periodMs));
            for (Pair<Action, Integer> action : this.actions) {
                ((Action)action.getFirst()).init(this.context);
            }
        }
    }

    public static abstract class Policy
    extends StoppableImplementation
    implements Runnable {
        PolicyContext context;

        public void init(PolicyContext context) throws Exception {
            this.context = context;
        }
    }

    private static class PolicyContext
    extends ActionContext {
        PolicyContext(IntegrationTestingUtility util) {
            super(util);
        }
    }

    public static class ForceBalancerAction
    extends Action {
        @Override
        void perform() throws Exception {
            LOG.info((Object)"Balancing regions");
            HBaseAdmin admin = this.context.getHaseIntegrationTestingUtility().getHBaseAdmin();
            boolean result = admin.balancer();
            if (!result) {
                LOG.error((Object)"Balancer didn't succeed");
            }
        }
    }

    public static class UnbalanceRegionsAction
    extends Action {
        private double fractionOfRegions;
        private double fractionOfServers;
        private Random random = new Random();

        public UnbalanceRegionsAction(double fractionOfRegions, double fractionOfServers) {
            this.fractionOfRegions = fractionOfRegions;
            this.fractionOfServers = fractionOfServers;
        }

        @Override
        void perform() throws Exception {
            LOG.info((Object)"Unbalancing regions");
            ClusterStatus status = this.cluster.getClusterStatus();
            LinkedList victimServers = new LinkedList(status.getServers());
            int targetServerCount = (int)Math.ceil(this.fractionOfServers * (double)victimServers.size());
            ArrayList<byte[]> targetServers = new ArrayList<byte[]>(targetServerCount);
            for (int i = 0; i < targetServerCount; ++i) {
                int victimIx = this.random.nextInt(victimServers.size());
                String serverName = ((ServerName)victimServers.remove(victimIx)).getServerName();
                targetServers.add(Bytes.toBytes((String)serverName));
            }
            LinkedList<byte[]> victimRegions = new LinkedList<byte[]>();
            for (ServerName server : victimServers) {
                HServerLoad serverLoad = status.getLoad(server);
                LinkedList regions = new LinkedList(serverLoad.getRegionsLoad().keySet());
                int victimRegionCount = (int)Math.ceil(this.fractionOfRegions * (double)regions.size());
                LOG.debug((Object)("Removing " + victimRegionCount + " regions from " + server.getServerName()));
                for (int i = 0; i < victimRegionCount; ++i) {
                    int victimIx = this.random.nextInt(regions.size());
                    String regionId = HRegionInfo.encodeRegionName((byte[])((byte[])regions.remove(victimIx)));
                    victimRegions.add(Bytes.toBytes((String)regionId));
                }
            }
            LOG.info((Object)("Moving " + victimRegions.size() + " regions from " + victimServers.size() + " servers to " + targetServers.size() + " different servers"));
            HBaseAdmin admin = this.context.getHaseIntegrationTestingUtility().getHBaseAdmin();
            for (byte[] victimRegion : victimRegions) {
                int targetIx = this.random.nextInt(targetServers.size());
                admin.move(victimRegion, (byte[])targetServers.get(targetIx));
            }
        }
    }

    public static class RollingBatchRestartRs
    extends BatchRestartRs {
        public RollingBatchRestartRs(long sleepTime, float ratio) {
            super(sleepTime, ratio);
        }

        @Override
        void perform() throws Exception {
            LOG.info((Object)String.format("Performing action: Rolling batch restarting %d%% of region servers", (int)(this.ratio * 100.0f)));
            Random random = new Random();
            List<ServerName> selectedServers = ChaosMonkey.selectRandomItems(this.getCurrentServers(), this.ratio);
            LinkedList<ServerName> serversToBeKilled = new LinkedList<ServerName>(selectedServers);
            LinkedList<ServerName> deadServers = new LinkedList<ServerName>();
            while (!serversToBeKilled.isEmpty() || !deadServers.isEmpty()) {
                ServerName server;
                boolean action = true;
                action = serversToBeKilled.isEmpty() || deadServers.isEmpty() ? deadServers.isEmpty() : random.nextBoolean();
                if (action) {
                    server = (ServerName)serversToBeKilled.remove();
                    this.killRs(server);
                    deadServers.add(server);
                } else {
                    server = (ServerName)deadServers.remove();
                    this.startRs(server);
                }
                this.sleep(random.nextInt((int)this.sleepTime));
            }
        }
    }

    public static class BatchRestartRs
    extends RestartActionBase {
        float ratio;

        public BatchRestartRs(long sleepTime, float ratio) {
            super(sleepTime);
            this.ratio = ratio;
        }

        @Override
        void perform() throws Exception {
            LOG.info((Object)String.format("Performing action: Batch restarting %d%% of region servers", (int)(this.ratio * 100.0f)));
            List<ServerName> selectedServers = ChaosMonkey.selectRandomItems(this.getCurrentServers(), this.ratio);
            for (ServerName server : selectedServers) {
                LOG.info((Object)("Killing region server:" + server));
                this.cluster.killRegionServer(server);
            }
            for (ServerName server : selectedServers) {
                this.cluster.waitForRegionServerToStop(server, 60000L);
            }
            LOG.info((Object)("Killed " + selectedServers.size() + " region servers. Reported num of rs:" + this.cluster.getClusterStatus().getServersSize()));
            this.sleep(this.sleepTime);
            for (ServerName server : selectedServers) {
                LOG.info((Object)("Starting region server:" + server.getHostname()));
                this.cluster.startRegionServer(server.getHostname());
            }
            for (ServerName server : selectedServers) {
                this.cluster.waitForRegionServerToStart(server.getHostname(), 60000L);
            }
            LOG.info((Object)("Started " + selectedServers.size() + " region servers. Reported num of rs:" + this.cluster.getClusterStatus().getServersSize()));
        }
    }

    public static class RestartRsHoldingRoot
    extends RestartRandomRs {
        public RestartRsHoldingRoot(long sleepTime) {
            super(sleepTime);
        }

        @Override
        void perform() throws Exception {
            LOG.info((Object)"Performing action: Restart region server holding ROOT");
            ServerName server = this.cluster.getServerHoldingMeta();
            if (server == null) {
                LOG.warn((Object)"No server is holding -ROOT- right now.");
                return;
            }
            this.restartRs(server, this.sleepTime);
        }
    }

    public static class RestartRsHoldingMeta
    extends RestartRandomRs {
        public RestartRsHoldingMeta(long sleepTime) {
            super(sleepTime);
        }

        @Override
        void perform() throws Exception {
            LOG.info((Object)"Performing action: Restart region server holding META");
            ServerName server = this.cluster.getServerHoldingMeta();
            if (server == null) {
                LOG.warn((Object)"No server is holding .META. right now.");
                return;
            }
            this.restartRs(server, this.sleepTime);
        }
    }

    public static class RestartRandomRs
    extends RestartActionBase {
        public RestartRandomRs(long sleepTime) {
            super(sleepTime);
        }

        @Override
        void perform() throws Exception {
            LOG.info((Object)"Performing action: Restart random region server");
            ServerName server = ChaosMonkey.selectRandomItem(this.getCurrentServers());
            this.restartRs(server, this.sleepTime);
        }
    }

    public static class RestartActiveMaster
    extends RestartActionBase {
        public RestartActiveMaster(long sleepTime) {
            super(sleepTime);
        }

        @Override
        void perform() throws Exception {
            LOG.info((Object)"Performing action: Restart active master");
            ServerName master = this.cluster.getClusterStatus().getMaster();
            this.restartMaster(master, this.sleepTime);
        }
    }

    private static class RestartActionBase
    extends Action {
        long sleepTime;

        public RestartActionBase(long sleepTime) {
            this.sleepTime = sleepTime;
        }

        void sleep(long sleepTime) {
            LOG.info((Object)("Sleeping for:" + sleepTime));
            Threads.sleep((long)sleepTime);
        }

        void restartMaster(ServerName server, long sleepTime) throws IOException {
            this.killMaster(server);
            this.sleep(sleepTime);
            this.startMaster(server);
        }

        void restartRs(ServerName server, long sleepTime) throws IOException {
            this.killRs(server);
            this.sleep(sleepTime);
            this.startRs(server);
        }
    }

    public static class Action {
        protected ActionContext context;
        protected HBaseCluster cluster;
        protected ClusterStatus initialStatus;
        protected ServerName[] initialServers;

        void init(ActionContext context) throws Exception {
            this.context = context;
            this.cluster = context.getHBaseCluster();
            this.initialStatus = this.cluster.getInitialClusterStatus();
            Collection regionServers = this.initialStatus.getServers();
            this.initialServers = regionServers.toArray(new ServerName[regionServers.size()]);
        }

        void perform() throws Exception {
        }

        protected ServerName[] getCurrentServers() throws IOException {
            Collection regionServers = this.cluster.getClusterStatus().getServers();
            return regionServers.toArray(new ServerName[regionServers.size()]);
        }

        protected void killMaster(ServerName server) throws IOException {
            LOG.info((Object)("Killing master:" + server));
            this.cluster.killMaster(server);
            this.cluster.waitForMasterToStop(server, 60000L);
            LOG.info((Object)("Killed master server:" + server));
        }

        protected void startMaster(ServerName server) throws IOException {
            LOG.info((Object)("Starting master:" + server.getHostname()));
            this.cluster.startMaster(server.getHostname());
            this.cluster.waitForActiveAndReadyMaster(60000L);
            LOG.info((Object)("Started master: " + server));
        }

        protected void killRs(ServerName server) throws IOException {
            LOG.info((Object)("Killing region server:" + server));
            this.cluster.killRegionServer(server);
            this.cluster.waitForRegionServerToStop(server, 60000L);
            LOG.info((Object)("Killed region server:" + server + ". Reported num of rs:" + this.cluster.getClusterStatus().getServersSize()));
        }

        protected void startRs(ServerName server) throws IOException {
            LOG.info((Object)("Starting region server:" + server.getHostname()));
            this.cluster.startRegionServer(server.getHostname());
            this.cluster.waitForRegionServerToStart(server.getHostname(), 60000L);
            LOG.info((Object)("Started region server:" + server + ". Reported num of rs:" + this.cluster.getClusterStatus().getServersSize()));
        }
    }

    private static class ActionContext {
        private IntegrationTestingUtility util;

        ActionContext(IntegrationTestingUtility util) {
            this.util = util;
        }

        IntegrationTestingUtility getHaseIntegrationTestingUtility() {
            return this.util;
        }

        HBaseCluster getHBaseCluster() {
            return this.util.getHBaseClusterInterface();
        }
    }
}

