/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.util.StringUtils;

public abstract class MultiThreadedAction {
    private static final Log LOG = LogFactory.getLog(MultiThreadedAction.class);
    protected final byte[] tableName;
    protected final byte[] columnFamily;
    protected final Configuration conf;
    protected int numThreads = 1;
    protected long startKey = 0L;
    protected long endKey = 1L;
    protected AtomicInteger numThreadsWorking = new AtomicInteger();
    protected AtomicLong numKeys = new AtomicLong();
    protected AtomicLong numCols = new AtomicLong();
    protected AtomicLong totalOpTimeMs = new AtomicLong();
    protected boolean verbose = false;
    protected int minDataSize = 256;
    protected int maxDataSize = 1024;
    private String actionLetter;
    private boolean streamingCounters;
    public static final int REPORTING_INTERVAL_MS = 5000;

    public MultiThreadedAction(Configuration conf, byte[] tableName, byte[] columnFamily, String actionLetter) {
        this.conf = conf;
        this.tableName = tableName;
        this.columnFamily = columnFamily;
        this.actionLetter = actionLetter;
    }

    public void start(long startKey, long endKey, int numThreads) throws IOException {
        this.startKey = startKey;
        this.endKey = endKey;
        this.numThreads = numThreads;
        new Thread(new ProgressReporter(this.actionLetter)).start();
    }

    private static String formatTime(long elapsedTime) {
        String format = String.format("%%0%dd", 2);
        String seconds = String.format(format, (elapsedTime /= 1000L) % 60L);
        String minutes = String.format(format, elapsedTime % 3600L / 60L);
        String hours = String.format(format, elapsedTime / 3600L);
        String time = hours + ":" + minutes + ":" + seconds;
        return time;
    }

    public void setDataSize(int minDataSize, int maxDataSize) {
        this.minDataSize = minDataSize;
        this.maxDataSize = maxDataSize;
    }

    public void waitForFinish() {
        while (this.numThreadsWorking.get() != 0) {
            Threads.sleepWithoutInterrupt((long)1000L);
        }
    }

    protected void startThreads(Collection<? extends Thread> threads) {
        this.numThreadsWorking.addAndGet(threads.size());
        for (Thread thread : threads) {
            thread.start();
        }
    }

    public long getEndKey() {
        return this.endKey;
    }

    protected abstract String progressInfo();

    protected static void appendToStatus(StringBuilder sb, String desc, long v) {
        if (v == 0L) {
            return;
        }
        sb.append(", ");
        sb.append(desc);
        sb.append("=");
        sb.append(v);
    }

    private class ProgressReporter
    implements Runnable {
        private String reporterId = "";

        public ProgressReporter(String id) {
            this.reporterId = id;
        }

        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            long priorNumKeys = 0L;
            long priorCumulativeOpTime = 0L;
            int priorAverageKeysPerSecond = 0;
            Threads.sleep((long)5000L);
            while (MultiThreadedAction.this.numThreadsWorking.get() != 0) {
                String threadsLeft = "[" + this.reporterId + ":" + MultiThreadedAction.this.numThreadsWorking.get() + "] ";
                if (MultiThreadedAction.this.numKeys.get() == 0L) {
                    LOG.info((Object)(threadsLeft + "Number of keys = 0"));
                } else {
                    long numKeys = MultiThreadedAction.this.numKeys.get();
                    long time = System.currentTimeMillis() - startTime;
                    long totalOpTime = MultiThreadedAction.this.totalOpTimeMs.get();
                    long numKeysDelta = numKeys - priorNumKeys;
                    long totalOpTimeDelta = totalOpTime - priorCumulativeOpTime;
                    double averageKeysPerSecond = time > 0L ? (double)(numKeys * 1000L / time) : 0.0;
                    LOG.info((Object)(threadsLeft + "Keys=" + numKeys + ", cols=" + StringUtils.humanReadableInt((long)MultiThreadedAction.this.numCols.get()) + ", time=" + MultiThreadedAction.formatTime(time) + (numKeys > 0L && time > 0L ? " Overall: [keys/s= " + numKeys * 1000L / time + ", latency=" + totalOpTime / numKeys + " ms]" : "") + (numKeysDelta > 0L ? " Current: [keys/s=" + numKeysDelta * 1000L / 5000L + ", latency=" + totalOpTimeDelta / numKeysDelta + " ms]" : "") + MultiThreadedAction.this.progressInfo()));
                    if (MultiThreadedAction.this.streamingCounters) {
                        this.printStreamingCounters(numKeysDelta, averageKeysPerSecond - (double)priorAverageKeysPerSecond);
                    }
                    priorNumKeys = numKeys;
                    priorCumulativeOpTime = totalOpTime;
                    priorAverageKeysPerSecond = (int)averageKeysPerSecond;
                }
                Threads.sleep((long)5000L);
            }
        }

        private void printStreamingCounters(long numKeysDelta, double avgKeysPerSecondDelta) {
            System.err.println("reporter:counter:numKeys," + this.reporterId + "," + numKeysDelta);
            System.err.println("reporter:counter:numCols," + this.reporterId + "," + MultiThreadedAction.this.numCols.get());
            System.err.println("reporter:counter:avgKeysPerSecond," + this.reporterId + "," + (long)avgKeysPerSecondDelta);
        }
    }
}

