/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestTool;
import org.apache.hadoop.hbase.util.MultiThreadedWriter;
import org.apache.hadoop.hbase.util.ProcessBasedLocalHBaseCluster;
import org.apache.hadoop.hbase.util.Threads;

public class RestartMetaTest
extends AbstractHBaseTool {
    private static final Log LOG = LogFactory.getLog(RestartMetaTest.class);
    private static final int DEFAULT_NUM_RS = 2;
    private static byte[] TABLE_NAME = Bytes.toBytes((String)"load_test");
    private static final int SLEEP_SEC_AFTER_DATA_LOAD = 5;
    private int numRegionServers;
    private String hbaseHome;
    private static final String OPT_HBASE_HOME = "hbase_home";
    private static final String OPT_NUM_RS = "num_rs";

    private void loadData() throws IOException {
        long startKey = 0L;
        long endKey = 100000L;
        long minColsPerKey = 5L;
        long maxColsPerKey = 15L;
        int minColDataSize = 256;
        int maxColDataSize = 768;
        int numThreads = 10;
        System.out.printf("Key range %d .. %d\n", startKey, endKey);
        System.out.printf("Number of Columns/Key: %d..%d\n", minColsPerKey, maxColsPerKey);
        System.out.printf("Data Size/Column: %d..%d bytes\n", minColDataSize, maxColDataSize);
        System.out.printf("Client Threads: %d\n", numThreads);
        MultiThreadedWriter writer = new MultiThreadedWriter(this.conf, TABLE_NAME, LoadTestTool.COLUMN_FAMILY);
        writer.setMultiPut(true);
        writer.setColumnsPerKey(minColsPerKey, maxColsPerKey);
        writer.setDataSize(minColDataSize, maxColDataSize);
        writer.start(startKey, endKey, numThreads);
        System.out.printf("Started loading data...", new Object[0]);
        writer.waitForFinish();
        System.out.printf("Finished loading data...", new Object[0]);
    }

    protected int doWork() throws Exception {
        Result result;
        ProcessBasedLocalHBaseCluster hbaseCluster = new ProcessBasedLocalHBaseCluster(this.conf, this.hbaseHome, this.numRegionServers);
        hbaseCluster.start();
        HBaseTestingUtility.createPreSplitLoadTestTable(this.conf, TABLE_NAME, LoadTestTool.COLUMN_FAMILY, Compression.Algorithm.NONE, DataBlockEncoding.NONE);
        LOG.debug((Object)"Loading data....\n\n");
        this.loadData();
        LOG.debug((Object)"Sleeping for 5 seconds....\n\n");
        Threads.sleep((long)25L);
        int metaRSPort = HBaseTestingUtility.getMetaRSPort(this.conf);
        LOG.debug((Object)("Killing META region server running on port " + metaRSPort));
        hbaseCluster.killRegionServer(metaRSPort);
        Threads.sleep((long)2000L);
        LOG.debug((Object)"Restarting region server running on port metaRSPort");
        hbaseCluster.startRegionServer(metaRSPort);
        Threads.sleep((long)2000L);
        LOG.debug((Object)"Trying to scan meta");
        HTable metaTable = new HTable(this.conf, HConstants.META_TABLE_NAME);
        ResultScanner scanner = metaTable.getScanner(new Scan());
        while ((result = scanner.next()) != null) {
            LOG.info((Object)("Region assignment from META: " + Bytes.toStringBinary((byte[])result.getRow()) + " => " + Bytes.toStringBinary((byte[])((byte[])result.getFamilyMap(HConstants.CATALOG_FAMILY).get(HConstants.SERVER_QUALIFIER)))));
        }
        return 0;
    }

    protected void addOptions() {
        this.addRequiredOptWithArg(OPT_HBASE_HOME, "HBase home directory");
        this.addOptWithArg(OPT_NUM_RS, "Number of Region Servers");
        this.addOptWithArg(LoadTestTool.OPT_DATA_BLOCK_ENCODING, LoadTestTool.OPT_DATA_BLOCK_ENCODING_USAGE);
    }

    protected void processOptions(CommandLine cmd) {
        this.hbaseHome = cmd.getOptionValue(OPT_HBASE_HOME);
        if (this.hbaseHome == null || !new File(this.hbaseHome).isDirectory()) {
            throw new IllegalArgumentException("Invalid HBase home directory: " + this.hbaseHome);
        }
        LOG.info((Object)("Using HBase home directory " + this.hbaseHome));
        this.numRegionServers = Integer.parseInt(cmd.getOptionValue(OPT_NUM_RS, String.valueOf(2)));
    }

    public static void main(String[] args) {
        new RestartMetaTest().doStaticMain(args);
    }
}

