/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.ByteBloomFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestByteBloomFilter
extends TestCase {
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    public void testBasicBloom() throws Exception {
        ByteBloomFilter bf1 = new ByteBloomFilter(1000, (double)0.01f, 1, 0);
        ByteBloomFilter bf2 = new ByteBloomFilter(1000, (double)0.01f, 1, 0);
        bf1.allocBloom();
        bf2.allocBloom();
        byte[] key1 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] key2 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 7};
        bf1.add(key1);
        bf2.add(key2);
        TestByteBloomFilter.assertTrue((boolean)bf1.contains(key1));
        TestByteBloomFilter.assertFalse((boolean)bf1.contains(key2));
        TestByteBloomFilter.assertFalse((boolean)bf2.contains(key1));
        TestByteBloomFilter.assertTrue((boolean)bf2.contains(key2));
        byte[] bkey = new byte[]{1, 2, 3, 4};
        byte[] bval = "this is a much larger byte array".getBytes();
        bf1.add(bkey);
        bf1.add(bval, 1, bval.length - 1);
        TestByteBloomFilter.assertTrue((boolean)bf1.contains(bkey));
        TestByteBloomFilter.assertTrue((boolean)bf1.contains(bval, 1, bval.length - 1));
        TestByteBloomFilter.assertFalse((boolean)bf1.contains(bval));
        TestByteBloomFilter.assertFalse((boolean)bf1.contains(bval));
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        bf1.writeBloom((DataOutput)new DataOutputStream(bOut));
        ByteBuffer bb = ByteBuffer.wrap(bOut.toByteArray());
        ByteBloomFilter newBf1 = new ByteBloomFilter(1000, (double)0.01f, 1, 0);
        TestByteBloomFilter.assertTrue((boolean)newBf1.contains(key1, bb));
        TestByteBloomFilter.assertFalse((boolean)newBf1.contains(key2, bb));
        TestByteBloomFilter.assertTrue((boolean)newBf1.contains(bkey, bb));
        TestByteBloomFilter.assertTrue((boolean)newBf1.contains(bval, 1, bval.length - 1, bb));
        TestByteBloomFilter.assertFalse((boolean)newBf1.contains(bval, bb));
        TestByteBloomFilter.assertFalse((boolean)newBf1.contains(bval, bb));
        System.out.println("Serialized as " + bOut.size() + " bytes");
        TestByteBloomFilter.assertTrue(((long)bOut.size() - bf1.byteSize < 10L ? 1 : 0) != 0);
    }

    public void testBloomFold() throws Exception {
        ByteBloomFilter b = new ByteBloomFilter(1003, (double)0.01f, 1, 2);
        b.allocBloom();
        long origSize = b.getByteSize();
        TestByteBloomFilter.assertEquals((long)1204L, (long)origSize);
        for (int i = 0; i < 12; ++i) {
            b.add(Bytes.toBytes((int)i));
        }
        b.compactBloom();
        TestByteBloomFilter.assertEquals((long)(origSize >> 2), (long)b.getByteSize());
        int falsePositives = 0;
        for (int i = 0; i < 25; ++i) {
            if (b.contains(Bytes.toBytes((int)i))) {
                if (i < 12) continue;
                ++falsePositives;
                continue;
            }
            TestByteBloomFilter.assertFalse((i < 12 ? 1 : 0) != 0);
        }
        TestByteBloomFilter.assertTrue((falsePositives <= 1 ? 1 : 0) != 0);
    }

    public void testBloomPerf() throws Exception {
        float err = 0.01f;
        ByteBloomFilter b = new ByteBloomFilter(10000000, (double)err, 1, 3);
        b.allocBloom();
        long startTime = System.currentTimeMillis();
        long origSize = b.getByteSize();
        for (int i = 0; i < 1000000; ++i) {
            b.add(Bytes.toBytes((int)i));
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Total Add time = " + (endTime - startTime) + "ms");
        startTime = System.currentTimeMillis();
        b.compactBloom();
        endTime = System.currentTimeMillis();
        System.out.println("Total Fold time = " + (endTime - startTime) + "ms");
        TestByteBloomFilter.assertTrue((origSize >= b.getByteSize() << 3 ? 1 : 0) != 0);
        startTime = System.currentTimeMillis();
        int falsePositives = 0;
        for (int i = 0; i < 2000000; ++i) {
            if (b.contains(Bytes.toBytes((int)i))) {
                if (i < 1000000) continue;
                ++falsePositives;
                continue;
            }
            TestByteBloomFilter.assertFalse((i < 1000000 ? 1 : 0) != 0);
        }
        endTime = System.currentTimeMillis();
        System.out.println("Total Contains time = " + (endTime - startTime) + "ms");
        System.out.println("False Positive = " + falsePositives);
        TestByteBloomFilter.assertTrue(((float)falsePositives <= 1000000.0f * err ? 1 : 0) != 0);
    }

    public void testSizing() {
        int bitSize = 0x100000;
        double errorRate = 0.025;
        long maxKeys = ByteBloomFilter.idealMaxKeys((long)bitSize, (double)errorRate);
        TestByteBloomFilter.assertEquals((long)136570L, (long)maxKeys);
        long bitSize2 = ByteBloomFilter.computeBitSize((long)maxKeys, (double)errorRate);
        TestByteBloomFilter.assertTrue(((double)Math.abs(bitSize2 - (long)bitSize) * 1.0 / (double)bitSize < 1.0E-5 ? 1 : 0) != 0);
    }

    public void testFoldableByteSize() {
        TestByteBloomFilter.assertEquals((int)128, (int)ByteBloomFilter.computeFoldableByteSize((long)1000L, (int)5));
        TestByteBloomFilter.assertEquals((int)640, (int)ByteBloomFilter.computeFoldableByteSize((long)5001L, (int)4));
    }
}

