/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestFSTableDescriptors {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestFSTableDescriptors.class);
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test(expected=IllegalArgumentException.class)
    public void testRegexAgainstOldStyleTableInfo() {
        Path p = new Path("/tmp", ".tableinfo");
        int i = FSTableDescriptors.getTableInfoSequenceid((Path)p);
        Assert.assertEquals((long)0L, (long)i);
        p = new Path("/tmp", "abc");
        FSTableDescriptors.getTableInfoSequenceid((Path)p);
    }

    @Test
    public void testCreateAndUpdate() throws IOException {
        Path testdir = UTIL.getDataTestDir("testCreate");
        HTableDescriptor htd = new HTableDescriptor("testCreate");
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Assert.assertTrue((boolean)FSTableDescriptors.createTableDescriptor((FileSystem)fs, (Path)testdir, (HTableDescriptor)htd));
        Assert.assertFalse((boolean)FSTableDescriptors.createTableDescriptor((FileSystem)fs, (Path)testdir, (HTableDescriptor)htd));
        FileStatus[] statuses = fs.listStatus(testdir);
        Assert.assertTrue((String)("statuses.length=" + statuses.length), (statuses.length == 1 ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            FSTableDescriptors.updateHTableDescriptor((FileSystem)fs, (Path)testdir, (HTableDescriptor)htd);
        }
        statuses = fs.listStatus(testdir);
        Assert.assertTrue((statuses.length == 1 ? 1 : 0) != 0);
        Path tmpTableDir = new Path(FSUtils.getTablePath((Path)testdir, (byte[])htd.getName()), ".tmp");
        statuses = fs.listStatus(tmpTableDir);
        Assert.assertTrue((statuses.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSequenceidAdvancesOnTableInfo() throws IOException {
        Path testdir = UTIL.getDataTestDir("testSequenceidAdvancesOnTableInfo");
        HTableDescriptor htd = new HTableDescriptor("testSequenceidAdvancesOnTableInfo");
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path p0 = FSTableDescriptors.updateHTableDescriptor((FileSystem)fs, (Path)testdir, (HTableDescriptor)htd);
        int i0 = FSTableDescriptors.getTableInfoSequenceid((Path)p0);
        Path p1 = FSTableDescriptors.updateHTableDescriptor((FileSystem)fs, (Path)testdir, (HTableDescriptor)htd);
        Assert.assertTrue((!fs.exists(p0) ? 1 : 0) != 0);
        int i1 = FSTableDescriptors.getTableInfoSequenceid((Path)p1);
        Assert.assertTrue((i1 == i0 + 1 ? 1 : 0) != 0);
        Path p2 = FSTableDescriptors.updateHTableDescriptor((FileSystem)fs, (Path)testdir, (HTableDescriptor)htd);
        Assert.assertTrue((!fs.exists(p1) ? 1 : 0) != 0);
        int i2 = FSTableDescriptors.getTableInfoSequenceid((Path)p2);
        Assert.assertTrue((i2 == i1 + 1 ? 1 : 0) != 0);
    }

    @Test
    public void testFormatTableInfoSequenceId() {
        Path p0 = this.assertWriteAndReadSequenceid(0);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            sb.append("0");
        }
        Assert.assertEquals((Object)(".tableinfo." + sb.toString()), (Object)p0.getName());
        Path p2 = this.assertWriteAndReadSequenceid(2);
        Path p10000 = this.assertWriteAndReadSequenceid(10000);
        Path p = new Path(p0.getParent(), ".tableinfo");
        FileStatus fs = new FileStatus(0L, false, 0, 0L, 0L, p);
        FileStatus fs0 = new FileStatus(0L, false, 0, 0L, 0L, p0);
        FileStatus fs2 = new FileStatus(0L, false, 0, 0L, 0L, p2);
        FileStatus fs10000 = new FileStatus(0L, false, 0, 0L, 0L, p10000);
        FSTableDescriptors.FileStatusFileNameComparator comparator = new FSTableDescriptors.FileStatusFileNameComparator();
        Assert.assertTrue((comparator.compare(fs, fs0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(fs0, fs2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(fs2, fs10000) > 0 ? 1 : 0) != 0);
    }

    private Path assertWriteAndReadSequenceid(int i) {
        Path p = FSTableDescriptors.getTableInfoFileName((Path)new Path("/tmp"), (int)i);
        int ii = FSTableDescriptors.getTableInfoSequenceid((Path)p);
        Assert.assertEquals((long)i, (long)ii);
        return p;
    }

    @Test
    public void testRemoves() throws IOException {
        String name = "testRemoves";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "testRemoves");
        FSTableDescriptors htds = new FSTableDescriptors(fs, rootdir);
        HTableDescriptor htd = new HTableDescriptor("testRemoves");
        htds.add(htd);
        Assert.assertNotNull((Object)htds.remove(htd.getNameAsString()));
        Assert.assertNull((Object)htds.remove(htd.getNameAsString()));
    }

    @Test
    public void testReadingHTDFromFS() throws IOException {
        String name = "testReadingHTDFromFS";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        HTableDescriptor htd = new HTableDescriptor("testReadingHTDFromFS");
        Path rootdir = UTIL.getDataTestDir("testReadingHTDFromFS");
        this.createHTDInFS(fs, rootdir, htd);
        HTableDescriptor htd2 = FSTableDescriptors.getTableDescriptor((FileSystem)fs, (Path)rootdir, (String)htd.getNameAsString());
        Assert.assertTrue((boolean)htd.equals((Object)htd2));
    }

    private void createHTDInFS(FileSystem fs, Path rootdir, HTableDescriptor htd) throws IOException {
        FSTableDescriptors.createTableDescriptor((FileSystem)fs, (Path)rootdir, (HTableDescriptor)htd);
    }

    @Test
    public void testHTableDescriptors() throws IOException, InterruptedException {
        int i;
        String name = "testHTableDescriptors";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "testHTableDescriptors");
        int count = 10;
        for (int i2 = 0; i2 < 10; ++i2) {
            HTableDescriptor htd = new HTableDescriptor("testHTableDescriptors" + i2);
            this.createHTDInFS(fs, rootdir, htd);
        }
        FSTableDescriptors htds = new FSTableDescriptors(fs, rootdir){

            public HTableDescriptor get(byte[] tablename) throws TableExistsException, FileNotFoundException, IOException {
                LOG.info((Object)(Bytes.toString((byte[])tablename) + ", cachehits=" + this.cachehits));
                return super.get(tablename);
            }
        };
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((htds.get(Bytes.toBytes((String)("testHTableDescriptors" + i))) != null ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((htds.get(Bytes.toBytes((String)("testHTableDescriptors" + i))) != null ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            HTableDescriptor htd = new HTableDescriptor("testHTableDescriptors" + i);
            htd.addFamily(new HColumnDescriptor("" + i));
            FSTableDescriptors.updateHTableDescriptor((FileSystem)fs, (Path)rootdir, (HTableDescriptor)htd);
        }
        Thread.sleep(100L);
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((htds.get(Bytes.toBytes((String)("testHTableDescriptors" + i))) != null ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((htds.get(Bytes.toBytes((String)("testHTableDescriptors" + i))) != null ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)40L, (long)htds.invocations);
        Assert.assertTrue((String)("expected=20, actual=" + htds.cachehits), (htds.cachehits >= 20L ? 1 : 0) != 0);
        Assert.assertTrue((htds.get(HConstants.ROOT_TABLE_NAME) != null ? 1 : 0) != 0);
        Assert.assertEquals((long)htds.invocations, (long)41L);
        Assert.assertTrue((String)("expected=21, actual=" + htds.cachehits), (htds.cachehits >= 21L ? 1 : 0) != 0);
    }

    @Test
    public void testNoSuchTable() throws IOException {
        String name = "testNoSuchTable";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "testNoSuchTable");
        FSTableDescriptors htds = new FSTableDescriptors(fs, rootdir);
        Assert.assertNull((String)"There shouldn't be any HTD for this table", (Object)htds.get("NoSuchTable"));
    }

    @Test
    public void testUpdates() throws IOException {
        String name = "testUpdates";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "testUpdates");
        FSTableDescriptors htds = new FSTableDescriptors(fs, rootdir);
        HTableDescriptor htd = new HTableDescriptor("testUpdates");
        htds.add(htd);
        htds.add(htd);
        htds.add(htd);
    }

    @Test
    public void testTableInfoFileStatusComparator() {
        FileStatus bare = new FileStatus(0L, false, 0, 0L, -1L, new Path("/tmp", ".tableinfo"));
        FileStatus future = new FileStatus(0L, false, 0, 0L, -1L, new Path("/tmp/tablinfo." + System.currentTimeMillis()));
        FileStatus farFuture = new FileStatus(0L, false, 0, 0L, -1L, new Path("/tmp/tablinfo." + System.currentTimeMillis() + 1000));
        FileStatus[] alist = new FileStatus[]{bare, future, farFuture};
        FileStatus[] blist = new FileStatus[]{bare, farFuture, future};
        FileStatus[] clist = new FileStatus[]{farFuture, bare, future};
        FSTableDescriptors.FileStatusFileNameComparator c = new FSTableDescriptors.FileStatusFileNameComparator();
        Arrays.sort(alist, c);
        Arrays.sort(blist, c);
        Arrays.sort(clist, c);
        for (int i = 0; i < alist.length; ++i) {
            Assert.assertTrue((boolean)alist[i].equals((Object)blist[i]));
            Assert.assertTrue((boolean)blist[i].equals((Object)clist[i]));
            Assert.assertTrue((boolean)clist[i].equals((Object)(i == 0 ? farFuture : (i == 1 ? future : bare))));
        }
    }

    @Test
    public void testReadingArchiveDirectoryFromFS() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        try {
            new FSTableDescriptors(fs, FSUtils.getRootDir((Configuration)UTIL.getConfiguration())).get(".archive");
            Assert.fail((String)"Shouldn't be able to read a table descriptor for the archive directory.");
        }
        catch (IOException e) {
            LOG.debug((Object)("Correctly got error when reading a table descriptor from the archive directory: " + e.getMessage()));
        }
    }
}

