/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.collect.Multimap;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.RegionTransitionData;
import org.apache.hadoop.hbase.io.hfile.TestHFile;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.TestEndToEndSplitTransaction;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.HBaseFsckRepair;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.util.hbck.HFileCorruptionChecker;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Writable;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestHBaseFsck {
    static final Log LOG = LogFactory.getLog(TestHBaseFsck.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Configuration conf = TEST_UTIL.getConfiguration();
    private static final String FAM_STR = "fam";
    private static final byte[] FAM = Bytes.toBytes((String)"fam");
    private static final int REGION_ONLINE_TIMEOUT = 800;
    private HTable tbl;
    private static final byte[][] SPLITS = new byte[][]{Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C")};
    private static final byte[][] ROWKEYS = new byte[][]{Bytes.toBytes((String)"00"), Bytes.toBytes((String)"50"), Bytes.toBytes((String)"A0"), Bytes.toBytes((String)"A5"), Bytes.toBytes((String)"B0"), Bytes.toBytes((String)"B5"), Bytes.toBytes((String)"C0"), Bytes.toBytes((String)"C5")};
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.distributed.log.splitting", false);
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testHBaseFsck() throws Exception {
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        String table = "tableBadMetaAssign";
        TEST_UTIL.createTable(Bytes.toBytes((String)table), FAM);
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        HTable meta = new HTable(conf, HTableDescriptor.META_TABLEDESC.getName());
        ResultScanner scanner = meta.getScanner(new Scan());
        block0: for (Result res : scanner) {
            long startCode = Bytes.toLong((byte[])res.getValue(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER));
            for (JVMClusterUtil.RegionServerThread rs : TEST_UTIL.getHBaseCluster().getRegionServerThreads()) {
                ServerName sn = rs.getRegionServer().getServerName();
                if (startCode == sn.getStartcode()) continue;
                Put put = new Put(res.getRow());
                put.setWriteToWAL(false);
                put.add(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)sn.getHostAndPort()));
                put.add(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes((long)sn.getStartcode()));
                meta.put(put);
                break block0;
            }
        }
        HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(conf, true), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.SERVER_DOES_NOT_MATCH_META});
        Thread.sleep(1000L);
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        HTable t = new HTable(conf, Bytes.toBytes((String)table));
        ResultScanner s = t.getScanner(new Scan());
        s.close();
        t.close();
        scanner.close();
        meta.close();
    }

    private HRegionInfo createRegion(Configuration conf, HTableDescriptor htd, byte[] startKey, byte[] endKey) throws IOException {
        HTable meta = new HTable(conf, HConstants.META_TABLE_NAME);
        HRegionInfo hri = new HRegionInfo(htd.getName(), startKey, endKey);
        Put put = new Put(hri.getRegionName());
        put.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri));
        meta.put(put);
        return hri;
    }

    private void dumpMeta(byte[] tableName) throws IOException {
        List<byte[]> metaRows = TEST_UTIL.getMetaTableRows(tableName);
        for (byte[] row : metaRows) {
            LOG.info((Object)Bytes.toString((byte[])row));
        }
    }

    private void undeployRegion(HBaseAdmin admin, ServerName sn, HRegionInfo hri) throws IOException, InterruptedException {
        try {
            HBaseFsckRepair.closeRegionSilentlyAndWait((HBaseAdmin)admin, (ServerName)sn, (HRegionInfo)hri);
            admin.getMaster().offline(hri.getRegionName());
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Got exception when attempting to offline region " + Bytes.toString((byte[])hri.getRegionName())), (Throwable)ioe);
        }
    }

    private void deleteRegion(Configuration conf, HTableDescriptor htd, byte[] startKey, byte[] endKey, boolean unassign, boolean metaRow, boolean hdfs) throws IOException, InterruptedException {
        this.deleteRegion(conf, htd, startKey, endKey, unassign, metaRow, hdfs, false);
    }

    private void deleteRegion(Configuration conf, HTableDescriptor htd, byte[] startKey, byte[] endKey, boolean unassign, boolean metaRow, boolean hdfs, boolean regionInfoOnly) throws IOException, InterruptedException {
        LOG.info((Object)"** Before delete:");
        this.dumpMeta(htd.getName());
        NavigableMap hris = this.tbl.getRegionLocations();
        for (Map.Entry e : hris.entrySet()) {
            HRegionInfo hri = (HRegionInfo)e.getKey();
            ServerName hsa = (ServerName)e.getValue();
            if (Bytes.compareTo((byte[])hri.getStartKey(), (byte[])startKey) == 0 && Bytes.compareTo((byte[])hri.getEndKey(), (byte[])endKey) == 0) {
                Path p;
                FileSystem fs;
                Path rootDir;
                LOG.info((Object)("RegionName: " + hri.getRegionNameAsString()));
                byte[] deleteRow = hri.getRegionName();
                if (unassign) {
                    LOG.info((Object)("Undeploying region " + hri + " from server " + hsa));
                    this.undeployRegion(new HBaseAdmin(conf), hsa, new HRegionInfo(hri));
                }
                if (regionInfoOnly) {
                    LOG.info((Object)("deleting hdfs .regioninfo data: " + hri.toString() + hsa.toString()));
                    rootDir = new Path(conf.get("hbase.rootdir"));
                    fs = rootDir.getFileSystem(conf);
                    p = new Path(rootDir + "/" + htd.getNameAsString(), hri.getEncodedName());
                    Path hriPath = new Path(p, ".regioninfo");
                    fs.delete(hriPath, true);
                }
                if (hdfs) {
                    LOG.info((Object)("deleting hdfs data: " + hri.toString() + hsa.toString()));
                    rootDir = new Path(conf.get("hbase.rootdir"));
                    fs = rootDir.getFileSystem(conf);
                    p = new Path(rootDir + "/" + htd.getNameAsString(), hri.getEncodedName());
                    HBaseFsck.debugLsr((Configuration)conf, (Path)p);
                    boolean success = fs.delete(p, true);
                    LOG.info((Object)("Deleted " + p + " sucessfully? " + success));
                    HBaseFsck.debugLsr((Configuration)conf, (Path)p);
                }
                if (metaRow) {
                    HTable meta = new HTable(conf, HConstants.META_TABLE_NAME);
                    Delete delete = new Delete(deleteRow);
                    meta.delete(delete);
                }
            }
            LOG.info((Object)(hri.toString() + hsa.toString()));
        }
        TEST_UTIL.getMetaTableRows(htd.getName());
        LOG.info((Object)"*** After delete:");
        this.dumpMeta(htd.getName());
    }

    HTable setupTable(String tablename) throws Exception {
        HTableDescriptor desc = new HTableDescriptor(tablename);
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toString((byte[])FAM));
        desc.addFamily(hcd);
        TEST_UTIL.getHBaseAdmin().createTable(desc, SPLITS);
        this.tbl = new HTable(TEST_UTIL.getConfiguration(), tablename);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (byte[] row : ROWKEYS) {
            Put p = new Put(row);
            p.add(FAM, Bytes.toBytes((String)"val"), row);
            puts.add(p);
        }
        this.tbl.put(puts);
        this.tbl.flushCommits();
        long endTime = System.currentTimeMillis() + 60000L;
        while (!TEST_UTIL.getHBaseAdmin().isTableEnabled(tablename)) {
            try {
                if (System.currentTimeMillis() > endTime) {
                    Assert.fail((String)("Failed to enable table " + tablename + " after waiting for 60 sec"));
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Assert.fail((String)("Interrupted when waiting table " + tablename + " to be enabled"));
            }
        }
        return this.tbl;
    }

    int countRows() throws IOException {
        Scan s = new Scan();
        ResultScanner rs = this.tbl.getScanner(s);
        int i = 0;
        while (rs.next() != null) {
            ++i;
        }
        return i;
    }

    void deleteTable(String tablename) throws IOException {
        HBaseAdmin admin = new HBaseAdmin(conf);
        admin.getConnection().clearRegionCache();
        byte[] tbytes = Bytes.toBytes((String)tablename);
        admin.disableTableAsync(tbytes);
        while (!admin.isTableDisabled(tbytes)) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Assert.fail((String)("Interrupted when trying to disable table " + tablename));
            }
        }
        admin.deleteTable(tbytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHBaseFsckClean() throws Exception {
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        String table = "tableClean";
        try {
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck);
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck);
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHbckThreadpooling() throws Exception {
        String table = "tableDupeStartKey";
        try {
            this.setupTable(table);
            Configuration newconf = new Configuration(conf);
            newconf.setInt("hbasefsck.numthreads", 1);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(newconf, false));
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHbckFixOrphanTable() throws Exception {
        String table = "tableInfo";
        FileSystem fs = null;
        Path tableinfo = null;
        try {
            this.setupTable(table);
            HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
            Path hbaseTableDir = new Path(conf.get("hbase.rootdir") + "/" + table);
            fs = hbaseTableDir.getFileSystem(conf);
            FileStatus status = FSTableDescriptors.getTableInfoPath((FileSystem)fs, (Path)hbaseTableDir);
            tableinfo = status.getPath();
            fs.rename(tableinfo, new Path("/.tableinfo"));
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NO_TABLEINFO_FILE});
            hbck = HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(hbck);
            status = null;
            status = FSTableDescriptors.getTableInfoPath((FileSystem)fs, (Path)hbaseTableDir);
            Assert.assertNotNull((Object)status);
            HTableDescriptor htd = admin.getTableDescriptor(table.getBytes());
            htd.setValue("NOT_DEFAULT", "true");
            admin.disableTable(table);
            admin.modifyTable(table.getBytes(), htd);
            admin.enableTable(table);
            fs.delete(status.getPath(), true);
            htd = admin.getTableDescriptor(table.getBytes());
            hbck = HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(hbck);
            status = null;
            status = FSTableDescriptors.getTableInfoPath((FileSystem)fs, (Path)hbaseTableDir);
            Assert.assertNotNull((Object)status);
            htd = admin.getTableDescriptor(table.getBytes());
            Assert.assertEquals((Object)htd.getValue("NOT_DEFAULT"), (Object)"true");
        }
        catch (Throwable throwable) {
            fs.rename(new Path("/.tableinfo"), tableinfo);
            this.deleteTable(table);
            throw throwable;
        }
        fs.rename(new Path("/.tableinfo"), tableinfo);
        this.deleteTable(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDupeStartKey() throws Exception {
        String table = "tableDupeStartKey";
        try {
            this.setupTable(table);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HRegionInfo hriDupe = this.createRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"A2"));
            TEST_UTIL.getHBaseCluster().getMaster().assignRegion(hriDupe);
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hriDupe);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS});
            Assert.assertEquals((long)2L, (long)hbck.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HbckTestingUtil.doFsck(conf, true);
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck2);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.deleteTable(table);
        }
    }

    Map<ServerName, List<String>> getDeployedHRIs(HBaseAdmin admin) throws IOException {
        ClusterStatus status = admin.getMaster().getClusterStatus();
        Collection regionServers = status.getServers();
        HashMap<ServerName, List<String>> mm = new HashMap<ServerName, List<String>>();
        HConnection connection = admin.getConnection();
        for (ServerName hsi : regionServers) {
            HRegionInterface server = connection.getHRegionConnection(hsi.getHostname(), hsi.getPort());
            List regions = server.getOnlineRegions();
            ArrayList<String> regionNames = new ArrayList<String>();
            for (HRegionInfo hri : regions) {
                regionNames.add(hri.getRegionNameAsString());
            }
            mm.put(hsi, regionNames);
        }
        return mm;
    }

    ServerName findDeployedHSI(Map<ServerName, List<String>> mm, HRegionInfo hri) {
        for (Map.Entry<ServerName, List<String>> e : mm.entrySet()) {
            if (!e.getValue().contains(hri.getRegionNameAsString())) continue;
            return e.getKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDupeRegion() throws Exception {
        String table = "tableDupeRegion";
        try {
            this.setupTable(table);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HRegionInfo hriDupe = this.createRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"));
            TEST_UTIL.getHBaseCluster().getMaster().assignRegion(hriDupe);
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hriDupe);
            HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
            while (this.findDeployedHSI(this.getDeployedHRIs(admin), hriDupe) == null) {
                Thread.sleep(250L);
            }
            LOG.debug((Object)"Finished assignment of dupe region");
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS});
            Assert.assertEquals((long)2L, (long)hbck.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HbckTestingUtil.doFsck(conf, true);
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck2);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDegenerateRegions() throws Exception {
        String table = "tableDegenerateRegions";
        try {
            this.setupTable(table);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HRegionInfo hriDupe = this.createRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"B"));
            TEST_UTIL.getHBaseCluster().getMaster().assignRegion(hriDupe);
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hriDupe);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.DEGENERATE_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS});
            Assert.assertEquals((long)2L, (long)hbck.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HbckTestingUtil.doFsck(conf, true);
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck2);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainedRegionOverlap() throws Exception {
        String table = "tableContainedRegionOverlap";
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HRegionInfo hriOverlap = this.createRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A2"), Bytes.toBytes((String)"B"));
            TEST_UTIL.getHBaseCluster().getMaster().assignRegion(hriOverlap);
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hriOverlap);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN});
            Assert.assertEquals((long)2L, (long)hbck.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HbckTestingUtil.doFsck(conf, true);
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck2);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSidelineOverlapRegion() throws Exception {
        String table = "testSidelineOverlapRegion";
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
            HMaster master = cluster.getMaster();
            HRegionInfo hriOverlap1 = this.createRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"AB"));
            master.assignRegion(hriOverlap1);
            master.getAssignmentManager().waitForAssignment(hriOverlap1);
            HRegionInfo hriOverlap2 = this.createRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"AB"), Bytes.toBytes((String)"B"));
            master.assignRegion(hriOverlap2);
            master.getAssignmentManager().waitForAssignment(hriOverlap2);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN});
            Assert.assertEquals((long)3L, (long)hbck.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            Multimap overlapGroups = hbck.getOverlapGroups(table);
            ServerName serverName = null;
            byte[] regionName = null;
            for (HBaseFsck.HbckInfo hbi : overlapGroups.values()) {
                if (!"A".equals(Bytes.toString((byte[])hbi.getStartKey())) || !"B".equals(Bytes.toString((byte[])hbi.getEndKey()))) continue;
                regionName = hbi.getRegionName();
                int k = cluster.getServerWith(regionName);
                for (int i = 0; i < 3; ++i) {
                    if (i == k) continue;
                    HRegionServer rs = cluster.getRegionServer(i);
                    serverName = rs.getServerName();
                    break;
                }
                HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
                HBaseFsckRepair.closeRegionSilentlyAndWait((HBaseAdmin)admin, (ServerName)cluster.getRegionServer(k).getServerName(), (HRegionInfo)hbi.getHdfsHRI());
                admin.unassign(regionName, true);
                break;
            }
            Assert.assertNotNull(regionName);
            Assert.assertNotNull(serverName);
            HTable meta = new HTable(conf, HConstants.META_TABLE_NAME);
            Put put = new Put(regionName);
            put.add(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)serverName.getHostAndPort()));
            meta.put(put);
            HBaseFsck fsck = new HBaseFsck(conf);
            fsck.connect();
            fsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setFixAssignments(true);
            fsck.setFixMeta(true);
            fsck.setFixHdfsHoles(true);
            fsck.setFixHdfsOverlaps(true);
            fsck.setFixHdfsOrphans(true);
            fsck.setFixVersionFile(true);
            fsck.setSidelineBigOverlaps(true);
            fsck.setMaxMerge(2);
            fsck.onlineHbck();
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck2);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(table).size());
            Assert.assertTrue((ROWKEYS.length > this.countRows() ? 1 : 0) != 0);
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOverlapAndOrphan() throws Exception {
        String table = "tableOverlapAndOrphan";
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            TEST_UTIL.getHBaseAdmin().disableTable(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), true, true, false, true);
            TEST_UTIL.getHBaseAdmin().enableTable(table);
            HRegionInfo hriOverlap = this.createRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A2"), Bytes.toBytes((String)"B"));
            TEST_UTIL.getHBaseCluster().getMaster().assignRegion(hriOverlap);
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hriOverlap);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.ORPHAN_HDFS_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            HbckTestingUtil.doFsck(conf, true);
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck2);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoveredStartKey() throws Exception {
        String table = "tableCoveredStartKey";
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HRegionInfo hriOverlap = this.createRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A2"), Bytes.toBytes((String)"B2"));
            TEST_UTIL.getHBaseCluster().getMaster().assignRegion(hriOverlap);
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hriOverlap);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN, HBaseFsck.ErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN});
            Assert.assertEquals((long)3L, (long)hbck.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HbckTestingUtil.doFsck(conf, true);
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck2, new HBaseFsck.ErrorReporter.ERROR_CODE[0]);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionHole() throws Exception {
        String table = "tableRegionHole";
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            TEST_UTIL.getHBaseAdmin().disableTable(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), true, true, true);
            TEST_UTIL.getHBaseAdmin().enableTable(table);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)(ROWKEYS.length - 2), (long)this.countRows());
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHDFSRegioninfoMissing() throws Exception {
        String table = "tableHDFSRegioininfoMissing";
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            TEST_UTIL.getHBaseAdmin().disableTable(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), true, true, false, true);
            TEST_UTIL.getHBaseAdmin().enableTable(table);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.ORPHAN_HDFS_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotInMetaOrDeployedHole() throws Exception {
        String table = "tableNotInMetaOrDeployedHole";
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            TEST_UTIL.getHBaseAdmin().disableTable(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), true, true, false);
            TEST_UTIL.getHBaseAdmin().enableTable(table);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
            HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(conf, true), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotInMetaHole() throws Exception {
        String table = "tableNotInMetaHole";
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            TEST_UTIL.getHBaseAdmin().disableTable(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), false, true, false);
            TEST_UTIL.getHBaseAdmin().enableTable(table);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
            HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(conf, true), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotInHdfs() throws Exception {
        String table = "tableNotInHdfs";
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            TEST_UTIL.getHBaseAdmin().flush(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), false, false, true);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS});
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)(ROWKEYS.length - 2), (long)this.countRows());
        }
        finally {
            this.deleteTable(table);
        }
    }

    @Test
    public void testNoHdfsTable() throws Exception {
        String table = "NoHdfsTable";
        this.setupTable(table);
        Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        TEST_UTIL.getHBaseAdmin().flush(table);
        this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)""), Bytes.toBytes((String)"A"), false, false, true);
        this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), false, false, true);
        this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), false, false, true);
        this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"C"), Bytes.toBytes((String)""), false, false, true);
        HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS});
        Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
        HbckTestingUtil.doFsck(conf, true);
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        Assert.assertFalse((String)("Table " + table + " should have been deleted"), (boolean)TEST_UTIL.getHBaseAdmin().tableExists(table));
    }

    @Test
    public void testNoVersionFile() throws Exception {
        Path rootDir = new Path(conf.get("hbase.rootdir"));
        FileSystem fs = rootDir.getFileSystem(conf);
        Path versionFile = new Path(rootDir, "hbase.version");
        fs.delete(versionFile, true);
        HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NO_VERSION_FILE});
        HbckTestingUtil.doFsck(conf, true);
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionShouldNotBeDeployed() throws Exception {
        String table = "tableRegionShouldNotBeDeployed";
        try {
            RegionTransitionData rtd;
            LOG.info((Object)"Starting testRegionShouldNotBeDeployed.");
            MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
            Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
            ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(TEST_UTIL);
            FileSystem filesystem = FileSystem.get((Configuration)conf);
            Path rootdir = filesystem.makeQualified(new Path(conf.get("hbase.rootdir")));
            byte[][] SPLIT_KEYS = new byte[][]{new byte[0], Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd")};
            HTableDescriptor htdDisabled = new HTableDescriptor(Bytes.toBytes((String)table));
            htdDisabled.addFamily(new HColumnDescriptor(FAM));
            FSTableDescriptors.createTableDescriptor((FileSystem)filesystem, (Path)rootdir, (HTableDescriptor)htdDisabled);
            List<HRegionInfo> disabledRegions = TEST_UTIL.createMultiRegionsInMeta(TEST_UTIL.getConfiguration(), htdDisabled, SPLIT_KEYS);
            HRegionServer hrs = cluster.getRegionServer(0);
            ServerName serverName = hrs.getServerName();
            TEST_UTIL.getHBaseAdmin().disableTable(table);
            TEST_UTIL.getHBaseAdmin().enableTable(table);
            TEST_UTIL.getHBaseAdmin().disableTable(table);
            HRegionInfo region = disabledRegions.remove(0);
            ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)serverName);
            hrs.openRegion(region);
            int iTimes = 0;
            while ((rtd = ZKAssign.getData((ZooKeeperWatcher)zkw, (String)region.getEncodedName())) == null || rtd.getEventType() != EventHandler.EventType.RS_ZK_REGION_OPENED) {
                Thread.sleep(100L);
                if (++iTimes < 800) continue;
                break;
            }
            Assert.assertTrue((iTimes < 800 ? 1 : 0) != 0);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.SHOULD_NOT_BE_DEPLOYED});
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            TEST_UTIL.getHBaseAdmin().enableTable(table);
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFixByTable() throws Exception {
        String table1 = "testFixByTable1";
        String table2 = "testFixByTable2";
        try {
            this.setupTable(table1);
            TEST_UTIL.getHBaseAdmin().flush(table1);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), false, false, true);
            this.setupTable(table2);
            TEST_UTIL.getHBaseAdmin().flush(table2);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), false, false, true);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS});
            HbckTestingUtil.doFsck(conf, true, table1);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false, table1));
            HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(conf, false, table2), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS});
            HbckTestingUtil.doFsck(conf, true, table2);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)(ROWKEYS.length - 2), (long)this.countRows());
        }
        finally {
            this.deleteTable(table1);
            this.deleteTable(table2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLingeringSplitParent() throws Exception {
        String table = "testLingeringSplitParent";
        HTable meta = null;
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            TEST_UTIL.getHBaseAdmin().flush(table);
            HRegionLocation location = this.tbl.getRegionLocation("B");
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), true, true, false);
            meta = new HTable(conf, HTableDescriptor.META_TABLEDESC.getName());
            HRegionInfo hri = location.getRegionInfo();
            HRegionInfo a = new HRegionInfo(this.tbl.getTableName(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"BM"));
            HRegionInfo b = new HRegionInfo(this.tbl.getTableName(), Bytes.toBytes((String)"BM"), Bytes.toBytes((String)"C"));
            Put p = new Put(hri.getRegionName());
            hri.setOffline(true);
            hri.setSplit(true);
            p.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri));
            p.add(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER, Writables.getBytes((Writable)a));
            p.add(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER, Writables.getBytes((Writable)b));
            meta.put(p);
            meta.flushCommits();
            TEST_UTIL.getHBaseAdmin().flush(HConstants.META_TABLE_NAME);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LINGERING_SPLIT_PARENT, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            hbck = HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LINGERING_SPLIT_PARENT, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Assert.assertFalse((boolean)hbck.shouldRerun());
            hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LINGERING_SPLIT_PARENT, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            hbck = new HBaseFsck(conf);
            hbck.connect();
            hbck.setDisplayFullReport();
            hbck.setTimeLag(0L);
            hbck.setFixSplitParents(true);
            hbck.onlineHbck();
            Assert.assertTrue((boolean)hbck.shouldRerun());
            Get get = new Get(hri.getRegionName());
            Result result = meta.get(get);
            Assert.assertTrue((boolean)result.getColumn(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER).isEmpty());
            Assert.assertTrue((boolean)result.getColumn(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER).isEmpty());
            TEST_UTIL.getHBaseAdmin().flush(HConstants.META_TABLE_NAME);
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        catch (Throwable throwable) {
            this.deleteTable(table);
            IOUtils.closeQuietly(meta);
            throw throwable;
        }
        this.deleteTable(table);
        IOUtils.closeQuietly((Closeable)meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidLingeringSplitParent() throws Exception {
        String table = "testLingeringSplitParent";
        HTable meta = null;
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            TEST_UTIL.getHBaseAdmin().flush(table);
            HRegionLocation location = this.tbl.getRegionLocation("B");
            meta = new HTable(conf, HTableDescriptor.META_TABLEDESC.getName());
            HRegionInfo hri = location.getRegionInfo();
            HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
            byte[] regionName = location.getRegionInfo().getRegionName();
            admin.split(location.getRegionInfo().getRegionName(), Bytes.toBytes((String)"BM"));
            TestEndToEndSplitTransaction.blockUntilRegionSplit(TEST_UTIL.getConfiguration(), 60000L, regionName, true);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, true, true, false, false, false, true, true, true, null);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[0]);
            Get get = new Get(hri.getRegionName());
            Result result = meta.get(get);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull((Object)MetaReader.parseCatalogResult((Result)result).getFirst());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            Assert.assertEquals((long)this.tbl.getStartKeys().length, (long)(SPLITS.length + 1 + 1));
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        catch (Throwable throwable) {
            this.deleteTable(table);
            IOUtils.closeQuietly(meta);
            throw throwable;
        }
        this.deleteTable(table);
        IOUtils.closeQuietly((Closeable)meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitDaughtersNotInMeta() throws Exception {
        String table = "testSplitdaughtersNotInMeta";
        HTable meta = null;
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            TEST_UTIL.getHBaseAdmin().flush(table);
            HRegionLocation location = this.tbl.getRegionLocation("B");
            meta = new HTable(conf, HTableDescriptor.META_TABLEDESC.getName());
            HRegionInfo hri = location.getRegionInfo();
            HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
            byte[] regionName = location.getRegionInfo().getRegionName();
            admin.split(location.getRegionInfo().getRegionName(), Bytes.toBytes((String)"BM"));
            TestEndToEndSplitTransaction.blockUntilRegionSplit(TEST_UTIL.getConfiguration(), 60000L, regionName, true);
            PairOfSameType daughters = MetaReader.getDaughterRegions((Result)meta.get(new Get(regionName)));
            NavigableMap hris = this.tbl.getRegionLocations();
            this.undeployRegion(admin, (ServerName)hris.get(daughters.getFirst()), (HRegionInfo)daughters.getFirst());
            this.undeployRegion(admin, (ServerName)hris.get(daughters.getSecond()), (HRegionInfo)daughters.getSecond());
            meta.delete(new Delete(((HRegionInfo)daughters.getFirst()).getRegionName()));
            meta.delete(new Delete(((HRegionInfo)daughters.getSecond()).getRegionName()));
            meta.flushCommits();
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            hbck = HbckTestingUtil.doFsck(conf, true, true, false, false, false, false, false, false, null);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Get get = new Get(hri.getRegionName());
            Result result = meta.get(get);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull((Object)MetaReader.parseCatalogResult((Result)result).getFirst());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            Assert.assertEquals((long)this.tbl.getStartKeys().length, (long)(SPLITS.length + 1 + 1));
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        catch (Throwable throwable) {
            this.deleteTable(table);
            IOUtils.closeQuietly(meta);
            throw throwable;
        }
        this.deleteTable(table);
        IOUtils.closeQuietly((Closeable)meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingFirstRegion() throws Exception {
        String table = "testMissingFirstRegion";
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            TEST_UTIL.getHBaseAdmin().disableTable(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)""), Bytes.toBytes((String)"A"), true, true, true);
            TEST_UTIL.getHBaseAdmin().enableTable(table);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.FIRST_REGION_STARTKEY_NOT_EMPTY});
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingLastRegion() throws Exception {
        String table = "testMissingLastRegion";
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            TEST_UTIL.getHBaseAdmin().disableTable(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"C"), Bytes.toBytes((String)""), true, true, true);
            TEST_UTIL.getHBaseAdmin().enableTable(table);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LAST_REGION_ENDKEY_NOT_EMPTY});
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFixAssignmentsAndNoHdfsChecking() throws Exception {
        String table = "testFixAssignmentsAndNoHdfsChecking";
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), true, false, false, false);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            HBaseFsck fsck = new HBaseFsck(conf);
            fsck.connect();
            fsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setCheckHdfs(false);
            fsck.onlineHbck();
            HbckTestingUtil.assertErrors(fsck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            fsck = new HBaseFsck(conf);
            fsck.connect();
            fsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setCheckHdfs(false);
            fsck.setFixAssignments(true);
            fsck.onlineHbck();
            Assert.assertTrue((boolean)fsck.shouldRerun());
            fsck.onlineHbck();
            HbckTestingUtil.assertNoErrors(fsck);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFixMetaNotWorkingWithNoHdfsChecking() throws Exception {
        String table = "testFixMetaNotWorkingWithNoHdfsChecking";
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), false, true, false, false);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            HBaseFsck fsck = new HBaseFsck(conf);
            fsck.connect();
            fsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setCheckHdfs(false);
            fsck.onlineHbck();
            HbckTestingUtil.assertErrors(fsck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            fsck = new HBaseFsck(conf);
            fsck.connect();
            fsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setCheckHdfs(false);
            fsck.setFixAssignments(true);
            fsck.setFixMeta(true);
            fsck.onlineHbck();
            Assert.assertFalse((boolean)fsck.shouldRerun());
            HbckTestingUtil.assertErrors(fsck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFixHdfsHolesNotWorkingWithNoHdfsChecking() throws Exception {
        String table = "testFixHdfsHolesNotWorkingWithNoHdfsChecking";
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            TEST_UTIL.getHBaseAdmin().disableTable(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), true, true, false, true);
            TEST_UTIL.getHBaseAdmin().enableTable(table);
            HRegionInfo hriOverlap = this.createRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A2"), Bytes.toBytes((String)"B"));
            TEST_UTIL.getHBaseCluster().getMaster().assignRegion(hriOverlap);
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hriOverlap);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.ORPHAN_HDFS_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            HBaseFsck fsck = new HBaseFsck(conf);
            fsck.connect();
            fsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setCheckHdfs(false);
            fsck.onlineHbck();
            HbckTestingUtil.assertErrors(fsck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            fsck = new HBaseFsck(conf);
            fsck.connect();
            fsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setCheckHdfs(false);
            fsck.setFixHdfsHoles(true);
            fsck.setFixHdfsOverlaps(true);
            fsck.setFixHdfsOrphans(true);
            fsck.onlineHbck();
            Assert.assertFalse((boolean)fsck.shouldRerun());
            HbckTestingUtil.assertErrors(fsck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
        }
        finally {
            if (TEST_UTIL.getHBaseAdmin().isTableDisabled(table)) {
                TEST_UTIL.getHBaseAdmin().enableTable(table);
            }
            this.deleteTable(table);
        }
    }

    /*
     * Unable to fully structure code
     */
    Path getFlushedHFile(FileSystem fs, String table) throws IOException {
        tableDir = FSUtils.getTablePath((Path)FSUtils.getRootDir((Configuration)TestHBaseFsck.conf), (String)table);
        regionDir = (Path)FSUtils.getRegionDirs((FileSystem)fs, (Path)tableDir).get(0);
        famDir = new Path(regionDir, "fam");
        block0: while (true) {
            if ((hfFss = fs.listStatus(famDir)).length == 0) {
                continue;
            }
            arr$ = hfFss;
            len$ = arr$.length;
            i$ = 0;
            while (true) {
                if (i$ < len$) ** break;
                continue block0;
                hfs = arr$[i$];
                if (!hfs.isDir()) {
                    return hfs.getPath();
                }
                ++i$;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testQuarantineCorruptHFile() throws Exception {
        String table = this.name.getMethodName();
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            TEST_UTIL.getHBaseAdmin().flush(table);
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path hfile = this.getFlushedHFile(fs, table);
            TEST_UTIL.getHBaseAdmin().disableTable(table);
            Path corrupt = new Path(hfile.getParent(), "deadbeef");
            TestHFile.truncateFile(fs, hfile, corrupt);
            LOG.info((Object)("Created corrupted file " + corrupt));
            HBaseFsck.debugLsr((Configuration)conf, (Path)FSUtils.getRootDir((Configuration)conf));
            HBaseFsck res = HbckTestingUtil.doHFileQuarantine(conf, table);
            Assert.assertEquals((long)res.getRetCode(), (long)0L);
            HFileCorruptionChecker hfcc = res.getHFilecorruptionChecker();
            Assert.assertEquals((long)hfcc.getHFilesChecked(), (long)5L);
            Assert.assertEquals((long)hfcc.getCorrupted().size(), (long)1L);
            Assert.assertEquals((long)hfcc.getFailures().size(), (long)0L);
            Assert.assertEquals((long)hfcc.getQuarantined().size(), (long)1L);
            Assert.assertEquals((long)hfcc.getMissing().size(), (long)0L);
            TEST_UTIL.getHBaseAdmin().enableTable(table);
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQuarantineTest(String table, HBaseFsck hbck, int check, int corrupt, int fail, int quar, int missing) throws Exception {
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            TEST_UTIL.getHBaseAdmin().flush(table);
            TEST_UTIL.getHBaseAdmin().disableTable(table);
            String[] args = new String[]{"-sidelineCorruptHFiles", "-repairHoles", "-ignorePreCheckPermission", table};
            ScheduledThreadPoolExecutor exec = new ScheduledThreadPoolExecutor(10);
            HBaseFsck res = hbck.exec((ExecutorService)exec, args);
            HFileCorruptionChecker hfcc = res.getHFilecorruptionChecker();
            Assert.assertEquals((long)hfcc.getHFilesChecked(), (long)check);
            Assert.assertEquals((long)hfcc.getCorrupted().size(), (long)corrupt);
            Assert.assertEquals((long)hfcc.getFailures().size(), (long)fail);
            Assert.assertEquals((long)hfcc.getQuarantined().size(), (long)quar);
            Assert.assertEquals((long)hfcc.getMissing().size(), (long)missing);
            HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
            admin.enableTableAsync(table);
            while (!admin.isTableEnabled(table)) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Assert.fail((String)("Interrupted when trying to enable table " + table));
                }
            }
        }
        finally {
            this.deleteTable(table);
        }
    }

    @Test(timeout=120000L)
    public void testQuarantineMissingHFile() throws Exception {
        String table = this.name.getMethodName();
        ScheduledThreadPoolExecutor exec = new ScheduledThreadPoolExecutor(10);
        final FileSystem fs = FileSystem.get((Configuration)conf);
        HBaseFsck hbck = new HBaseFsck(conf, exec){

            public HFileCorruptionChecker createHFileCorruptionChecker(boolean sidelineCorruptHFiles) throws IOException {
                return new HFileCorruptionChecker(conf, this.executor, sidelineCorruptHFiles){
                    boolean attemptedFirstHFile;
                    {
                        this.attemptedFirstHFile = false;
                    }

                    protected void checkHFile(Path p) throws IOException {
                        if (!this.attemptedFirstHFile) {
                            this.attemptedFirstHFile = true;
                            Assert.assertTrue((boolean)fs.delete(p, true));
                        }
                        super.checkHFile(p);
                    }
                };
            }
        };
        this.doQuarantineTest(table, hbck, 4, 0, 0, 0, 1);
    }

    @Test(timeout=120000L)
    public void testQuarantineMissingFamdir() throws Exception {
        String table = this.name.getMethodName();
        ScheduledThreadPoolExecutor exec = new ScheduledThreadPoolExecutor(10);
        final FileSystem fs = FileSystem.get((Configuration)conf);
        HBaseFsck hbck = new HBaseFsck(conf, exec){

            public HFileCorruptionChecker createHFileCorruptionChecker(boolean sidelineCorruptHFiles) throws IOException {
                return new HFileCorruptionChecker(conf, this.executor, sidelineCorruptHFiles){
                    boolean attemptedFirstFamDir;
                    {
                        this.attemptedFirstFamDir = false;
                    }

                    protected void checkColFamDir(Path p) throws IOException {
                        if (!this.attemptedFirstFamDir) {
                            this.attemptedFirstFamDir = true;
                            Assert.assertTrue((boolean)fs.delete(p, true));
                        }
                        super.checkColFamDir(p);
                    }
                };
            }
        };
        this.doQuarantineTest(table, hbck, 3, 0, 0, 0, 1);
    }

    @Test(timeout=120000L)
    public void testQuarantineMissingRegionDir() throws Exception {
        String table = this.name.getMethodName();
        ScheduledThreadPoolExecutor exec = new ScheduledThreadPoolExecutor(10);
        final FileSystem fs = FileSystem.get((Configuration)conf);
        HBaseFsck hbck = new HBaseFsck(conf, exec){

            public HFileCorruptionChecker createHFileCorruptionChecker(boolean sidelineCorruptHFiles) throws IOException {
                return new HFileCorruptionChecker(conf, this.executor, sidelineCorruptHFiles){
                    boolean attemptedFirstRegionDir;
                    {
                        this.attemptedFirstRegionDir = false;
                    }

                    protected void checkRegionDir(Path p) throws IOException {
                        if (!this.attemptedFirstRegionDir) {
                            this.attemptedFirstRegionDir = true;
                            Assert.assertTrue((boolean)fs.delete(p, true));
                        }
                        super.checkRegionDir(p);
                    }
                };
            }
        };
        this.doQuarantineTest(table, hbck, 3, 0, 0, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLingeringReferenceFile() throws Exception {
        String table = "testLingeringReferenceFile";
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path tableDir = FSUtils.getTablePath((Path)FSUtils.getRootDir((Configuration)conf), (String)table);
            Path regionDir = (Path)FSUtils.getRegionDirs((FileSystem)fs, (Path)tableDir).get(0);
            Path famDir = new Path(regionDir, FAM_STR);
            Path fakeReferenceFile = new Path(famDir, "fbce357483ceea.12144538");
            fs.create(fakeReferenceFile);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LINGERING_REFERENCE_HFILE});
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testErrorReporter() throws Exception {
        try {
            MockErrorReporter.calledCount = 0;
            HbckTestingUtil.doFsck(conf, false);
            Assert.assertEquals((long)MockErrorReporter.calledCount, (long)0L);
            conf.set("hbasefsck.errorreporter", MockErrorReporter.class.getName());
            HbckTestingUtil.doFsck(conf, false);
            Assert.assertTrue((MockErrorReporter.calledCount > 20 ? 1 : 0) != 0);
        }
        finally {
            conf.set("hbasefsck.errorreporter", HBaseFsck.PrintingErrorReporter.class.getName());
            MockErrorReporter.calledCount = 0;
        }
    }

    static class MockErrorReporter
    implements HBaseFsck.ErrorReporter {
        static int calledCount = 0;

        MockErrorReporter() {
        }

        public void clear() {
            ++calledCount;
        }

        public void report(String message) {
            ++calledCount;
        }

        public void reportError(String message) {
            ++calledCount;
        }

        public void reportError(HBaseFsck.ErrorReporter.ERROR_CODE errorCode, String message) {
            ++calledCount;
        }

        public void reportError(HBaseFsck.ErrorReporter.ERROR_CODE errorCode, String message, HBaseFsck.TableInfo table) {
            ++calledCount;
        }

        public void reportError(HBaseFsck.ErrorReporter.ERROR_CODE errorCode, String message, HBaseFsck.TableInfo table, HBaseFsck.HbckInfo info) {
            ++calledCount;
        }

        public void reportError(HBaseFsck.ErrorReporter.ERROR_CODE errorCode, String message, HBaseFsck.TableInfo table, HBaseFsck.HbckInfo info1, HBaseFsck.HbckInfo info2) {
            ++calledCount;
        }

        public int summarize() {
            return ++calledCount;
        }

        public void detail(String details) {
            ++calledCount;
        }

        public ArrayList<HBaseFsck.ErrorReporter.ERROR_CODE> getErrorList() {
            ++calledCount;
            return new ArrayList<HBaseFsck.ErrorReporter.ERROR_CODE>();
        }

        public void progress() {
            ++calledCount;
        }

        public void print(String message) {
            ++calledCount;
        }

        public void resetErrors() {
            ++calledCount;
        }

        public boolean tableHasErrors(HBaseFsck.TableInfo table) {
            ++calledCount;
            return false;
        }
    }
}

