/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.KeyRange;
import org.apache.hadoop.hbase.util.RegionSplitCalculator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRegionSplitCalculator {
    private static final Log LOG = LogFactory.getLog(TestRegionSplitCalculator.class);
    Comparator<SimpleRange> cmp = new Comparator<SimpleRange>(){

        @Override
        public int compare(SimpleRange sr1, SimpleRange sr2) {
            ComparisonChain cc = ComparisonChain.start();
            cc = cc.compare((Object)sr1.getStartKey(), (Object)sr2.getStartKey(), Bytes.BYTES_COMPARATOR);
            cc = cc.compare((Object)sr1.getEndKey(), (Object)sr2.getEndKey(), RegionSplitCalculator.BYTES_COMPARATOR);
            cc = cc.compare((Comparable)sr1.tiebreaker, (Comparable)sr2.tiebreaker);
            return cc.result();
        }
    };
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    void checkDepths(SortedSet<byte[]> splits, Multimap<byte[], SimpleRange> regions, Integer ... depths) {
        Assert.assertEquals((long)splits.size(), (long)depths.length);
        int i = 0;
        for (byte[] k : splits) {
            Collection rs = regions.get((Object)k);
            int sz = rs == null ? 0 : rs.size();
            Assert.assertEquals((long)depths[i].intValue(), (long)sz);
            ++i;
        }
    }

    String dump(SortedSet<byte[]> splits, Multimap<byte[], SimpleRange> regions) {
        StringBuilder sb = new StringBuilder();
        for (byte[] k : splits) {
            sb.append(Bytes.toString((byte[])k)).append(":\t");
            for (SimpleRange r : regions.get((Object)k)) {
                sb.append(r.toString()).append("\t");
            }
            sb.append("\n");
        }
        String s = sb.toString();
        LOG.info((Object)("\n" + s));
        return s;
    }

    @Test
    public void testSplitCalculator() {
        SimpleRange a = new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"));
        SimpleRange b = new SimpleRange(Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"));
        SimpleRange c = new SimpleRange(Bytes.toBytes((String)"C"), Bytes.toBytes((String)"D"));
        RegionSplitCalculator sc = new RegionSplitCalculator(this.cmp);
        sc.add((KeyRange)a);
        sc.add((KeyRange)b);
        sc.add((KeyRange)c);
        Multimap regions = sc.calcCoverage();
        LOG.info((Object)"Standard");
        String res = this.dump(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions);
        this.checkDepths(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions, 1, 1, 1, 0);
        Assert.assertEquals((Object)res, (Object)"A:\t[A, B]\t\nB:\t[B, C]\t\nC:\t[C, D]\t\nD:\t\n");
    }

    @Test
    public void testSplitCalculatorNoEdge() {
        RegionSplitCalculator sc = new RegionSplitCalculator(this.cmp);
        Multimap regions = sc.calcCoverage();
        LOG.info((Object)"Empty");
        String res = this.dump(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions);
        this.checkDepths(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions, new Integer[0]);
        Assert.assertEquals((Object)"", (Object)res);
    }

    @Test
    public void testSplitCalculatorSingleEdge() {
        SimpleRange a = new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"));
        RegionSplitCalculator sc = new RegionSplitCalculator(this.cmp);
        sc.add((KeyRange)a);
        Multimap regions = sc.calcCoverage();
        LOG.info((Object)"Single edge");
        String res = this.dump(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions);
        this.checkDepths(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions, 1, 0);
        Assert.assertEquals((Object)"A:\t[A, B]\t\nB:\t\n", (Object)res);
    }

    @Test
    public void testSplitCalculatorDegenerateEdge() {
        SimpleRange a = new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"A"));
        RegionSplitCalculator sc = new RegionSplitCalculator(this.cmp);
        sc.add((KeyRange)a);
        Multimap regions = sc.calcCoverage();
        LOG.info((Object)"Single empty edge");
        String res = this.dump(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions);
        this.checkDepths(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions, 1);
        Assert.assertEquals((Object)"A:\t[A, A]\t\n", (Object)res);
    }

    @Test
    public void testSplitCalculatorCoverSplit() {
        SimpleRange a = new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"));
        SimpleRange b = new SimpleRange(Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"));
        SimpleRange c = new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"C"));
        RegionSplitCalculator sc = new RegionSplitCalculator(this.cmp);
        sc.add((KeyRange)a);
        sc.add((KeyRange)b);
        sc.add((KeyRange)c);
        Multimap regions = sc.calcCoverage();
        LOG.info((Object)"AC covers AB, BC");
        String res = this.dump(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions);
        this.checkDepths(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions, 2, 2, 0);
        Assert.assertEquals((Object)"A:\t[A, B]\t[A, C]\t\nB:\t[A, C]\t[B, C]\t\nC:\t\n", (Object)res);
    }

    @Test
    public void testSplitCalculatorOverEndpoint() {
        SimpleRange a = new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"));
        SimpleRange b = new SimpleRange(Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"));
        SimpleRange c = new SimpleRange(Bytes.toBytes((String)"B"), Bytes.toBytes((String)"D"));
        RegionSplitCalculator sc = new RegionSplitCalculator(this.cmp);
        sc.add((KeyRange)a);
        sc.add((KeyRange)b);
        sc.add((KeyRange)c);
        Multimap regions = sc.calcCoverage();
        LOG.info((Object)"AB, BD covers BC");
        String res = this.dump(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions);
        this.checkDepths(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions, 1, 2, 1, 0);
        Assert.assertEquals((Object)"A:\t[A, B]\t\nB:\t[B, C]\t[B, D]\t\nC:\t[B, D]\t\nD:\t\n", (Object)res);
    }

    @Test
    public void testSplitCalculatorHoles() {
        SimpleRange a = new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"));
        SimpleRange b = new SimpleRange(Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"));
        SimpleRange c = new SimpleRange(Bytes.toBytes((String)"E"), Bytes.toBytes((String)"F"));
        RegionSplitCalculator sc = new RegionSplitCalculator(this.cmp);
        sc.add((KeyRange)a);
        sc.add((KeyRange)b);
        sc.add((KeyRange)c);
        Multimap regions = sc.calcCoverage();
        LOG.info((Object)"Hole between C and E");
        String res = this.dump(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions);
        this.checkDepths(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions, 1, 1, 0, 1, 0);
        Assert.assertEquals((Object)"A:\t[A, B]\t\nB:\t[B, C]\t\nC:\t\nE:\t[E, F]\t\nF:\t\n", (Object)res);
    }

    @Test
    public void testSplitCalculatorOverreach() {
        SimpleRange a = new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"C"));
        SimpleRange b = new SimpleRange(Bytes.toBytes((String)"B"), Bytes.toBytes((String)"D"));
        RegionSplitCalculator sc = new RegionSplitCalculator(this.cmp);
        sc.add((KeyRange)a);
        sc.add((KeyRange)b);
        Multimap regions = sc.calcCoverage();
        LOG.info((Object)"AC and BD overlap but share no start/end keys");
        String res = this.dump(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions);
        this.checkDepths(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions, 1, 2, 1, 0);
        Assert.assertEquals((Object)"A:\t[A, C]\t\nB:\t[A, C]\t[B, D]\t\nC:\t[B, D]\t\nD:\t\n", (Object)res);
    }

    @Test
    public void testSplitCalculatorFloor() {
        SimpleRange a = new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"C"));
        SimpleRange b = new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"));
        RegionSplitCalculator sc = new RegionSplitCalculator(this.cmp);
        sc.add((KeyRange)a);
        sc.add((KeyRange)b);
        Multimap regions = sc.calcCoverage();
        LOG.info((Object)"AC and AB overlap in the beginning");
        String res = this.dump(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions);
        this.checkDepths(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions, 2, 1, 0);
        Assert.assertEquals((Object)"A:\t[A, B]\t[A, C]\t\nB:\t[A, C]\t\nC:\t\n", (Object)res);
    }

    @Test
    public void testSplitCalculatorCeil() {
        SimpleRange a = new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"C"));
        SimpleRange b = new SimpleRange(Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"));
        RegionSplitCalculator sc = new RegionSplitCalculator(this.cmp);
        sc.add((KeyRange)a);
        sc.add((KeyRange)b);
        Multimap regions = sc.calcCoverage();
        LOG.info((Object)"AC and BC overlap in the end");
        String res = this.dump(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions);
        this.checkDepths(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions, 1, 2, 0);
        Assert.assertEquals((Object)"A:\t[A, C]\t\nB:\t[A, C]\t[B, C]\t\nC:\t\n", (Object)res);
    }

    @Test
    public void testSplitCalculatorEq() {
        SimpleRange a = new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"C"));
        SimpleRange b = new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"C"));
        LOG.info((Object)(a.tiebreaker + " - " + b.tiebreaker));
        RegionSplitCalculator sc = new RegionSplitCalculator(this.cmp);
        sc.add((KeyRange)a);
        sc.add((KeyRange)b);
        Multimap regions = sc.calcCoverage();
        LOG.info((Object)"AC and AC overlap completely");
        String res = this.dump(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions);
        this.checkDepths(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions, 2, 0);
        Assert.assertEquals((Object)"A:\t[A, C]\t[A, C]\t\nC:\t\n", (Object)res);
    }

    @Test
    public void testSplitCalculatorBackwards() {
        SimpleRange a = new SimpleRange(Bytes.toBytes((String)"C"), Bytes.toBytes((String)"A"));
        RegionSplitCalculator sc = new RegionSplitCalculator(this.cmp);
        sc.add((KeyRange)a);
        Multimap regions = sc.calcCoverage();
        LOG.info((Object)"CA is backwards");
        String res = this.dump(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions);
        this.checkDepths(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions, new Integer[0]);
        Assert.assertEquals((Object)"", (Object)res);
    }

    @Test
    public void testComplex() {
        RegionSplitCalculator sc = new RegionSplitCalculator(this.cmp);
        sc.add((KeyRange)new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Am")));
        sc.add((KeyRange)new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"C")));
        sc.add((KeyRange)new SimpleRange(Bytes.toBytes((String)"Am"), Bytes.toBytes((String)"C")));
        sc.add((KeyRange)new SimpleRange(Bytes.toBytes((String)"D"), Bytes.toBytes((String)"E")));
        sc.add((KeyRange)new SimpleRange(Bytes.toBytes((String)"F"), Bytes.toBytes((String)"G")));
        sc.add((KeyRange)new SimpleRange(Bytes.toBytes((String)"B"), Bytes.toBytes((String)"E")));
        sc.add((KeyRange)new SimpleRange(Bytes.toBytes((String)"H"), Bytes.toBytes((String)"I")));
        sc.add((KeyRange)new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B")));
        Multimap regions = sc.calcCoverage();
        LOG.info((Object)"Something fairly complex");
        String res = this.dump(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions);
        this.checkDepths(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions, 3, 3, 3, 1, 2, 0, 1, 0, 1, 0);
        Assert.assertEquals((Object)"A:\t[A, Am]\t[A, B]\t[A, C]\t\nAm:\t[A, B]\t[A, C]\t[Am, C]\t\nB:\t[A, C]\t[Am, C]\t[B, E]\t\nC:\t[B, E]\t\nD:\t[B, E]\t[D, E]\t\nE:\t\nF:\t[F, G]\t\nG:\t\nH:\t[H, I]\t\nI:\t\n", (Object)res);
    }

    @Test
    public void testBeginEndMarker() {
        RegionSplitCalculator sc = new RegionSplitCalculator(this.cmp);
        sc.add((KeyRange)new SimpleRange(Bytes.toBytes((String)""), Bytes.toBytes((String)"A")));
        sc.add((KeyRange)new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B")));
        sc.add((KeyRange)new SimpleRange(Bytes.toBytes((String)"B"), Bytes.toBytes((String)"")));
        Multimap regions = sc.calcCoverage();
        LOG.info((Object)"Special cases -- empty");
        String res = this.dump(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions);
        this.checkDepths(sc.getSplits(), (Multimap<byte[], SimpleRange>)regions, 1, 1, 1, 0);
        Assert.assertEquals((Object)":\t[, A]\t\nA:\t[A, B]\t\nB:\t[B, ]\t\nnull:\t\n", (Object)res);
    }

    @Test
    public void testBigRanges() {
        SimpleRange ai = new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"I"));
        SimpleRange ae = new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"E"));
        SimpleRange ac = new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"C"));
        ArrayList<SimpleRange> bigOverlap = new ArrayList<SimpleRange>();
        bigOverlap.add(new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"E")));
        bigOverlap.add(new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"C")));
        bigOverlap.add(new SimpleRange(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B")));
        bigOverlap.add(new SimpleRange(Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C")));
        bigOverlap.add(new SimpleRange(Bytes.toBytes((String)"E"), Bytes.toBytes((String)"H")));
        bigOverlap.add(ai);
        bigOverlap.add(ae);
        bigOverlap.add(ac);
        List bigRanges = RegionSplitCalculator.findBigRanges(bigOverlap, (int)1);
        Assert.assertEquals((long)1L, (long)bigRanges.size());
        Assert.assertEquals((Object)ai, bigRanges.get(0));
        bigRanges = RegionSplitCalculator.findBigRanges(bigOverlap, (int)3);
        Assert.assertEquals((long)3L, (long)bigRanges.size());
        Assert.assertEquals((Object)ai, bigRanges.get(0));
        SimpleRange r1 = (SimpleRange)bigRanges.get(1);
        SimpleRange r2 = (SimpleRange)bigRanges.get(2);
        Assert.assertEquals((Object)"A", (Object)Bytes.toString((byte[])r1.start));
        Assert.assertEquals((Object)"A", (Object)Bytes.toString((byte[])r2.start));
        String r1e = Bytes.toString((byte[])r1.end);
        String r2e = Bytes.toString((byte[])r2.end);
        Assert.assertTrue((r1e.equals("C") && r2e.equals("E") || r1e.equals("E") && r2e.equals("C") ? 1 : 0) != 0);
    }

    static class SimpleRange
    implements KeyRange {
        byte[] start;
        byte[] end;
        UUID tiebreaker;

        SimpleRange(byte[] start, byte[] end) {
            this.start = start;
            this.end = end;
            this.tiebreaker = UUID.randomUUID();
        }

        public byte[] getStartKey() {
            return this.start;
        }

        public byte[] getEndKey() {
            return this.end;
        }

        public String toString() {
            return "[" + Bytes.toString((byte[])this.start) + ", " + Bytes.toString((byte[])this.end) + "]";
        }
    }
}

