/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.util.SizeBasedThrottler;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSizeBasedThrottler {
    private static final int REPEATS = 100;

    private Thread makeThread(final SizeBasedThrottler throttler, final AtomicBoolean failed, final int delta, final int limit, final CountDownLatch latch) {
        Thread ret = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    latch.await();
                    if (throttler.increase((long)delta) > (long)limit) {
                        failed.set(true);
                    }
                    throttler.decrease((long)delta);
                }
                catch (Exception e) {
                    failed.set(true);
                }
            }
        });
        ret.start();
        return ret;
    }

    private void runGenericTest(int threshold, int delta, int maxValueAllowed, int numberOfThreads, long timeout) {
        SizeBasedThrottler throttler = new SizeBasedThrottler((long)threshold);
        AtomicBoolean failed = new AtomicBoolean(false);
        ArrayList<Thread> threads = new ArrayList<Thread>(numberOfThreads);
        CountDownLatch latch = new CountDownLatch(1);
        long timeElapsed = 0L;
        for (int i = 0; i < numberOfThreads; ++i) {
            threads.add(this.makeThread(throttler, failed, delta, maxValueAllowed, latch));
        }
        latch.countDown();
        for (Thread t : threads) {
            try {
                long beforeJoin = System.currentTimeMillis();
                t.join(timeout - timeElapsed);
                if (!t.isAlive() && (timeElapsed += System.currentTimeMillis() - beforeJoin) < timeout) continue;
                Assert.fail((String)"Timeout reached.");
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Got InterruptedException");
            }
        }
        Assert.assertFalse((boolean)failed.get());
    }

    @Test
    public void testSmallIncreases() {
        for (int i = 0; i < 100; ++i) {
            this.runGenericTest(10, 1, 15, 1000, 500L);
        }
    }

    @Test
    public void testBigIncreases() {
        for (int i = 0; i < 100; ++i) {
            this.runGenericTest(1, 2, 4, 1000, 500L);
        }
    }

    @Test
    public void testIncreasesEqualToThreshold() {
        for (int i = 0; i < 100; ++i) {
            this.runGenericTest(1, 1, 2, 1000, 500L);
        }
    }
}

