/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import org.apache.hadoop.hive.common.type.HiveBaseChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ParameterizedPrimitiveTypeUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeParams;

public class JavaHiveVarcharObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableHiveVarcharObjectInspector {
    public JavaHiveVarcharObjectInspector(PrimitiveObjectInspectorUtils.PrimitiveTypeEntry typeEntry) {
        super(typeEntry);
        if (typeEntry.primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.VARCHAR) {
            throw new RuntimeException("TypeEntry of type varchar expected, got " + (Object)((Object)typeEntry.primitiveCategory));
        }
    }

    @Override
    public HiveVarchar getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        HiveVarchar value = (HiveVarchar)o;
        if (ParameterizedPrimitiveTypeUtils.doesPrimitiveMatchTypeParams(value, (VarcharTypeParams)this.typeParams)) {
            return value;
        }
        return this.getPrimitiveWithParams(value);
    }

    @Override
    public HiveVarcharWritable getPrimitiveWritableObject(Object o) {
        if (o == null) {
            return null;
        }
        return this.getWritableWithParams((HiveVarchar)o);
    }

    private HiveVarchar getPrimitiveWithParams(HiveVarchar val) {
        HiveVarchar hv = new HiveVarchar(val, this.getMaxLength());
        return hv;
    }

    private HiveVarcharWritable getWritableWithParams(HiveVarchar val) {
        HiveVarcharWritable newValue = new HiveVarcharWritable();
        newValue.set(val, this.getMaxLength());
        return newValue;
    }

    @Override
    public Object set(Object o, HiveVarchar value) {
        HiveVarchar setValue = (HiveVarchar)o;
        if (ParameterizedPrimitiveTypeUtils.doesPrimitiveMatchTypeParams(value, (VarcharTypeParams)this.typeParams)) {
            setValue.setValue(value);
        } else {
            setValue.setValue((HiveBaseChar)value, this.getMaxLength());
        }
        return setValue;
    }

    @Override
    public Object set(Object o, String value) {
        HiveVarchar convertedValue = (HiveVarchar)o;
        convertedValue.setValue(value, this.getMaxLength());
        return convertedValue;
    }

    @Override
    public Object create(HiveVarchar value) {
        HiveVarchar hc = new HiveVarchar(value, this.getMaxLength());
        return hc;
    }

    public int getMaxLength() {
        return this.typeParams != null ? ((VarcharTypeParams)this.typeParams).length : -1;
    }
}

