/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.ExecuteException;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.BadParam;
import org.apache.hive.hcatalog.templeton.BusyException;
import org.apache.hive.hcatalog.templeton.EnqueueBean;
import org.apache.hive.hcatalog.templeton.LauncherDelegator;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.apache.hive.hcatalog.templeton.QueueException;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;

public class JarDelegator
extends LauncherDelegator {
    public JarDelegator(AppConfig appConf) {
        super(appConf);
    }

    public EnqueueBean run(String user, Map<String, Object> userArgs, String jar, String mainClass, String libjars, String files, List<String> jarArgs, List<String> defines, String statusdir, String callback, String completedUrl, boolean enablelog, LauncherDelegator.JobType jobType) throws NotAuthorizedException, BadParam, BusyException, QueueException, ExecuteException, IOException, InterruptedException {
        this.runAs = user;
        List<String> args = this.makeArgs(jar, mainClass, libjars, files, jarArgs, defines, statusdir, completedUrl, enablelog, jobType);
        return this.enqueueController(user, userArgs, callback, args);
    }

    private List<String> makeArgs(String jar, String mainClass, String libjars, String files, List<String> jarArgs, List<String> defines, String statusdir, String completedUrl, boolean enablelog, LauncherDelegator.JobType jobType) throws BadParam, IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        try {
            ArrayList<String> allFiles = new ArrayList<String>();
            allFiles.add(TempletonUtils.hadoopFsFilename(jar, this.appConf, this.runAs));
            args.addAll(this.makeLauncherArgs(this.appConf, statusdir, completedUrl, allFiles, enablelog, jobType));
            args.add("--");
            TempletonUtils.addCmdForWindows(args);
            args.add(this.appConf.clusterHadoop());
            args.add("jar");
            args.add(TempletonUtils.hadoopFsPath(jar, this.appConf, this.runAs).getName());
            if (TempletonUtils.isset(mainClass)) {
                args.add(mainClass);
            }
            if (TempletonUtils.isset(libjars)) {
                String libjarsListAsString = TempletonUtils.hadoopFsListAsString(libjars, this.appConf, this.runAs);
                args.add("-libjars");
                args.add(TempletonUtils.quoteForWindows(libjarsListAsString));
            }
            if (TempletonUtils.isset(files)) {
                String filesListAsString = TempletonUtils.hadoopFsListAsString(files, this.appConf, this.runAs);
                args.add("-files");
                args.add(TempletonUtils.quoteForWindows(filesListAsString));
            }
            args.add("-D__WEBHCAT_TOKEN_FILE_LOCATION__");
            for (String d : defines) {
                args.add("-D");
                TempletonUtils.quoteForWindows(d);
            }
            for (String arg : jarArgs) {
                args.add(TempletonUtils.quoteForWindows(arg));
            }
        }
        catch (FileNotFoundException e) {
            throw new BadParam(e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new BadParam(e.getMessage());
        }
        return args;
    }
}

