/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton.tool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hive.hcatalog.templeton.tool.ZooKeeperStorage;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class JobStateTracker {
    private String job_trackingroot = null;
    private ZooKeeper zk;
    private String trackingnode;
    private String jobid;
    private static final Log LOG = LogFactory.getLog(JobStateTracker.class);

    public JobStateTracker(String node, ZooKeeper zk, boolean nodeIsTracker, String job_trackingpath) {
        this.zk = zk;
        if (nodeIsTracker) {
            this.trackingnode = node;
        } else {
            this.jobid = node;
        }
        this.job_trackingroot = job_trackingpath;
    }

    public void create() throws IOException {
        String[] paths;
        for (String znode : paths = ZooKeeperStorage.getPaths(this.job_trackingroot)) {
            try {
                this.zk.create(znode, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException e) {
            }
            catch (Exception e) {
                throw new IOException("Unable to create parent nodes");
            }
        }
        try {
            this.trackingnode = this.zk.create(this.makeTrackingZnode(), this.jobid.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
        }
        catch (Exception e) {
            throw new IOException("Unable to create " + this.makeTrackingZnode());
        }
    }

    public void delete() throws IOException {
        try {
            this.zk.delete(this.makeTrackingJobZnode(this.trackingnode), -1);
        }
        catch (Exception e) {
            LOG.info((Object)("Couldn't delete " + this.makeTrackingJobZnode(this.trackingnode)));
        }
    }

    public String getJobID() throws IOException {
        try {
            return new String(this.zk.getData(this.makeTrackingJobZnode(this.trackingnode), false, new Stat()));
        }
        catch (KeeperException e) {
            throw new IOException("Node already deleted " + this.trackingnode);
        }
        catch (InterruptedException e) {
            throw new IOException("Couldn't read node " + this.trackingnode);
        }
    }

    public String makeTrackingZnode() {
        return this.job_trackingroot + "/";
    }

    public String makeTrackingJobZnode(String nodename) {
        return this.job_trackingroot + "/" + nodename;
    }

    public static List<String> getTrackingJobs(Configuration conf, ZooKeeper zk) throws IOException {
        ArrayList<String> jobs = new ArrayList<String>();
        try {
            for (String myid : zk.getChildren(conf.get("templeton.storage.root") + "/created", false)) {
                jobs.add(myid);
            }
        }
        catch (Exception e) {
            throw new IOException("Can't get tracking children", e);
        }
        return jobs;
    }
}

