/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.partitioners;

import java.util.Arrays;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.partitioners.CountingMap;

public class DiscreteProbabilitySampleGenerator {
    Random rGen = new Random();
    float[] probVec;
    float epsilon = 1.0E-5f;
    private static final Log LOG = LogFactory.getLog(DiscreteProbabilitySampleGenerator.class);

    public DiscreteProbabilitySampleGenerator(float[] probVec) {
        float sum = 0.0f;
        for (float f : probVec) {
            sum += f;
        }
        this.probVec = probVec;
        if (1.0f - this.epsilon > sum || sum > 1.0f + this.epsilon) {
            LOG.info((Object)("Sum of probabilities should be near one: " + sum));
        }
    }

    public int getNext() {
        double toss = this.rGen.nextDouble();
        int lastIdx = -1;
        for (int i = 0; i < this.probVec.length; ++i) {
            if (this.probVec[i] != 0.0f) {
                lastIdx = i;
            }
            if (!((toss -= (double)this.probVec[i]) <= 0.0)) continue;
            return i;
        }
        return lastIdx;
    }

    public static void main(String[] args) {
        float[] vec = new float[]{0.0f, 0.3f, 0.2f, 0.0f, 0.0f, 0.5f};
        DiscreteProbabilitySampleGenerator gen = new DiscreteProbabilitySampleGenerator(vec);
        CountingMap<Integer> cm = new CountingMap<Integer>();
        for (int i = 0; i < 100; ++i) {
            cm.put(Integer.valueOf(gen.getNext()), 1);
        }
        cm.display();
    }

    public String toString() {
        return Arrays.toString(this.probVec);
    }
}

