/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin.mock;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;
import org.apache.pig.Expression;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.PigServer;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.StoreMetadata;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Storage
extends LoadFunc
implements StoreFuncInterface,
LoadMetadata,
StoreMetadata {
    private static final String PIG_CONTEXT_KEY = "pig.mock.storage.id";
    private static final Logger LOG = Logger.getLogger(Storage.class);
    private static Map<Integer, Data> idToData = new HashMap<Integer, Data>();
    private static TupleFactory TF = TupleFactory.getInstance();
    private static BagFactory BF = BagFactory.getInstance();
    private static int nextId;
    private String location;
    private Data data;
    private Schema schema;
    private List<Tuple> dataBeingWritten;
    private Iterator<Tuple> dataBeingRead;

    public static Tuple tuple(Object ... objects) {
        return TF.newTuple(Arrays.asList(objects));
    }

    public static DataBag bag(Tuple ... tuples) {
        return BF.newDefaultBag(Arrays.asList(tuples));
    }

    public static Schema schema(String schema) throws ParserException {
        return Utils.getSchemaFromString(schema);
    }

    public static Data resetData(PigServer pigServer) {
        return Storage.resetData(pigServer.getPigContext());
    }

    public static Data resetData(PigContext context) {
        Properties properties = context.getProperties();
        try {
            if (properties.contains(PIG_CONTEXT_KEY)) {
                Integer previousId = new Integer(properties.getProperty(PIG_CONTEXT_KEY));
                idToData.remove(previousId);
            }
        }
        catch (RuntimeException e) {
            LOG.warn((Object)"invalid id in context properties for pig.mock.storage.id", (Throwable)e);
        }
        int id = nextId++;
        properties.setProperty(PIG_CONTEXT_KEY, String.valueOf(id));
        Data data = new Data();
        idToData.put(id, data);
        return data;
    }

    private Data getData(Job job) throws IOException {
        String stringId = job.getConfiguration().get(PIG_CONTEXT_KEY);
        if (stringId == null) {
            throw new IOException("no Data prepared for this Script. You need to call Storage.resetData(pigServer.getPigContext()) first");
        }
        Data data = idToData.get(new Integer(stringId));
        if (data == null) {
            throw new IOException("no Data anymore for this Script. Has data been reset by another Storage.resetData(pigServer.getPigContext()) ?");
        }
        return data;
    }

    private void init(String location, Job job) throws IOException {
        this.data = this.getData(job);
        this.location = location;
        this.schema = this.data.getSchema(location);
    }

    @Override
    public String relativeToAbsolutePath(String location, Path curDir) throws IOException {
        this.location = location;
        return location;
    }

    @Override
    public void setLocation(String location, Job job) throws IOException {
        this.init(location, job);
        this.dataBeingRead = this.data.get(location).iterator();
    }

    public InputFormat<?, ?> getInputFormat() throws IOException {
        return new MockInputFormat(this.location);
    }

    @Override
    public LoadCaster getLoadCaster() throws IOException {
        return super.getLoadCaster();
    }

    @Override
    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
    }

    @Override
    public Tuple getNext() throws IOException {
        if (this.dataBeingRead == null) {
            throw new IOException("data was not correctly initialized in MockLoader");
        }
        return this.dataBeingRead.hasNext() ? this.dataBeingRead.next() : null;
    }

    @Override
    public void setUDFContextSignature(String signature) {
        super.setUDFContextSignature(signature);
    }

    @Override
    public ResourceSchema getSchema(String location, Job job) throws IOException {
        this.init(location, job);
        return this.schema == null ? null : new ResourceSchema(this.schema);
    }

    @Override
    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        this.init(location, job);
        return null;
    }

    @Override
    public String[] getPartitionKeys(String location, Job job) throws IOException {
        this.init(location, job);
        return null;
    }

    @Override
    public void setPartitionFilter(Expression partitionFilter) throws IOException {
    }

    @Override
    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        this.location = location;
        return location;
    }

    public OutputFormat<?, ?> getOutputFormat() throws IOException {
        return new MockOutputFormat();
    }

    @Override
    public void setStoreLocation(String location, Job job) throws IOException {
        this.init(location, job);
    }

    @Override
    public void checkSchema(ResourceSchema s) throws IOException {
    }

    @Override
    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.dataBeingWritten = new ArrayList<Tuple>();
        this.data.set(this.location, this.dataBeingWritten);
    }

    @Override
    public void putNext(Tuple t) throws IOException {
        this.dataBeingWritten.add(t);
    }

    @Override
    public void setStoreFuncUDFContextSignature(String signature) {
    }

    @Override
    public void cleanupOnFailure(String location, Job job) throws IOException {
        this.init(location, job);
    }

    @Override
    public void storeStatistics(ResourceStatistics stats, String location, Job job) throws IOException {
        this.init(location, job);
    }

    @Override
    public void storeSchema(ResourceSchema schema, String location, Job job) throws IOException {
        this.init(location, job);
        this.data.setSchema(location, Schema.getPigSchema(schema));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MockOutputFormat
    extends OutputFormat<Object, Object> {
        private MockOutputFormat() {
        }

        public void checkOutputSpecs(JobContext arg0) throws IOException, InterruptedException {
        }

        public OutputCommitter getOutputCommitter(TaskAttemptContext arg0) throws IOException, InterruptedException {
            return new MockOutputCommitter();
        }

        public RecordWriter<Object, Object> getRecordWriter(TaskAttemptContext arg0) throws IOException, InterruptedException {
            return new MockRecordWriter();
        }
    }

    private static class MockOutputCommitter
    extends OutputCommitter {
        private MockOutputCommitter() {
        }

        public void abortTask(TaskAttemptContext arg0) throws IOException {
        }

        public void commitTask(TaskAttemptContext arg0) throws IOException {
        }

        public boolean needsTaskCommit(TaskAttemptContext arg0) throws IOException {
            return true;
        }

        public void setupJob(JobContext arg0) throws IOException {
        }

        public void setupTask(TaskAttemptContext arg0) throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MockRecordWriter
    extends RecordWriter<Object, Object> {
        private MockRecordWriter() {
        }

        public void close(TaskAttemptContext arg0) throws IOException, InterruptedException {
        }

        public void write(Object arg0, Object arg1) throws IOException, InterruptedException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MockInputFormat
    extends InputFormat<Object, Object> {
        private final String location;

        public MockInputFormat(String location) {
            this.location = location;
        }

        public RecordReader<Object, Object> createRecordReader(InputSplit arg0, TaskAttemptContext arg1) throws IOException, InterruptedException {
            return new MockRecordReader();
        }

        public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
            return Arrays.asList(new InputSplit[]{new MockInputSplit(this.location)});
        }
    }

    private static class MockInputSplit
    extends InputSplit
    implements Writable {
        private String location;

        public MockInputSplit() {
        }

        public MockInputSplit(String location) {
            this.location = location;
        }

        public String[] getLocations() throws IOException, InterruptedException {
            return new String[]{this.location};
        }

        public long getLength() throws IOException, InterruptedException {
            return 10000000L;
        }

        public boolean equals(Object arg0) {
            return arg0 == this;
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public void readFields(DataInput arg0) throws IOException {
            this.location = arg0.readUTF();
        }

        public void write(DataOutput arg0) throws IOException {
            arg0.writeUTF(this.location);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MockRecordReader
    extends RecordReader<Object, Object> {
        private MockRecordReader() {
        }

        public void close() throws IOException {
        }

        public Object getCurrentKey() throws IOException, InterruptedException {
            return "mockKey";
        }

        public Object getCurrentValue() throws IOException, InterruptedException {
            return "mockValue";
        }

        public float getProgress() throws IOException, InterruptedException {
            return 0.5f;
        }

        public void initialize(InputSplit split, TaskAttemptContext arg1) throws IOException, InterruptedException {
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Data
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, Collection<Tuple>> locationToData = new HashMap<String, Collection<Tuple>>();
        private Map<String, Schema> locationToSchema = new HashMap<String, Schema>();

        public void set(String location, String schema, Collection<Tuple> data) throws ParserException {
            this.set(location, Utils.getSchemaFromString(schema), data);
        }

        public void set(String location, String schema, Tuple ... data) throws ParserException {
            this.set(location, Utils.getSchemaFromString(schema), Arrays.asList(data));
        }

        public void set(String location, Schema schema, Collection<Tuple> data) {
            this.set(location, data);
            this.locationToSchema.put(location, schema);
        }

        public void set(String location, Schema schema, Tuple ... data) {
            this.set(location, schema, Arrays.asList(data));
        }

        public void set(String location, Collection<Tuple> data) {
            this.locationToData.put(location, data);
        }

        public void set(String location, Tuple ... data) {
            this.set(location, Arrays.asList(data));
        }

        public List<Tuple> get(String location) {
            if (!this.locationToData.containsKey(location)) {
                throw new RuntimeException("No data for location '" + location + "'");
            }
            Collection<Tuple> collection = this.locationToData.get(location);
            return collection instanceof List ? (List<Object>)collection : new ArrayList<Tuple>(collection);
        }

        public Schema getSchema(String location) {
            return this.locationToSchema.get(location);
        }

        public void setSchema(String location, Schema schema) {
            this.locationToSchema.put(location, schema);
        }
    }
}

