/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.BagFormat;

public class TupleFormat {
    protected static final Log mLog = LogFactory.getLog(TupleFormat.class);

    public static String format(Tuple tuple) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (int i = 0; i < tuple.size(); ++i) {
            try {
                Object d = tuple.get(i);
                if (d != null) {
                    if (d instanceof Map) {
                        sb.append(DataType.mapToString((Map)d));
                    } else if (d instanceof Tuple) {
                        Tuple t = (Tuple)d;
                        sb.append(TupleFormat.format(t));
                    } else if (d instanceof DataBag) {
                        DataBag bag = (DataBag)d;
                        sb.append(BagFormat.format(bag));
                    } else {
                        sb.append(d.toString());
                    }
                } else {
                    sb.append("");
                }
                if (i == tuple.size() - 1) continue;
                sb.append(",");
                continue;
            }
            catch (ExecException e) {
                e.printStackTrace();
                mLog.warn((Object)"Exception when format tuple", (Throwable)e);
            }
        }
        sb.append(')');
        return sb.toString();
    }
}

