/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.expression;

import java.util.List;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.builtin.ReadScalars;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.parser.SourceLocation;

public class ScalarExpression
extends UserFuncExpression {
    private Operator implicitReferencedOperator = null;
    private Operator attachedLogicalOperator = null;
    private static FuncSpec funcSpec = new FuncSpec(ReadScalars.class.getName());

    public ScalarExpression(OperatorPlan plan) {
        super(plan, funcSpec);
    }

    public ScalarExpression(OperatorPlan plan, Operator implicitReferencedOperator, Operator attachedLogicalOperator) {
        this(plan);
        this.implicitReferencedOperator = implicitReferencedOperator;
        this.attachedLogicalOperator = attachedLogicalOperator;
    }

    public LogicalSchema.LogicalFieldSchema getFieldSchema() throws FrontendException {
        if (this.fieldSchema != null) {
            return this.fieldSchema;
        }
        if (this.implicitReferencedOperator != null) {
            List<Operator> args = this.plan.getSuccessors(this);
            if (args != null && args.size() > 0) {
                int pos = (Integer)((ConstantExpression)args.get(0)).getValue();
                LogicalRelationalOperator inp = (LogicalRelationalOperator)this.implicitReferencedOperator;
                if (inp.getSchema() != null) {
                    LogicalSchema.LogicalFieldSchema inpFs = inp.getSchema().getField(pos);
                    this.fieldSchema = new LogicalSchema.LogicalFieldSchema(inpFs);
                } else {
                    this.fieldSchema = new LogicalSchema.LogicalFieldSchema(null, null, 50);
                }
                return this.fieldSchema;
            }
            return null;
        }
        return super.getFieldSchema();
    }

    public LogicalExpression deepCopy(LogicalExpressionPlan lgExpPlan) throws FrontendException {
        ScalarExpression copy = null;
        copy = new ScalarExpression((OperatorPlan)lgExpPlan, this.implicitReferencedOperator, this.attachedLogicalOperator);
        List<Operator> inputs = this.plan.getSuccessors(this);
        if (inputs != null) {
            for (Operator op : inputs) {
                LogicalExpression input = (LogicalExpression)op;
                LogicalExpression inputCopy = input.deepCopy(lgExpPlan);
                lgExpPlan.add(inputCopy);
                lgExpPlan.connect(copy, inputCopy);
            }
        }
        copy.setLocation(new SourceLocation(this.location));
        return copy;
    }

    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalExpressionVisitor)) {
            throw new FrontendException("Expected LogicalExpressionVisitor", 2222);
        }
        ((LogicalExpressionVisitor)v).visit(this);
    }

    public Operator getImplicitReferencedOperator() {
        return this.implicitReferencedOperator;
    }

    public void setImplicitReferencedOperator(Operator implicitReferencedOperator) {
        this.implicitReferencedOperator = implicitReferencedOperator;
    }

    public void setAttachedLogicalOperator(Operator attachedLogicalOperator) {
        this.attachedLogicalOperator = attachedLogicalOperator;
    }

    public Operator getAttachedLogicalOperator() {
        return this.attachedLogicalOperator;
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append("(Name: ScalarExpression) Type: ");
        if (this.fieldSchema != null) {
            msg.append(DataType.findTypeName(this.fieldSchema.type));
        } else {
            msg.append("null");
        }
        msg.append(" Uid: ");
        if (this.fieldSchema != null) {
            msg.append(this.fieldSchema.uid);
        } else {
            msg.append("null");
        }
        msg.append(")");
        return msg.toString();
    }
}

