/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.optimizer;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.PlanValidationException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanWalker;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.optimizer.FieldSchemaResetter;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LOStream;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class SchemaResetter
extends LogicalRelationalNodesVisitor {
    boolean skipDuplicateUidCheck = true;

    public SchemaResetter(OperatorPlan plan) throws FrontendException {
        this(plan, false);
    }

    public SchemaResetter(OperatorPlan plan, boolean skipDuplicateUidCheck) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
        this.skipDuplicateUidCheck = skipDuplicateUidCheck;
    }

    public void visit(LOLoad load) throws FrontendException {
        load.resetSchema();
        this.validate(load.getSchema());
    }

    public void visit(LOFilter filter) throws FrontendException {
        filter.resetSchema();
        FieldSchemaResetter fsResetter = new FieldSchemaResetter(filter.getFilterPlan());
        fsResetter.visit();
        this.validate(filter.getSchema());
    }

    public void visit(LOStore store) throws FrontendException {
        store.resetSchema();
        this.validate(store.getSchema());
    }

    public void visit(LOJoin join) throws FrontendException {
        join.resetSchema();
        Collection<LogicalExpressionPlan> joinPlans = join.getExpressionPlanValues();
        for (LogicalExpressionPlan joinPlan : joinPlans) {
            FieldSchemaResetter fsResetter = new FieldSchemaResetter(joinPlan);
            fsResetter.visit();
        }
        this.validate(join.getSchema());
    }

    public void visit(LOForEach foreach) throws FrontendException {
        foreach.resetSchema();
        LogicalPlan innerPlan = foreach.getInnerPlan();
        PlanWalker newWalker = this.currentWalker.spawnChildWalker(innerPlan);
        this.pushWalker(newWalker);
        this.currentWalker.walk(this);
        this.popWalker();
        this.validate(foreach.getSchema());
    }

    public void visit(LOGenerate gen) throws FrontendException {
        gen.resetSchema();
        List<LogicalExpressionPlan> genPlans = gen.getOutputPlans();
        for (LogicalExpressionPlan genPlan : genPlans) {
            FieldSchemaResetter fsResetter = new FieldSchemaResetter(genPlan);
            fsResetter.visit();
        }
        this.validate(gen.getSchema());
    }

    public void visit(LOInnerLoad load) throws FrontendException {
        load.resetSchema();
        load.getProjection().resetFieldSchema();
        load.getSchema();
    }

    public void visit(LOCogroup loCogroup) throws FrontendException {
        loCogroup.resetSchema();
        MultiMap<Integer, LogicalExpressionPlan> expPlans = loCogroup.getExpressionPlans();
        for (LogicalExpressionPlan expPlan : expPlans.values()) {
            FieldSchemaResetter fsResetter = new FieldSchemaResetter(expPlan);
            fsResetter.visit();
        }
        this.validate(loCogroup.getSchema());
    }

    public void visit(LOSplit loSplit) throws FrontendException {
        loSplit.resetSchema();
        this.validate(loSplit.getSchema());
    }

    public void visit(LOSplitOutput loSplitOutput) throws FrontendException {
        loSplitOutput.resetSchema();
        FieldSchemaResetter fsResetter = new FieldSchemaResetter(loSplitOutput.getFilterPlan());
        fsResetter.visit();
        this.validate(loSplitOutput.getSchema());
    }

    public void visit(LOUnion loUnion) throws FrontendException {
        loUnion.resetSchema();
        this.validate(loUnion.getSchema());
    }

    public void visit(LOSort loSort) throws FrontendException {
        loSort.resetSchema();
        List<LogicalExpressionPlan> sortPlans = loSort.getSortColPlans();
        for (LogicalExpressionPlan sortPlan : sortPlans) {
            FieldSchemaResetter fsResetter = new FieldSchemaResetter(sortPlan);
            fsResetter.visit();
        }
        this.validate(loSort.getSchema());
    }

    public void visit(LODistinct loDistinct) throws FrontendException {
        loDistinct.resetSchema();
        this.validate(loDistinct.getSchema());
    }

    public void visit(LOLimit loLimit) throws FrontendException {
        loLimit.resetSchema();
        if (loLimit.getLimitPlan() != null) {
            FieldSchemaResetter fsResetter = new FieldSchemaResetter(loLimit.getLimitPlan());
            fsResetter.visit();
        }
        this.validate(loLimit.getSchema());
    }

    public void visit(LOCross loCross) throws FrontendException {
        loCross.resetSchema();
        this.validate(loCross.getSchema());
    }

    public void visit(LOStream loStream) throws FrontendException {
        loStream.resetSchema();
        this.validate(loStream.getSchema());
    }

    public void validate(LogicalSchema schema) throws PlanValidationException {
        if (schema == null) {
            return;
        }
        HashSet<Long> uidsSeen = new HashSet<Long>();
        for (LogicalSchema.LogicalFieldSchema fs : schema.getFields()) {
            if (!this.skipDuplicateUidCheck && !uidsSeen.add(fs.uid)) {
                String msg = "Logical plan invalid state: duplicate uid in schema : " + schema;
                throw new PlanValidationException(msg, 2270, 4);
            }
            if (fs.uid >= 0L) continue;
            String msg = "Logical plan invalid state: invalid uid " + fs.uid + " in schema : " + schema;
            throw new PlanValidationException(msg, 2271, 4);
        }
    }
}

