/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.tempusfugit;

import com.google.code.tempusfugit.Factory;
import com.google.code.tempusfugit.FactoryException;
import com.google.code.tempusfugit.WithException;
import java.lang.reflect.Constructor;
import java.util.concurrent.Callable;

public class ExceptionWrapper {
    public static <V> V wrapAsRuntimeException(Callable<V> callable) throws RuntimeException {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <V, E extends Exception> V wrapAnyException(Callable<V> callable, WithException<E> wrapped) throws E {
        try {
            return callable.call();
        }
        catch (Throwable e) {
            throw ExceptionFactory.newException(wrapped, e).create();
        }
    }

    static class ExceptionFactory<E extends Exception>
    implements Factory<E> {
        private final Class wrapped;
        private final Throwable throwable;

        static <E extends Exception> ExceptionFactory<E> newException(WithException<E> wrapped, Throwable throwable) {
            return new ExceptionFactory<E>(wrapped.getType(), throwable);
        }

        private ExceptionFactory(Class<E> wrapped, Throwable throwable) {
            this.wrapped = wrapped;
            this.throwable = throwable;
        }

        @Override
        public E create() throws FactoryException {
            try {
                Constructor constructor = this.wrapped.getConstructor(Throwable.class);
                return (E)((Exception)constructor.newInstance(this.throwable));
            }
            catch (Exception e) {
                throw new FactoryException(e);
            }
        }
    }
}

