/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.tempusfugit.concurrency;

import com.google.code.tempusfugit.concurrency.ConcurrentScheduler;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public class ConcurrentTestRunner
extends BlockJUnit4ClassRunner {
    public ConcurrentTestRunner(Class<?> type) throws InitializationError {
        super(type);
        this.setScheduler(new ConcurrentScheduler(Executors.newCachedThreadPool(new ConcurrentTestRunnerThreadFactory())));
    }

    private static class ConcurrentTestRunnerThreadFactory
    implements ThreadFactory {
        private AtomicLong count = new AtomicLong();

        private ConcurrentTestRunnerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "ConcurrentTestRunner-Thread-" + this.count.getAndIncrement());
        }
    }
}

