/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseStatsUtils {
    private static final List<String> supportedStats = new ArrayList<String>();
    private static final Map<String, String> columnNameMapping = new HashMap<String, String>();

    public static List<String> getSupportedStatistics() {
        return supportedStats;
    }

    public static String getStatFromMap(String statType, Map<String, String> stats) {
        String value = stats.get(statType);
        if (value == null) {
            return "0";
        }
        return value;
    }

    public static boolean isValidStatisticSet(Collection<String> stats) {
        if (!stats.contains(HBaseStatsUtils.getBasicStat())) {
            return false;
        }
        for (String stat : stats) {
            if (supportedStats.contains(stat)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidStatistic(String statType) {
        return supportedStats.contains(statType);
    }

    public static byte[] getColumnName(String statType) {
        return Bytes.toBytes((String)columnNameMapping.get(statType));
    }

    public static byte[] getFamilyName() {
        return Bytes.toBytes((String)"PARTITION_STAT_FAMILY");
    }

    public static String getBasicStat() {
        return supportedStats.get(0);
    }

    static {
        supportedStats.add("numRows");
        supportedStats.add("rawDataSize");
        columnNameMapping.put("numRows", "ROW_COUNT");
        columnNameMapping.put("rawDataSize", "RAW_DATA_SIZE");
    }
}

