/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.WritableComparable;

public class HServerAddress
implements WritableComparable<HServerAddress> {
    private InetSocketAddress address = null;
    private String cachedToString = "";

    public HServerAddress() {
    }

    public HServerAddress(InetSocketAddress address) {
        this.address = address;
        this.checkBindAddressCanBeResolved();
        this.cachedToString = this.createCachedToString();
    }

    private String createCachedToString() {
        return this.address.toString();
    }

    public HServerAddress(String hostname, int port) {
        this(HServerAddress.getResolvedAddress(new InetSocketAddress(hostname, port)));
    }

    public HServerAddress(HServerAddress other) {
        this(HServerAddress.getResolvedAddress(new InetSocketAddress(other.getHostname(), other.getPort())));
    }

    private static InetSocketAddress getResolvedAddress(InetSocketAddress address) {
        String bindAddress = HServerAddress.getBindAddressInternal(address);
        int port = address.getPort();
        return new InetSocketAddress(bindAddress, port);
    }

    public String getBindAddress() {
        return HServerAddress.getBindAddressInternal(this.address);
    }

    private static String getBindAddressInternal(InetSocketAddress address) {
        InetAddress addr = address.getAddress();
        if (addr != null) {
            return addr.getHostAddress();
        }
        LogFactory.getLog(HServerAddress.class).error((Object)("Could not resolve the DNS name of " + address.getHostName()));
        return null;
    }

    private void checkBindAddressCanBeResolved() {
        if (this.getBindAddress() == null) {
            throw new IllegalArgumentException("Could not resolve the DNS name of " + this.address.toString());
        }
    }

    public int getPort() {
        return this.address.getPort();
    }

    public String getHostname() {
        return this.address.getHostName().toLowerCase();
    }

    public String getHostnameAndPort() {
        return this.getHostname() + ":" + this.getPort();
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.address;
    }

    public String toString() {
        return this.cachedToString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((HServerAddress)o) == 0;
    }

    public int hashCode() {
        int result = this.address == null ? 0 : this.address.hashCode();
        return result ^= this.toString().hashCode();
    }

    public void readFields(DataInput in) throws IOException {
        String hostname = in.readUTF();
        int port = in.readInt();
        if (hostname != null && hostname.length() > 0) {
            this.address = HServerAddress.getResolvedAddress(new InetSocketAddress(hostname, port));
            this.checkBindAddressCanBeResolved();
            this.createCachedToString();
        }
    }

    public void write(DataOutput out) throws IOException {
        if (this.address == null) {
            out.writeUTF("");
            out.writeInt(0);
        } else {
            out.writeUTF(this.address.getAddress().getHostName());
            out.writeInt(this.address.getPort());
        }
    }

    public int compareTo(HServerAddress o) {
        if (this.address.equals(o.address)) {
            return 0;
        }
        return this.toString().compareTo(o.toString());
    }
}

