/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;

public class Get
extends OperationWithAttributes
implements Writable,
Row,
Comparable<Row> {
    private static final byte GET_VERSION = 2;
    private byte[] row = null;
    private long lockId = -1L;
    private int maxVersions = 1;
    private boolean cacheBlocks = true;
    private Filter filter = null;
    private TimeRange tr = new TimeRange();
    private Map<byte[], NavigableSet<byte[]>> familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);

    public Get() {
    }

    public Get(byte[] row) {
        this(row, null);
    }

    public Get(byte[] row, RowLock rowLock) {
        this.row = row;
        if (rowLock != null) {
            this.lockId = rowLock.getLockId();
        }
    }

    public Get addFamily(byte[] family) {
        this.familyMap.remove(family);
        this.familyMap.put(family, null);
        return this;
    }

    public Get addColumn(byte[] family, byte[] qualifier) {
        NavigableSet<byte[]> set = this.familyMap.get(family);
        if (set == null) {
            set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        }
        if (qualifier == null) {
            qualifier = HConstants.EMPTY_BYTE_ARRAY;
        }
        set.add(qualifier);
        this.familyMap.put(family, set);
        return this;
    }

    public Get setTimeRange(long minStamp, long maxStamp) throws IOException {
        this.tr = new TimeRange(minStamp, maxStamp);
        return this;
    }

    public Get setTimeStamp(long timestamp) {
        try {
            this.tr = new TimeRange(timestamp, timestamp + 1L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public Get setMaxVersions() {
        this.maxVersions = Integer.MAX_VALUE;
        return this;
    }

    public Get setMaxVersions(int maxVersions) throws IOException {
        if (maxVersions <= 0) {
            throw new IOException("maxVersions must be positive");
        }
        this.maxVersions = maxVersions;
        return this;
    }

    public Get setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setCacheBlocks(boolean cacheBlocks) {
        this.cacheBlocks = cacheBlocks;
    }

    public boolean getCacheBlocks() {
        return this.cacheBlocks;
    }

    @Override
    public byte[] getRow() {
        return this.row;
    }

    public RowLock getRowLock() {
        return new RowLock(this.row, this.lockId);
    }

    public long getLockId() {
        return this.lockId;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public TimeRange getTimeRange() {
        return this.tr;
    }

    public Set<byte[]> familySet() {
        return this.familyMap.keySet();
    }

    public int numFamilies() {
        return this.familyMap.size();
    }

    public boolean hasFamilies() {
        return !this.familyMap.isEmpty();
    }

    public Map<byte[], NavigableSet<byte[]>> getFamilyMap() {
        return this.familyMap;
    }

    @Override
    public Map<String, Object> getFingerprint() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> families = new ArrayList<String>();
        map.put("families", families);
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            families.add(Bytes.toStringBinary(entry.getKey()));
        }
        return map;
    }

    @Override
    public Map<String, Object> toMap(int maxCols) {
        Map<String, Object> map = this.getFingerprint();
        HashMap columns = new HashMap();
        map.put("families", columns);
        map.put("row", Bytes.toStringBinary(this.row));
        map.put("maxVersions", this.maxVersions);
        map.put("cacheBlocks", this.cacheBlocks);
        ArrayList<Long> timeRange = new ArrayList<Long>();
        timeRange.add(this.tr.getMin());
        timeRange.add(this.tr.getMax());
        map.put("timeRange", timeRange);
        int colCount = 0;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            ArrayList<String> familyList = new ArrayList<String>();
            columns.put(Bytes.toStringBinary(entry.getKey()), familyList);
            if (entry.getValue() == null) {
                ++colCount;
                --maxCols;
                familyList.add("ALL");
                continue;
            }
            colCount += entry.getValue().size();
            if (maxCols <= 0) continue;
            for (byte[] column : entry.getValue()) {
                if (--maxCols <= 0) continue;
                familyList.add(Bytes.toStringBinary(column));
            }
        }
        map.put("totalColumns", colCount);
        if (this.filter != null) {
            map.put("filter", this.filter.toString());
        }
        if (this.getId() != null) {
            map.put("id", this.getId());
        }
        return map;
    }

    @Override
    public int compareTo(Row other) {
        return Bytes.compareTo(this.getRow(), other.getRow());
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version > 2) {
            throw new IOException("unsupported version");
        }
        this.row = Bytes.readByteArray(in);
        this.lockId = in.readLong();
        this.maxVersions = in.readInt();
        boolean hasFilter = in.readBoolean();
        if (hasFilter) {
            this.filter = (Filter)this.createForName(Bytes.toString(Bytes.readByteArray(in)));
            this.filter.readFields(in);
        }
        this.cacheBlocks = in.readBoolean();
        this.tr = new TimeRange();
        this.tr.readFields(in);
        int numFamilies = in.readInt();
        this.familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < numFamilies; ++i) {
            byte[] family = Bytes.readByteArray(in);
            boolean hasColumns = in.readBoolean();
            TreeSet<byte[]> set = null;
            if (hasColumns) {
                int numColumns = in.readInt();
                set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
                for (int j = 0; j < numColumns; ++j) {
                    byte[] qualifier = Bytes.readByteArray(in);
                    set.add(qualifier);
                }
            }
            this.familyMap.put(family, set);
        }
        this.readAttributes(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(2);
        Bytes.writeByteArray(out, this.row);
        out.writeLong(this.lockId);
        out.writeInt(this.maxVersions);
        if (this.filter == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Bytes.writeByteArray(out, Bytes.toBytes(this.filter.getClass().getName()));
            this.filter.write(out);
        }
        out.writeBoolean(this.cacheBlocks);
        this.tr.write(out);
        out.writeInt(this.familyMap.size());
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            Bytes.writeByteArray(out, entry.getKey());
            NavigableSet<byte[]> columnSet = entry.getValue();
            if (columnSet == null) {
                out.writeBoolean(false);
                continue;
            }
            out.writeBoolean(true);
            out.writeInt(columnSet.size());
            for (byte[] qualifier : columnSet) {
                Bytes.writeByteArray(out, qualifier);
            }
        }
        this.writeAttributes(out);
    }

    private Writable createForName(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return WritableFactories.newInstance(clazz, (Configuration)new Configuration());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't find class " + className);
        }
    }
}

