/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MasterAddressTracker;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.hbase.client.UnmodifyableHTableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.ipc.ExecRPCInvoker;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.ipc.RpcEngine;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.SoftValueSortedMap;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.ClusterId;
import org.apache.hadoop.hbase.zookeeper.RootRegionTracker;
import org.apache.hadoop.hbase.zookeeper.ZKTableReadOnly;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.zookeeper.KeeperException;

public class HConnectionManager {
    static final Map<HConnectionKey, HConnectionImplementation> HBASE_INSTANCES;
    public static final int MAX_CACHED_HBASE_INSTANCES;
    private static Log LOG;

    protected HConnectionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HConnection getConnection(Configuration conf) throws ZooKeeperConnectionException {
        HConnectionKey connectionKey = new HConnectionKey(conf);
        Map<HConnectionKey, HConnectionImplementation> map = HBASE_INSTANCES;
        synchronized (map) {
            HConnectionImplementation connection = HBASE_INSTANCES.get(connectionKey);
            if (connection == null) {
                connection = new HConnectionImplementation(conf, true);
                HBASE_INSTANCES.put(connectionKey, connection);
            } else if (connection.isClosed()) {
                HConnectionManager.deleteConnection(connectionKey, true);
                connection = new HConnectionImplementation(conf, true);
                HBASE_INSTANCES.put(connectionKey, connection);
            }
            connection.incCount();
            return connection;
        }
    }

    public static HConnection createConnection(Configuration conf) throws ZooKeeperConnectionException {
        return new HConnectionImplementation(conf, false);
    }

    @Deprecated
    public static void deleteConnection(Configuration conf, boolean stopProxy) {
        HConnectionManager.deleteConnection(conf);
    }

    public static void deleteConnection(Configuration conf) {
        HConnectionManager.deleteConnection(new HConnectionKey(conf), false);
    }

    public static void deleteStaleConnection(HConnection connection) {
        HConnectionManager.deleteConnection(connection, true);
    }

    @Deprecated
    public static void deleteAllConnections(boolean stopProxy) {
        HConnectionManager.deleteAllConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllConnections() {
        Map<HConnectionKey, HConnectionImplementation> map = HBASE_INSTANCES;
        synchronized (map) {
            HashSet<HConnectionKey> connectionKeys = new HashSet<HConnectionKey>();
            connectionKeys.addAll(HBASE_INSTANCES.keySet());
            for (HConnectionKey connectionKey : connectionKeys) {
                HConnectionManager.deleteConnection(connectionKey, false);
            }
            HBASE_INSTANCES.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteConnection(HConnection connection, boolean staleConnection) {
        Map<HConnectionKey, HConnectionImplementation> map = HBASE_INSTANCES;
        synchronized (map) {
            for (Map.Entry<HConnectionKey, HConnectionImplementation> connectionEntry : HBASE_INSTANCES.entrySet()) {
                if (connectionEntry.getValue() != connection) continue;
                HConnectionManager.deleteConnection(connectionEntry.getKey(), staleConnection);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteConnection(HConnectionKey connectionKey, boolean staleConnection) {
        Map<HConnectionKey, HConnectionImplementation> map = HBASE_INSTANCES;
        synchronized (map) {
            HConnectionImplementation connection = HBASE_INSTANCES.get(connectionKey);
            if (connection != null) {
                connection.decCount();
                if (connection.isZeroReference() || staleConnection) {
                    HBASE_INSTANCES.remove(connectionKey);
                    connection.internalClose();
                }
            } else {
                LOG.error((Object)("Connection not found in the list, can't delete it (connection key=" + connectionKey + "). May be the key was modified?"));
            }
        }
    }

    static int getCachedRegionCount(Configuration conf, final byte[] tableName) throws IOException {
        return HConnectionManager.execute(new HConnectable<Integer>(conf){

            @Override
            public Integer connect(HConnection connection) {
                return ((HConnectionImplementation)connection).getNumberOfCachedRegionLocations(tableName);
            }
        });
    }

    static boolean isRegionCached(Configuration conf, final byte[] tableName, final byte[] row) throws IOException {
        return HConnectionManager.execute(new HConnectable<Boolean>(conf){

            @Override
            public Boolean connect(HConnection connection) {
                return ((HConnectionImplementation)connection).isRegionCached(tableName, row);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(HConnectable<T> connectable) throws IOException {
        if (connectable == null || connectable.conf == null) {
            return null;
        }
        Configuration conf = connectable.conf;
        HConnection connection = HConnectionManager.getConnection(conf);
        boolean connectSucceeded = false;
        try {
            T returnValue = connectable.connect(connection);
            connectSucceeded = true;
            T t = returnValue;
            return t;
        }
        finally {
            block8: {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    if (!connectSucceeded) break block8;
                    throw new IOException("The connection to " + connection + " could not be deleted.", e);
                }
            }
        }
    }

    public static void setServerSideHConnectionRetries(Configuration c, Log log) {
        int hcRetries = c.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
        int serversideMultiplier = c.getInt("hbase.client.serverside.retries.multiplier", 10);
        int retries = hcRetries * serversideMultiplier;
        c.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, retries);
        log.debug((Object)("Set serverside HConnection retries=" + retries));
    }

    static {
        LOG = LogFactory.getLog(HConnectionManager.class);
        MAX_CACHED_HBASE_INSTANCES = HBaseConfiguration.create().getInt("hbase.zookeeper.property.maxClientCnxns", 300) + 1;
        HBASE_INSTANCES = new LinkedHashMap<HConnectionKey, HConnectionImplementation>((int)((float)MAX_CACHED_HBASE_INSTANCES / 0.75f) + 1, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<HConnectionKey, HConnectionImplementation> eldest) {
                return this.size() > MAX_CACHED_HBASE_INSTANCES;
            }
        };
    }

    static class HConnectionImplementation
    implements HConnection,
    Closeable {
        static final Log LOG = LogFactory.getLog(HConnectionImplementation.class);
        private final Class<? extends HRegionInterface> serverInterfaceClass;
        private final long pause;
        private final int numRetries;
        private final int maxRPCAttempts;
        private final int rpcTimeout;
        private final int prefetchRegionLimit;
        private final Object masterLock = new Object();
        private volatile boolean closed;
        private volatile boolean aborted;
        private volatile boolean resetting;
        private volatile HMasterInterface master;
        private volatile ZooKeeperWatcher zooKeeper;
        private volatile MasterAddressTracker masterAddressTracker;
        private volatile RootRegionTracker rootRegionTracker;
        private volatile ClusterId clusterId;
        private final Object metaRegionLock = new Object();
        private final Object userRegionLock = new Object();
        private final Object resetLock = new Object();
        private final Configuration conf;
        private RpcEngine rpcEngine;
        private final Map<String, HRegionInterface> servers = new ConcurrentHashMap<String, HRegionInterface>();
        private final ConcurrentHashMap<String, String> connectionLock = new ConcurrentHashMap();
        private final Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> cachedRegionLocations = new HashMap<Integer, SoftValueSortedMap<byte[], HRegionLocation>>();
        private final Set<String> cachedServers = new HashSet<String>();
        private final Set<Integer> regionCachePrefetchDisabledTables = new CopyOnWriteArraySet<Integer>();
        private int refCount;
        private final boolean managed;

        public HConnectionImplementation(Configuration conf, boolean managed) throws ZooKeeperConnectionException {
            this.conf = conf;
            this.managed = managed;
            String serverClassName = conf.get("hbase.regionserver.class", HConstants.DEFAULT_REGION_SERVER_CLASS);
            this.closed = false;
            try {
                this.serverInterfaceClass = Class.forName(serverClassName);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Unable to find region server interface " + serverClassName, e);
            }
            this.pause = conf.getLong(HConstants.HBASE_CLIENT_PAUSE, HConstants.DEFAULT_HBASE_CLIENT_PAUSE);
            this.numRetries = conf.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
            this.maxRPCAttempts = conf.getInt(HConstants.HBASE_CLIENT_RPC_MAXATTEMPTS, HConstants.DEFAULT_HBASE_CLIENT_RPC_MAXATTEMPTS);
            this.rpcTimeout = conf.getInt(HConstants.HBASE_RPC_TIMEOUT_KEY, HConstants.DEFAULT_HBASE_RPC_TIMEOUT);
            this.prefetchRegionLimit = conf.getInt(HConstants.HBASE_CLIENT_PREFETCH_LIMIT, HConstants.DEFAULT_HBASE_CLIENT_PREFETCH_LIMIT);
            this.master = null;
            this.resetting = false;
        }

        private synchronized void ensureZookeeperTrackers() throws ZooKeeperConnectionException {
            if (this.zooKeeper == null) {
                this.zooKeeper = this.getZooKeeperWatcher();
            }
            if (this.clusterId == null) {
                this.clusterId = new ClusterId(this.zooKeeper, this);
                if (this.clusterId.hasId()) {
                    this.conf.set("hbase.cluster.id", this.clusterId.getId());
                }
            }
            if (this.masterAddressTracker == null) {
                this.masterAddressTracker = new MasterAddressTracker(this.zooKeeper, this);
                this.masterAddressTracker.start();
            }
            if (this.rootRegionTracker == null) {
                this.rootRegionTracker = new RootRegionTracker(this.zooKeeper, this);
                this.rootRegionTracker.start();
            }
            if (this.rpcEngine == null) {
                this.rpcEngine = HBaseRPC.getProtocolEngine(this.conf);
            }
        }

        private synchronized void resetZooKeeperTrackers() {
            if (this.masterAddressTracker != null) {
                this.masterAddressTracker.stop();
                this.masterAddressTracker = null;
            }
            if (this.rootRegionTracker != null) {
                this.rootRegionTracker.stop();
                this.rootRegionTracker = null;
            }
            this.clusterId = null;
            if (this.zooKeeper != null) {
                this.zooKeeper.close();
                this.zooKeeper = null;
            }
        }

        @Override
        public Configuration getConfiguration() {
            return this.conf;
        }

        private boolean shouldRetryGetMaster(int tries, Exception e) {
            if (tries == this.numRetries - 1) {
                LOG.info((Object)("getMaster attempt " + tries + " of " + this.numRetries + " failed; no more retrying."), (Throwable)e);
                return false;
            }
            LOG.info((Object)("getMaster attempt " + tries + " of " + this.numRetries + " failed; retrying after sleep of " + ConnectionUtils.getPauseTime(this.pause, tries)), (Throwable)e);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HMasterInterface getMaster() throws MasterNotRunningException, ZooKeeperConnectionException {
            try {
                if (this.master != null && this.master.isMasterRunning()) {
                    return this.master;
                }
            }
            catch (UndeclaredThrowableException ute) {
                LOG.info((Object)"Exception contacting master. Retrying...", ute.getCause());
            }
            this.ensureZookeeperTrackers();
            this.checkIfBaseNodeAvailable();
            ServerName sn = null;
            Object object = this.masterLock;
            synchronized (object) {
                try {
                    if (this.master != null && this.master.isMasterRunning()) {
                        return this.master;
                    }
                }
                catch (UndeclaredThrowableException ute) {
                    LOG.info((Object)"Exception contacting master. Retrying...", ute.getCause());
                }
                this.master = null;
                for (int tries = 0; !this.closed && this.master == null && tries < this.numRetries; ++tries) {
                    block20: {
                        try {
                            sn = this.masterAddressTracker.getMasterAddress();
                            if (sn == null) {
                                LOG.info((Object)"ZooKeeper available but no active master location found");
                                throw new MasterNotRunningException();
                            }
                            InetSocketAddress isa = new InetSocketAddress(sn.getHostname(), sn.getPort());
                            HMasterInterface tryMaster = this.rpcEngine.getProxy(HMasterInterface.class, 29L, isa, this.conf, this.rpcTimeout);
                            if (tryMaster.isMasterRunning()) {
                                this.master = tryMaster;
                                this.masterLock.notifyAll();
                            }
                            break block20;
                        }
                        catch (IOException e) {
                            if (!this.shouldRetryGetMaster(tries, e)) {
                            }
                            break block20;
                        }
                        catch (UndeclaredThrowableException ute) {
                            if (this.shouldRetryGetMaster(tries, ute)) break block20;
                        }
                        break;
                    }
                    try {
                        this.masterLock.wait(ConnectionUtils.getPauseTime(this.pause, tries));
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("Thread was interrupted while trying to connect to master.");
                    }
                }
                if (this.master == null) {
                    if (sn == null) {
                        throw new MasterNotRunningException();
                    }
                    throw new MasterNotRunningException(sn.toString());
                }
                return this.master;
            }
        }

        private void checkIfBaseNodeAvailable() throws MasterNotRunningException {
            if (!this.masterAddressTracker.checkIfBaseNodeAvailable()) {
                String errorMsg = "Check the value configured in 'zookeeper.znode.parent'. There could be a mismatch with the one configured in the master.";
                LOG.error((Object)errorMsg);
                throw new MasterNotRunningException(errorMsg);
            }
        }

        @Override
        public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
            boolean isRunning;
            if (this.master == null) {
                this.getMaster();
            }
            if (isRunning = this.master.isMasterRunning()) {
                return true;
            }
            throw new MasterNotRunningException();
        }

        @Override
        public HRegionLocation getRegionLocation(byte[] name, byte[] row, boolean reload) throws IOException {
            return reload ? this.relocateRegion(name, row) : this.locateRegion(name, row);
        }

        @Override
        public boolean isTableEnabled(byte[] tableName) throws IOException {
            return this.testTableOnlineState(tableName, true);
        }

        @Override
        public boolean isTableDisabled(byte[] tableName) throws IOException {
            return this.testTableOnlineState(tableName, false);
        }

        @Override
        public boolean isTableAvailable(final byte[] tableName) throws IOException {
            final AtomicBoolean available = new AtomicBoolean(true);
            final AtomicInteger regionCount = new AtomicInteger(0);
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result row) throws IOException {
                    byte[] value = row.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                    HRegionInfo info = Writables.getHRegionInfoOrNull(value);
                    if (info != null && Bytes.equals(tableName, info.getTableName())) {
                        value = row.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                        if (value == null) {
                            available.set(false);
                            return false;
                        }
                        regionCount.incrementAndGet();
                    }
                    return true;
                }
            };
            MetaScanner.metaScan(this.conf, visitor);
            return available.get() && regionCount.get() > 0;
        }

        private boolean testTableOnlineState(byte[] tableName, boolean online) throws IOException {
            if (Bytes.equals(tableName, HConstants.ROOT_TABLE_NAME)) {
                return online;
            }
            ZooKeeperWatcher zkw = this.getZooKeeperWatcher();
            String tableNameStr = Bytes.toString(tableName);
            try {
                if (online) {
                    return ZKTableReadOnly.isEnabledTable(zkw, tableNameStr);
                }
                return ZKTableReadOnly.isDisabledTable(zkw, tableNameStr);
            }
            catch (KeeperException e) {
                throw new IOException("Enable/Disable failed", e);
            }
        }

        @Override
        public HRegionLocation locateRegion(byte[] regionName) throws IOException {
            return null;
        }

        @Override
        public List<HRegionLocation> locateRegions(byte[] tableName) throws IOException {
            return null;
        }

        @Override
        public HRegionLocation locateRegion(byte[] tableName, byte[] row) throws IOException {
            return this.locateRegion(tableName, row, true, true);
        }

        @Override
        public HRegionLocation relocateRegion(byte[] tableName, byte[] row) throws IOException {
            if (this.isTableDisabled(tableName)) {
                throw new DoNotRetryIOException(Bytes.toString(tableName) + " is disabled.");
            }
            return this.locateRegion(tableName, row, false, true);
        }

        private HRegionLocation locateRegion(byte[] tableName, byte[] row, boolean useCache, boolean retry) throws IOException {
            if (this.closed) {
                throw new IOException(this.toString() + " closed");
            }
            if (tableName == null || tableName.length == 0) {
                throw new IllegalArgumentException("table name cannot be null or zero length");
            }
            this.ensureZookeeperTrackers();
            if (Bytes.equals(tableName, HConstants.ROOT_TABLE_NAME)) {
                try {
                    ServerName servername = this.rootRegionTracker.waitRootRegionLocation(this.rpcTimeout);
                    LOG.debug((Object)("Looked up root region location, connection=" + this + "; serverName=" + (servername == null ? "" : servername.toString())));
                    if (servername == null) {
                        return null;
                    }
                    return new HRegionLocation(HRegionInfo.ROOT_REGIONINFO, servername.getHostname(), servername.getPort());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            if (Bytes.equals(tableName, HConstants.META_TABLE_NAME)) {
                return this.locateRegionInMeta(HConstants.ROOT_TABLE_NAME, tableName, row, useCache, this.metaRegionLock, retry);
            }
            return this.locateRegionInMeta(HConstants.META_TABLE_NAME, tableName, row, useCache, this.userRegionLock, retry);
        }

        private void prefetchRegionCache(final byte[] tableName, byte[] row) {
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result result) throws IOException {
                    try {
                        byte[] value = result.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                        HRegionInfo regionInfo = null;
                        if (value != null) {
                            regionInfo = Writables.getHRegionInfo(value);
                            if (!Bytes.equals(regionInfo.getTableName(), tableName)) {
                                return false;
                            }
                            if (regionInfo.isOffline()) {
                                return true;
                            }
                            value = result.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                            if (value == null) {
                                return true;
                            }
                            String hostAndPort = Bytes.toString(value);
                            String hostname = Addressing.parseHostname(hostAndPort);
                            int port = Addressing.parsePort(hostAndPort);
                            value = result.getValue(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER);
                            HRegionLocation loc = new HRegionLocation(regionInfo, hostname, port);
                            HConnectionImplementation.this.cacheLocation(tableName, loc);
                        }
                        return true;
                    }
                    catch (RuntimeException e) {
                        throw new IOException(e);
                    }
                }
            };
            try {
                MetaScanner.metaScan(this.conf, visitor, tableName, row, this.prefetchRegionLimit);
            }
            catch (IOException e) {
                LOG.warn((Object)"Encountered problems when prefetch META table: ", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HRegionLocation locateRegionInMeta(byte[] parentTable, byte[] tableName, byte[] row, boolean useCache, Object regionLockObject, boolean retry) throws IOException {
            HRegionLocation location;
            if (useCache && (location = this.getCachedLocation(tableName, row)) != null) {
                return location;
            }
            int localNumRetries = retry ? this.numRetries : 1;
            byte[] metaKey = HRegionInfo.createRegionName(tableName, row, "99999999999999", false);
            int tries = 0;
            while (true) {
                block27: {
                    if (tries >= localNumRetries) {
                        throw new NoServerForRegionException("Unable to find region for " + Bytes.toStringBinary(row) + " after " + this.numRetries + " tries.");
                    }
                    HRegionLocation metaLocation = null;
                    try {
                        metaLocation = this.locateRegion(parentTable, metaKey, true, false);
                        if (metaLocation == null) break block27;
                        HRegionInterface server = this.getHRegionConnection(metaLocation.getHostname(), metaLocation.getPort());
                        Result regionInfoRow = null;
                        Object object = regionLockObject;
                        synchronized (object) {
                            if (Bytes.equals(parentTable, HConstants.META_TABLE_NAME) && this.getRegionCachePrefetch(tableName)) {
                                this.prefetchRegionCache(tableName, row);
                            }
                            if (useCache) {
                                location = this.getCachedLocation(tableName, row);
                                if (location != null) {
                                    return location;
                                }
                            } else {
                                this.deleteCachedLocation(tableName, row);
                            }
                            regionInfoRow = server.getClosestRowBefore(metaLocation.getRegionInfo().getRegionName(), metaKey, HConstants.CATALOG_FAMILY);
                        }
                        if (regionInfoRow == null) {
                            throw new TableNotFoundException(Bytes.toString(tableName));
                        }
                        byte[] value = regionInfoRow.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                        if (value == null || value.length == 0) {
                            throw new IOException("HRegionInfo was null or empty in " + Bytes.toString(parentTable) + ", row=" + regionInfoRow);
                        }
                        HRegionInfo regionInfo = (HRegionInfo)Writables.getWritable(value, (Writable)new HRegionInfo());
                        if (!Bytes.equals(regionInfo.getTableName(), tableName)) {
                            throw new TableNotFoundException("Table '" + Bytes.toString(tableName) + "' was not found, got: " + Bytes.toString(regionInfo.getTableName()) + ".");
                        }
                        if (regionInfo.isSplit()) {
                            throw new RegionOfflineException("the only available region for the required row is a split parent, the daughters should be online soon: " + regionInfo.getRegionNameAsString());
                        }
                        if (regionInfo.isOffline()) {
                            throw new RegionOfflineException("the region is offline, could be caused by a disable table call: " + regionInfo.getRegionNameAsString());
                        }
                        value = regionInfoRow.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                        String hostAndPort = "";
                        if (value != null) {
                            hostAndPort = Bytes.toString(value);
                        }
                        if (hostAndPort.equals("")) {
                            throw new NoServerForRegionException("No server address listed in " + Bytes.toString(parentTable) + " for region " + regionInfo.getRegionNameAsString() + " containing row " + Bytes.toStringBinary(row));
                        }
                        String hostname = Addressing.parseHostname(hostAndPort);
                        int port = Addressing.parsePort(hostAndPort);
                        location = new HRegionLocation(regionInfo, hostname, port);
                        this.cacheLocation(tableName, location);
                        return location;
                    }
                    catch (TableNotFoundException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        if (e instanceof RemoteException) {
                            e = RemoteExceptionHandler.decodeRemoteException((RemoteException)((Object)e));
                        }
                        if (tries < this.numRetries - 1) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("locateRegionInMeta parentTable=" + Bytes.toString(parentTable) + ", metaLocation=" + (metaLocation == null ? "null" : "{" + metaLocation + "}") + ", attempt=" + tries + " of " + this.numRetries + " failed; retrying after sleep of " + ConnectionUtils.getPauseTime(this.pause, tries) + " because: " + e.getMessage()));
                            }
                        } else {
                            throw e;
                        }
                        if (!(e instanceof RegionOfflineException) && !(e instanceof NoServerForRegionException)) {
                            this.relocateRegion(parentTable, metaKey);
                        }
                        try {
                            Thread.sleep(ConnectionUtils.getPauseTime(this.pause, tries));
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                            throw new IOException("Giving up trying to location region in meta: thread is interrupted.");
                        }
                    }
                }
                ++tries;
            }
        }

        HRegionLocation getCachedLocation(byte[] tableName, byte[] row) {
            SoftValueSortedMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
            if (tableLocations.isEmpty()) {
                return null;
            }
            HRegionLocation possibleRegion = tableLocations.get(row);
            if (possibleRegion != null) {
                return possibleRegion;
            }
            possibleRegion = tableLocations.lowerValueByKey(row);
            if (possibleRegion == null) {
                return null;
            }
            byte[] endKey = possibleRegion.getRegionInfo().getEndKey();
            if (Bytes.equals(endKey, HConstants.EMPTY_END_ROW) || KeyValue.getRowComparator(tableName).compareRows(endKey, 0, endKey.length, row, 0, row.length) > 0) {
                return possibleRegion;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void deleteCachedLocation(byte[] tableName, byte[] row) {
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                HRegionLocation rl;
                SoftValueSortedMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
                if (!tableLocations.isEmpty() && (rl = this.getCachedLocation(tableName, row)) != null) {
                    tableLocations.remove(rl.getRegionInfo().getStartKey());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Removed " + rl.getRegionInfo().getRegionNameAsString() + " for tableName=" + Bytes.toString(tableName) + " from cache " + "because of " + Bytes.toStringBinary(row)));
                    }
                }
            }
        }

        @Override
        public void clearCaches(String sn) {
            this.clearCachedLocationForServer(sn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearCachedLocationForServer(String server) {
            boolean deletedSomething = false;
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                if (!this.cachedServers.contains(server)) {
                    return;
                }
                for (SoftValueSortedMap<byte[], HRegionLocation> tableLocations : this.cachedRegionLocations.values()) {
                    for (Map.Entry e : tableLocations.entrySet()) {
                        if (!((HRegionLocation)e.getValue()).getHostnamePort().equals(server)) continue;
                        tableLocations.remove(e.getKey());
                        deletedSomething = true;
                    }
                }
                this.cachedServers.remove(server);
            }
            if (deletedSomething && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removed all cached region locations that map to " + server));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SoftValueSortedMap<byte[], HRegionLocation> getTableLocations(byte[] tableName) {
            SoftValueSortedMap<byte[], HRegionLocation> result;
            Integer key = Bytes.mapKey(tableName);
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                result = this.cachedRegionLocations.get(key);
                if (result == null) {
                    result = new SoftValueSortedMap(Bytes.BYTES_COMPARATOR);
                    this.cachedRegionLocations.put(key, result);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearRegionCache() {
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                this.cachedRegionLocations.clear();
                this.cachedServers.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearRegionCache(byte[] tableName) {
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                this.cachedRegionLocations.remove(Bytes.mapKey(tableName));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cacheLocation(byte[] tableName, HRegionLocation location) {
            byte[] startKey = location.getRegionInfo().getStartKey();
            SoftValueSortedMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
            boolean hasNewCache = false;
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                this.cachedServers.add(location.getHostnamePort());
                hasNewCache = tableLocations.put(startKey, location) == null;
            }
            if (hasNewCache) {
                LOG.debug((Object)("Cached location for " + location.getRegionInfo().getRegionNameAsString() + " is " + location.getHostnamePort()));
            }
        }

        @Override
        public HRegionInterface getHRegionConnection(HServerAddress hsa) throws IOException {
            return this.getHRegionConnection(hsa, false);
        }

        @Override
        public HRegionInterface getHRegionConnection(String hostname, int port) throws IOException {
            return this.getHRegionConnection(hostname, port, false);
        }

        @Override
        public HRegionInterface getHRegionConnection(HServerAddress hsa, boolean master) throws IOException {
            return this.getHRegionConnection(null, -1, hsa.getInetSocketAddress(), master);
        }

        @Override
        public HRegionInterface getHRegionConnection(String hostname, int port, boolean master) throws IOException {
            return this.getHRegionConnection(hostname, port, null, master);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HRegionInterface getHRegionConnection(String hostname, int port, InetSocketAddress isa, boolean master) throws IOException {
            if (master) {
                this.getMaster();
            }
            String rsName = null;
            rsName = isa != null ? Addressing.createHostAndPortStr(isa.getHostName(), isa.getPort()) : Addressing.createHostAndPortStr(hostname, port);
            this.ensureZookeeperTrackers();
            HRegionInterface server = this.servers.get(rsName);
            if (server == null) {
                this.connectionLock.putIfAbsent(rsName, rsName);
                String string = this.connectionLock.get(rsName);
                synchronized (string) {
                    server = this.servers.get(rsName);
                    if (server == null) {
                        try {
                            InetSocketAddress address = isa != null ? isa : new InetSocketAddress(hostname, port);
                            server = HBaseRPC.waitForProxy(this.rpcEngine, this.serverInterfaceClass, 29L, address, this.conf, this.maxRPCAttempts, this.rpcTimeout, this.rpcTimeout);
                            this.servers.put(Addressing.createHostAndPortStr(address.getHostName(), address.getPort()), server);
                        }
                        catch (RemoteException e) {
                            LOG.warn((Object)"RemoteException connecting to RS", (Throwable)e);
                            throw e.unwrapRemoteException();
                        }
                    }
                }
            }
            return server;
        }

        @Override
        public synchronized ZooKeeperWatcher getZooKeeperWatcher() throws ZooKeeperConnectionException {
            if (this.zooKeeper == null) {
                try {
                    this.zooKeeper = new ZooKeeperWatcher(this.conf, "hconnection", this);
                }
                catch (ZooKeeperConnectionException zce) {
                    throw zce;
                }
                catch (IOException e) {
                    throw new ZooKeeperConnectionException("An error is preventing HBase from connecting to ZooKeeper", e);
                }
            }
            return this.zooKeeper;
        }

        @Override
        public <T> T getRegionServerWithRetries(ServerCallable<T> callable) throws IOException, RuntimeException {
            return callable.withRetries();
        }

        @Override
        public <T> T getRegionServerWithoutRetries(ServerCallable<T> callable) throws IOException, RuntimeException {
            return callable.withoutRetries();
        }

        private <R> Callable<MultiResponse> createCallable(final HRegionLocation loc, final MultiAction<R> multi, final byte[] tableName) {
            final HConnectionImplementation connection = this;
            return new Callable<MultiResponse>(){

                @Override
                public MultiResponse call() throws IOException {
                    ServerCallable<MultiResponse> callable = new ServerCallable<MultiResponse>(connection, tableName, null){

                        @Override
                        public MultiResponse call() throws IOException {
                            return this.server.multi(multi);
                        }

                        @Override
                        public void connect(boolean reload) throws IOException {
                            this.server = this.connection.getHRegionConnection(loc.getHostname(), loc.getPort());
                        }
                    };
                    return (MultiResponse)callable.withoutRetries();
                }
            };
        }

        @Override
        public void processBatch(List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
            if (results.length != list.size()) {
                throw new IllegalArgumentException("argument results must be the same size as argument list");
            }
            this.processBatchCallback(list, tableName, pool, results, null);
        }

        @Override
        public <T extends CoprocessorProtocol, R> void processExecs(final Class<T> protocol, List<byte[]> rows, byte[] tableName, ExecutorService pool, final Batch.Call<T, R> callable, final Batch.Callback<R> callback) throws IOException, Throwable {
            TreeMap futures = new TreeMap(Bytes.BYTES_COMPARATOR);
            for (final byte[] byArray : rows) {
                final ExecRPCInvoker invoker = new ExecRPCInvoker(this.conf, this, protocol, tableName, byArray);
                Future future = pool.submit(new Callable<R>(){

                    @Override
                    public R call() throws Exception {
                        CoprocessorProtocol instance = (CoprocessorProtocol)Proxy.newProxyInstance(HConnectionImplementation.this.conf.getClassLoader(), new Class[]{protocol}, (InvocationHandler)invoker);
                        Object result = callable.call(instance);
                        byte[] region = invoker.getRegionName();
                        if (callback != null) {
                            callback.update(region, byArray, result);
                        }
                        return result;
                    }
                });
                futures.put(byArray, future);
            }
            for (Map.Entry entry : futures.entrySet()) {
                try {
                    ((Future)entry.getValue()).get();
                }
                catch (ExecutionException ee) {
                    LOG.warn((Object)("Error executing for row " + Bytes.toStringBinary((byte[])entry.getKey())), (Throwable)ee);
                    throw ee.getCause();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted executing for row " + Bytes.toStringBinary((byte[])entry.getKey()), ie);
                }
            }
        }

        @Override
        public <R> void processBatchCallback(List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
            int i;
            if (results.length != list.size()) {
                throw new IllegalArgumentException("argument results must be the same size as argument list");
            }
            if (list.isEmpty()) {
                return;
            }
            HRegionLocation[] lastServers = new HRegionLocation[results.length];
            ArrayList<? extends Row> workingList = new ArrayList<Row>(list);
            boolean retry = true;
            int actionCount = 0;
            for (int tries = 0; tries < this.numRetries && retry; ++tries) {
                if (tries >= 1) {
                    long sleepTime = ConnectionUtils.getPauseTime(this.pause, tries);
                    LOG.debug((Object)("Retry " + tries + ", sleep for " + sleepTime + "ms!"));
                    Thread.sleep(sleepTime);
                }
                HashMap actionsByServer = new HashMap();
                for (int i2 = 0; i2 < workingList.size(); ++i2) {
                    Row row = (Row)workingList.get(i2);
                    if (row == null) continue;
                    HRegionLocation loc = this.locateRegion(tableName, row.getRow());
                    byte[] regionName = loc.getRegionInfo().getRegionName();
                    MultiAction actions = (MultiAction)actionsByServer.get(loc);
                    if (actions == null) {
                        actions = new MultiAction();
                        actionsByServer.put(loc, actions);
                    }
                    Action action = new Action(row, i2);
                    lastServers[i2] = loc;
                    actions.add(regionName, action);
                }
                HashMap futures = new HashMap(actionsByServer.size());
                for (Map.Entry e : actionsByServer.entrySet()) {
                    futures.put(e.getKey(), pool.submit(this.createCallable((HRegionLocation)e.getKey(), (MultiAction)e.getValue(), tableName)));
                }
                for (Map.Entry responsePerServer : futures.entrySet()) {
                    HRegionLocation loc = (HRegionLocation)responsePerServer.getKey();
                    try {
                        Future future = (Future)responsePerServer.getValue();
                        MultiResponse resp = (MultiResponse)future.get();
                        if (resp == null) {
                            LOG.debug((Object)("Failed all for server: " + loc.getHostnamePort() + ", removing from cache"));
                            continue;
                        }
                        for (Map.Entry<byte[], List<Pair<Integer, Object>>> e : resp.getResults().entrySet()) {
                            byte[] regionName = e.getKey();
                            List<Pair<Integer, Object>> regionResults = e.getValue();
                            for (Pair<Integer, Object> regionResult : regionResults) {
                                if (regionResult == null) {
                                    LOG.debug((Object)("Failures for region: " + Bytes.toStringBinary(regionName) + ", removing from cache"));
                                    continue;
                                }
                                results[regionResult.getFirst().intValue()] = regionResult.getSecond();
                                if (callback == null || regionResult.getSecond() instanceof Throwable) continue;
                                callback.update(e.getKey(), list.get(regionResult.getFirst()).getRow(), regionResult.getSecond());
                            }
                        }
                    }
                    catch (ExecutionException e) {
                        LOG.warn((Object)("Failed all from " + loc), (Throwable)e);
                    }
                }
                retry = false;
                workingList.clear();
                actionCount = 0;
                for (i = 0; i < results.length; ++i) {
                    if (results[i] == null || results[i] instanceof Throwable && !(results[i] instanceof DoNotRetryIOException)) {
                        retry = true;
                        ++actionCount;
                        Row row = list.get(i);
                        workingList.add(row);
                        this.deleteCachedLocation(tableName, row.getRow());
                        continue;
                    }
                    if (results[i] != null && results[i] instanceof Throwable) {
                        ++actionCount;
                    }
                    workingList.add(null);
                }
            }
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>(actionCount);
            ArrayList<Row> actions = new ArrayList<Row>(actionCount);
            ArrayList<String> addresses = new ArrayList<String>(actionCount);
            for (i = 0; i < results.length; ++i) {
                if (results[i] != null && !(results[i] instanceof Throwable)) continue;
                exceptions.add((Throwable)results[i]);
                actions.add(list.get(i));
                addresses.add(lastServers[i].getHostnamePort());
            }
            if (!exceptions.isEmpty()) {
                throw new RetriesExhaustedWithDetailsException(exceptions, actions, addresses);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getNumberOfCachedRegionLocations(byte[] tableName) {
            Integer key = Bytes.mapKey(tableName);
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                Map tableLocs = this.cachedRegionLocations.get(key);
                if (tableLocs == null) {
                    return 0;
                }
                return tableLocs.values().size();
            }
        }

        boolean isRegionCached(byte[] tableName, byte[] row) {
            HRegionLocation location = this.getCachedLocation(tableName, row);
            return location != null;
        }

        @Override
        public void setRegionCachePrefetch(byte[] tableName, boolean enable) {
            if (!enable) {
                this.regionCachePrefetchDisabledTables.add(Bytes.mapKey(tableName));
            } else {
                this.regionCachePrefetchDisabledTables.remove(Bytes.mapKey(tableName));
            }
        }

        @Override
        public boolean getRegionCachePrefetch(byte[] tableName) {
            return !this.regionCachePrefetchDisabledTables.contains(Bytes.mapKey(tableName));
        }

        @Override
        public void prewarmRegionCache(byte[] tableName, Map<HRegionInfo, HServerAddress> regions) {
            for (Map.Entry<HRegionInfo, HServerAddress> e : regions.entrySet()) {
                HServerAddress hsa = e.getValue();
                if (hsa == null || hsa.getInetSocketAddress() == null) continue;
                this.cacheLocation(tableName, new HRegionLocation(e.getKey(), hsa.getHostname(), hsa.getPort()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort(String msg, Throwable t) {
            if (t instanceof KeeperException) {
                LOG.info((Object)"This client just lost it's session with ZooKeeper, will automatically reconnect when needed.");
                if (t instanceof KeeperException.SessionExpiredException) {
                    LOG.info((Object)"ZK session expired. This disconnect could have been caused by a network partition or a long-running GC pause, either way it's recommended that you verify your environment.");
                    Object object = this.resetLock;
                    synchronized (object) {
                        if (this.resetting) {
                            return;
                        }
                        this.resetting = true;
                    }
                    this.resetZooKeeperTrackers();
                    this.resetting = false;
                }
                return;
            }
            if (t != null) {
                LOG.fatal((Object)msg, t);
            } else {
                LOG.fatal((Object)msg);
            }
            this.aborted = true;
            this.close();
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public boolean isAborted() {
            return this.aborted;
        }

        @Override
        public int getCurrentNrHRS() throws IOException {
            try {
                ZooKeeperWatcher zkw = this.getZooKeeperWatcher();
                return ZKUtil.getNumberOfChildren(zkw, zkw.rsZNode);
            }
            catch (KeeperException ke) {
                throw new IOException("Unexpected ZooKeeper exception", ke);
            }
        }

        void incCount() {
            ++this.refCount;
        }

        void decCount() {
            if (this.refCount > 0) {
                --this.refCount;
            }
        }

        boolean isZeroReference() {
            return this.refCount == 0;
        }

        void internalClose() {
            if (this.closed) {
                return;
            }
            this.master = null;
            this.servers.clear();
            if (this.rpcEngine != null) {
                this.rpcEngine.close();
            }
            if (this.zooKeeper != null) {
                LOG.info((Object)("Closed zookeeper sessionid=0x" + Long.toHexString(this.zooKeeper.getRecoverableZooKeeper().getSessionId())));
                this.zooKeeper.close();
                this.zooKeeper = null;
            }
            this.closed = true;
        }

        @Override
        public void close() {
            if (this.managed) {
                if (this.aborted) {
                    HConnectionManager.deleteStaleConnection(this);
                } else {
                    HConnectionManager.deleteConnection(this, false);
                }
            } else {
                this.internalClose();
            }
            if (LOG.isTraceEnabled()) {
                LOG.debug((Object)("" + this.zooKeeper + " closed."));
            }
        }

        protected void finalize() throws Throwable {
            this.refCount = 1;
            this.close();
            LOG.debug((Object)("The connection to " + this.zooKeeper + " was closed by the finalize method."));
        }

        @Override
        public HTableDescriptor[] listTables() throws IOException {
            if (this.master == null) {
                this.master = this.getMaster();
            }
            HTableDescriptor[] htd = this.master.getHTableDescriptors();
            return htd;
        }

        @Override
        public HTableDescriptor[] getHTableDescriptors(List<String> tableNames) throws IOException {
            if (tableNames == null || tableNames.isEmpty()) {
                return new HTableDescriptor[0];
            }
            if (tableNames == null || tableNames.size() == 0) {
                return null;
            }
            if (this.master == null) {
                this.master = this.getMaster();
            }
            return this.master.getHTableDescriptors(tableNames);
        }

        @Override
        public HTableDescriptor getHTableDescriptor(byte[] tableName) throws IOException {
            HTableDescriptor[] htds;
            if (tableName == null || tableName.length == 0) {
                return null;
            }
            if (Bytes.equals(tableName, HConstants.ROOT_TABLE_NAME)) {
                return new UnmodifyableHTableDescriptor(HTableDescriptor.ROOT_TABLEDESC);
            }
            if (Bytes.equals(tableName, HConstants.META_TABLE_NAME)) {
                return HTableDescriptor.META_TABLEDESC;
            }
            if (this.master == null) {
                this.master = this.getMaster();
            }
            if ((htds = this.master.getHTableDescriptors()) != null && htds.length > 0) {
                for (HTableDescriptor htd : htds) {
                    if (!Bytes.equals(tableName, htd.getName())) continue;
                    return htd;
                }
            }
            throw new TableNotFoundException(Bytes.toString(tableName));
        }
    }

    public static class HConnectionKey {
        public static String[] CONNECTION_PROPERTIES = new String[]{"hbase.zookeeper.quorum", "zookeeper.znode.parent", "hbase.zookeeper.property.clientPort", "hbase.zookeeper.recoverable.waittime", HConstants.HBASE_CLIENT_PAUSE, HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.HBASE_CLIENT_RPC_MAXATTEMPTS, HConstants.HBASE_RPC_TIMEOUT_KEY, HConstants.HBASE_CLIENT_PREFETCH_LIMIT, HConstants.HBASE_META_SCANNER_CACHING, HConstants.HBASE_CLIENT_INSTANCE_ID};
        private Map<String, String> properties;
        private String username;

        public HConnectionKey(Configuration conf) {
            HashMap<String, String> m = new HashMap<String, String>();
            if (conf != null) {
                for (String property : CONNECTION_PROPERTIES) {
                    String value = conf.get(property);
                    if (value == null) continue;
                    m.put(property, value);
                }
            }
            this.properties = Collections.unmodifiableMap(m);
            try {
                User currentUser = User.getCurrent();
                if (currentUser != null) {
                    this.username = currentUser.getName();
                }
            }
            catch (IOException ioe) {
                LOG.warn((Object)"Error obtaining current user, skipping username in HConnectionKey", (Throwable)ioe);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            if (this.username != null) {
                result = this.username.hashCode();
            }
            for (String property : CONNECTION_PROPERTIES) {
                String value = this.properties.get(property);
                if (value == null) continue;
                result = 31 * result + value.hashCode();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HConnectionKey that = (HConnectionKey)obj;
            if (this.username != null && !this.username.equals(that.username)) {
                return false;
            }
            if (this.username == null && that.username != null) {
                return false;
            }
            if (this.properties == null) {
                if (that.properties != null) {
                    return false;
                }
            } else {
                if (that.properties == null) {
                    return false;
                }
                for (String property : CONNECTION_PROPERTIES) {
                    String thatValue;
                    String thisValue = this.properties.get(property);
                    if (thisValue == (thatValue = that.properties.get(property)) || thisValue != null && thisValue.equals(thatValue)) continue;
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return "HConnectionKey{properties=" + this.properties + ", username='" + this.username + '\'' + '}';
        }
    }

    public static abstract class HConnectable<T> {
        public Configuration conf;

        public HConnectable(Configuration conf) {
            this.conf = conf;
        }

        public abstract T connect(HConnection var1) throws IOException;
    }
}

