/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.replication.ReplicationZookeeper;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class ReplicationAdmin
implements Closeable {
    private final ReplicationZookeeper replicationZk;
    private final HConnection connection;

    public ReplicationAdmin(Configuration conf) throws IOException {
        if (!conf.getBoolean("hbase.replication", false)) {
            throw new RuntimeException("hbase.replication isn't true, please enable it in order to use replication");
        }
        this.connection = HConnectionManager.getConnection(conf);
        ZooKeeperWatcher zkw = this.connection.getZooKeeperWatcher();
        try {
            this.replicationZk = new ReplicationZookeeper(this.connection, conf, zkw);
        }
        catch (KeeperException e) {
            throw new IOException("Unable setup the ZooKeeper connection", e);
        }
    }

    public void addPeer(String id, String clusterKey) throws IOException {
        this.replicationZk.addPeer(id, clusterKey);
    }

    public void removePeer(String id) throws IOException {
        this.replicationZk.removePeer(id);
    }

    public void enablePeer(String id) throws IOException {
        this.replicationZk.enablePeer(id);
    }

    public void disablePeer(String id) throws IOException {
        this.replicationZk.disablePeer(id);
    }

    public int getPeersCount() {
        return this.replicationZk.listPeersIdsAndWatch().size();
    }

    public Map<String, String> listPeers() {
        return this.replicationZk.listPeers();
    }

    public String getPeerState(String id) throws IOException {
        try {
            return this.replicationZk.getPeerState(id).name();
        }
        catch (KeeperException e) {
            throw new IOException("Couldn't get the state of the peer " + id, e);
        }
    }

    public boolean getReplicating() throws IOException {
        try {
            return this.replicationZk.getReplication();
        }
        catch (KeeperException e) {
            throw new IOException("Couldn't get the replication status");
        }
    }

    public boolean setReplicating(boolean newState) throws IOException {
        boolean prev = true;
        try {
            prev = this.getReplicating();
            this.replicationZk.setReplicating(newState);
        }
        catch (KeeperException e) {
            throw new IOException("Unable to set the replication state", e);
        }
        return prev;
    }

    ReplicationZookeeper getReplicationZk() {
        return this.replicationZk;
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

