/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.BulkAssigner;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.zookeeper.KeeperException;

public class EnableTableHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(EnableTableHandler.class);
    private final byte[] tableName;
    private final String tableNameStr;
    private final AssignmentManager assignmentManager;
    private final CatalogTracker ct;
    private boolean retainAssignment = false;

    public EnableTableHandler(Server server, byte[] tableName, CatalogTracker catalogTracker, AssignmentManager assignmentManager, boolean skipTableStateCheck) throws TableNotFoundException, TableNotDisabledException, IOException {
        super(server, EventHandler.EventType.C_M_ENABLE_TABLE);
        this.tableName = tableName;
        this.tableNameStr = Bytes.toString(tableName);
        this.ct = catalogTracker;
        this.assignmentManager = assignmentManager;
        this.retainAssignment = skipTableStateCheck;
        if (!MetaReader.tableExists(catalogTracker, this.tableNameStr)) {
            throw new TableNotFoundException(Bytes.toString(tableName));
        }
        if (!skipTableStateCheck) {
            try {
                if (!this.assignmentManager.getZKTable().checkDisabledAndSetEnablingTable(this.tableNameStr)) {
                    LOG.info((Object)("Table " + this.tableNameStr + " isn't disabled; skipping enable"));
                    throw new TableNotDisabledException(this.tableNameStr);
                }
            }
            catch (KeeperException e) {
                throw new IOException("Unable to ensure that the table will be enabling because of a ZooKeeper issue", e);
            }
        }
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.tableNameStr;
    }

    @Override
    public void process() {
        try {
            LOG.info((Object)("Attemping to enable the table " + this.tableNameStr));
            this.handleEnableTable();
        }
        catch (IOException e) {
            LOG.error((Object)("Error trying to enable the table " + this.tableNameStr), (Throwable)e);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Error trying to enable the table " + this.tableNameStr), (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Error trying to enable the table " + this.tableNameStr), (Throwable)e);
        }
    }

    private void handleEnableTable() throws IOException, KeeperException, InterruptedException {
        this.assignmentManager.getZKTable().setEnablingTable(this.tableNameStr);
        boolean done = false;
        List<Pair<HRegionInfo, ServerName>> tableRegionsAndLocations = MetaReader.getTableRegionsAndLocations(this.ct, this.tableName, true);
        int countOfRegionsInTable = tableRegionsAndLocations.size();
        List<HRegionInfo> regions = this.regionsToAssignWithServerName(tableRegionsAndLocations);
        int regionsCount = regions.size();
        if (regionsCount == 0) {
            done = true;
        }
        LOG.info((Object)("Table has " + countOfRegionsInTable + " regions of which " + regionsCount + " are offline."));
        BulkEnabler bd = new BulkEnabler(this.server, regions, countOfRegionsInTable, this.retainAssignment);
        try {
            if (bd.bulkAssign()) {
                done = true;
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Enable was interrupted");
            Thread.currentThread().interrupt();
        }
        if (done) {
            this.assignmentManager.getZKTable().setEnabledTable(this.tableNameStr);
        }
        LOG.info((Object)("Enabled table is done=" + done));
    }

    private List<HRegionInfo> regionsToAssignWithServerName(List<Pair<HRegionInfo, ServerName>> regionsInMeta) throws IOException {
        ServerManager serverManager = ((HMaster)this.server).getServerManager();
        ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>();
        List<HRegionInfo> enablingTableRegions = this.assignmentManager.getEnablingTableRegions(this.tableNameStr);
        List<HRegionInfo> onlineRegions = this.assignmentManager.getRegionsOfTable(this.tableName);
        for (Pair<HRegionInfo, ServerName> regionLocation : regionsInMeta) {
            HRegionInfo hri = regionLocation.getFirst();
            ServerName sn = regionLocation.getSecond();
            if (this.retainAssignment) {
                if (enablingTableRegions == null || !enablingTableRegions.contains((Object)hri)) continue;
                regions.add(hri);
                if (sn == null || !serverManager.isServerOnline(sn)) continue;
                this.assignmentManager.addPlan(hri.getEncodedName(), new RegionPlan(hri, null, sn));
                continue;
            }
            if (onlineRegions.contains((Object)hri)) continue;
            regions.add(hri);
        }
        return regions;
    }

    class BulkEnabler
    extends BulkAssigner {
        private final List<HRegionInfo> regions;
        private final int countOfRegionsInTable;
        private final boolean retainAssignment;

        BulkEnabler(Server server, List<HRegionInfo> regions, int countOfRegionsInTable, boolean retainAssignment) {
            super(server);
            this.regions = regions;
            this.countOfRegionsInTable = countOfRegionsInTable;
            this.retainAssignment = retainAssignment;
        }

        @Override
        protected void populatePool(ExecutorService pool) throws IOException {
            boolean roundRobinAssignment = this.server.getConfiguration().getBoolean("hbase.master.enabletable.roundrobin", false);
            if (this.retainAssignment || !roundRobinAssignment) {
                for (HRegionInfo region : this.regions) {
                    if (EnableTableHandler.this.assignmentManager.isRegionInTransition(region) != null) continue;
                    final HRegionInfo hri = region;
                    pool.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (BulkEnabler.this.retainAssignment) {
                                EnableTableHandler.this.assignmentManager.assign(hri, true, false, false);
                            } else {
                                EnableTableHandler.this.assignmentManager.assign(hri, true);
                            }
                        }
                    });
                }
            } else {
                try {
                    EnableTableHandler.this.assignmentManager.assignUserRegionsToOnlineServers(this.regions);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Assignment was interrupted");
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        protected boolean waitUntilDone(long timeout) throws InterruptedException {
            long startTime = System.currentTimeMillis();
            long remaining = timeout;
            List<HRegionInfo> regions = null;
            int lastNumberOfRegions = 0;
            while (!this.server.isStopped() && remaining > 0L) {
                Thread.sleep(EnableTableHandler.this.waitingTimeForEvents);
                regions = EnableTableHandler.this.assignmentManager.getRegionsOfTable(EnableTableHandler.this.tableName);
                if (this.isDone(regions)) break;
                if (regions.size() > lastNumberOfRegions) {
                    lastNumberOfRegions = regions.size();
                    timeout += (long)EnableTableHandler.this.waitingTimeForEvents;
                }
                remaining = timeout - (System.currentTimeMillis() - startTime);
            }
            return this.isDone(regions);
        }

        private boolean isDone(List<HRegionInfo> regions) {
            return regions != null && regions.size() >= this.countOfRegionsInTable;
        }
    }
}

