/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.BulkReOpen;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.zookeeper.KeeperException;

public abstract class TableEventHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(TableEventHandler.class);
    protected final MasterServices masterServices;
    protected final byte[] tableName;
    protected final String tableNameStr;
    protected boolean isEventBeingHandled = false;

    public TableEventHandler(EventHandler.EventType eventType, byte[] tableName, Server server, MasterServices masterServices) throws IOException {
        super(server, eventType);
        this.masterServices = masterServices;
        this.tableName = tableName;
        try {
            this.masterServices.checkTableModifiable(tableName);
        }
        catch (TableNotDisabledException ex) {
            if (this.isOnlineSchemaChangeAllowed() && eventType.isOnlineSchemaChangeSupported()) {
                LOG.debug((Object)"Ignoring table not disabled exception for supporting online schema changes.");
            }
            throw ex;
        }
        this.tableNameStr = Bytes.toString(this.tableName);
    }

    private boolean isOnlineSchemaChangeAllowed() {
        return this.server.getConfiguration().getBoolean("hbase.online.schema.update.enable", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            LOG.info((Object)("Handling table operation " + (Object)((Object)this.eventType) + " on table " + Bytes.toString(this.tableName)));
            List<HRegionInfo> hris = MetaReader.getTableRegions(this.server.getCatalogTracker(), this.tableName);
            this.handleTableOperation(hris);
            if (this.eventType.isOnlineSchemaChangeSupported() && this.masterServices.getAssignmentManager().getZKTable().isEnabledTable(Bytes.toString(this.tableName))) {
                if (this.reOpenAllRegions(hris)) {
                    LOG.info((Object)("Completed table operation " + (Object)((Object)this.eventType) + " on table " + Bytes.toString(this.tableName)));
                } else {
                    LOG.warn((Object)"Error on reopening the regions");
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Error manipulating table " + Bytes.toString(this.tableName)), (Throwable)e);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Error manipulating table " + Bytes.toString(this.tableName)), (Throwable)e);
        }
        finally {
            this.notifyEventBeingHandled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reOpenAllRegions(List<HRegionInfo> regions) throws IOException {
        NavigableMap<HRegionInfo, ServerName> hriHserverMapping;
        boolean done = false;
        HTable table = null;
        TreeMap serverToRegions = Maps.newTreeMap();
        LOG.info((Object)"Bucketing regions by region server...");
        try {
            table = new HTable(this.masterServices.getConfiguration(), this.tableName);
            hriHserverMapping = table.getRegionLocations();
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
        ArrayList<HRegionInfo> reRegions = new ArrayList<HRegionInfo>();
        for (HRegionInfo hri : regions) {
            ServerName rsLocation = (ServerName)hriHserverMapping.get((Object)hri);
            if (null == rsLocation) {
                LOG.info((Object)("Skip " + (Object)((Object)hri)));
                continue;
            }
            if (!serverToRegions.containsKey(rsLocation)) {
                LinkedList hriList = Lists.newLinkedList();
                serverToRegions.put(rsLocation, hriList);
            }
            reRegions.add(hri);
            ((List)serverToRegions.get(rsLocation)).add(hri);
        }
        LOG.info((Object)("Reopening " + reRegions.size() + " regions on " + serverToRegions.size() + " region servers."));
        this.masterServices.getAssignmentManager().setRegionsToReopen(reRegions);
        this.notifyEventBeingHandled();
        BulkReOpen bulkReopen = new BulkReOpen(this.server, serverToRegions, this.masterServices.getAssignmentManager());
        try {
            while (true) {
                if (bulkReopen.bulkReOpen()) {
                    done = true;
                    break;
                }
                LOG.warn((Object)"Timeout before reopening all regions");
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Reopen was interrupted");
            Thread.currentThread().interrupt();
        }
        return done;
    }

    public HTableDescriptor getTableDescriptor() throws FileNotFoundException, IOException {
        String name = Bytes.toString(this.tableName);
        HTableDescriptor htd = this.masterServices.getTableDescriptors().get(name);
        if (htd == null) {
            throw new IOException("HTableDescriptor missing for " + name);
        }
        return htd;
    }

    byte[] hasColumnFamily(HTableDescriptor htd, byte[] cf) throws InvalidFamilyOperationException {
        if (!htd.hasFamily(cf)) {
            throw new InvalidFamilyOperationException("Column family '" + Bytes.toString(cf) + "' does not exist");
        }
        return cf;
    }

    protected abstract void handleTableOperation(List<HRegionInfo> var1) throws IOException, KeeperException;

    public synchronized void waitForEventBeingHandled() throws IOException {
        if (!this.isEventBeingHandled) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                throw (IOException)new InterruptedIOException().initCause(ie);
            }
        }
    }

    private synchronized void notifyEventBeingHandled() {
        if (!this.isEventBeingHandled) {
            this.isEventBeingHandled = true;
            this.notify();
        }
    }
}

